/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.config;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kerby.config.Config;
import org.apache.kerby.config.ConfigImpl;
import org.apache.kerby.config.ConfigKey;
import org.apache.kerby.config.ConfigLoader;
import org.apache.kerby.config.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conf
implements Config {
    private static final Logger LOGGER = LoggerFactory.getLogger(Conf.class);
    private List<ConfigLoader> resourceConfigs = new ArrayList<ConfigLoader>(1);
    private final ConfigImpl config = new ConfigImpl("Conf");

    public void addXmlConfig(File xmlFile) throws IOException {
        this.addResource(Resource.createXmlResource(xmlFile));
    }

    public void addIniConfig(File iniFile) throws IOException {
        this.addResource(Resource.createIniResource(iniFile));
    }

    public void addJsonConfig(File jsonFile) throws IOException {
        this.addResource(Resource.createJsonResource(jsonFile));
    }

    public void addPropertiesConfig(File propertiesFile) throws IOException {
        this.addResource(Resource.createPropertiesFileResource(propertiesFile));
    }

    public void addPropertiesConfig(Properties propertiesConfig) {
        this.addResource(Resource.createPropertiesResource(propertiesConfig));
    }

    public void addMapConfig(Map<String, Object> mapConfig) {
        this.addResource(Resource.createMapResource(mapConfig));
    }

    public synchronized void addResource(Resource resource) {
        ConfigLoader loader = Conf.getLoader(resource);
        this.resourceConfigs.add(loader);
        Config loaded = loader.load();
        this.config.add(loaded);
    }

    private static ConfigLoader getLoader(Resource resource) {
        ConfigLoader loader = null;
        Class<? extends ConfigLoader> loaderClass = resource.getFormat().getLoaderClass();
        try {
            loader = loaderClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create " + Conf.class.getPackage().getName() + " for " + loaderClass.getName(), e);
            throw new RuntimeException("Failed to create " + Conf.class.getPackage().getName() + " for " + loaderClass.getName(), e);
        }
        loader.setResource(resource);
        return loader;
    }

    public synchronized void reload() {
        this.config.reset();
        for (ConfigLoader loader : this.resourceConfigs) {
            Config loaded = loader.load();
            this.config.add(loaded);
        }
    }

    @Override
    public String getResource() {
        return this.config.getResource();
    }

    @Override
    public Set<String> getNames() {
        return this.config.getNames();
    }

    @Override
    public String getString(String name) {
        return this.config.getString(name);
    }

    @Override
    public String getString(ConfigKey name, boolean useDefault) {
        return this.config.getString(name, useDefault);
    }

    @Override
    public synchronized String getString(String name, String defaultValue) {
        return this.config.getString(name, defaultValue);
    }

    @Override
    public synchronized void setString(String name, String value) {
        this.config.set(name, value);
    }

    @Override
    public void setString(ConfigKey name, String value) {
        this.setString(name.getPropertyKey(), value);
    }

    @Override
    public String getTrimmed(String name) {
        return this.config.getTrimmed(name);
    }

    @Override
    public String getTrimmed(ConfigKey name) {
        return this.config.getTrimmed(name);
    }

    @Override
    public Boolean getBoolean(String name) {
        return this.config.getBoolean(name);
    }

    @Override
    public Boolean getBoolean(ConfigKey name, boolean useDefault) {
        return this.config.getBoolean(name, useDefault);
    }

    @Override
    public Boolean getBoolean(String name, Boolean defaultValue) {
        return this.config.getBoolean(name, defaultValue);
    }

    @Override
    public void setBoolean(String name, Boolean value) {
        this.setString(name, String.valueOf(value));
    }

    @Override
    public void setBoolean(ConfigKey name, Boolean value) {
        this.setString(name.getPropertyKey(), String.valueOf(value));
    }

    @Override
    public Integer getInt(String name) {
        return this.config.getInt(name);
    }

    @Override
    public Integer getInt(ConfigKey name, boolean useDefault) {
        return this.config.getInt(name, useDefault);
    }

    @Override
    public Integer getInt(String name, Integer defaultValue) {
        return this.config.getInt(name, defaultValue);
    }

    @Override
    public void setInt(String name, Integer value) {
        this.setString(name, String.valueOf(value));
    }

    @Override
    public void setInt(ConfigKey name, Integer value) {
        this.setString(name.getPropertyKey(), String.valueOf(value));
    }

    @Override
    public Long getLong(String name) {
        return this.config.getLong(name);
    }

    @Override
    public Long getLong(ConfigKey name, boolean useDefault) {
        return this.config.getLong(name, useDefault);
    }

    @Override
    public Long getLong(String name, Long defaultValue) {
        return this.config.getLong(name, defaultValue);
    }

    @Override
    public void setLong(String name, Long value) {
        this.setString(name, String.valueOf(value));
    }

    @Override
    public void setLong(ConfigKey name, Long value) {
        this.setString(name.getPropertyKey(), String.valueOf(value));
    }

    @Override
    public Float getFloat(String name) {
        return this.config.getFloat(name);
    }

    @Override
    public Float getFloat(ConfigKey name, boolean useDefault) {
        return this.config.getFloat(name, useDefault);
    }

    @Override
    public Float getFloat(String name, Float defaultValue) {
        return this.config.getFloat(name, defaultValue);
    }

    @Override
    public void setFloat(String name, Float value) {
        this.setString(name, String.valueOf(value));
    }

    @Override
    public void setFloat(ConfigKey name, Float value) {
        this.setString(name.getPropertyKey(), String.valueOf(value));
    }

    @Override
    public List<String> getList(String name) {
        return this.config.getList(name);
    }

    @Override
    public List<String> getList(String name, String[] defaultValue) {
        return this.config.getList(name, defaultValue);
    }

    @Override
    public List<String> getList(ConfigKey name) {
        return this.config.getList(name);
    }

    @Override
    public Config getConfig(String name) {
        return this.config.getConfig(name);
    }

    @Override
    public Config getConfig(ConfigKey name) {
        return this.config.getConfig(name);
    }

    @Override
    public Class<?> getClass(String name) throws ClassNotFoundException {
        return this.config.getClass(name);
    }

    @Override
    public Class<?> getClass(String name, Class<?> defaultValue) throws ClassNotFoundException {
        return this.config.getClass(name, defaultValue);
    }

    @Override
    public Class<?> getClass(ConfigKey name, boolean useDefault) throws ClassNotFoundException {
        return this.config.getClass(name, useDefault);
    }

    @Override
    public <T> T getInstance(String name) throws ClassNotFoundException {
        return this.config.getInstance(name);
    }

    @Override
    public <T> T getInstance(ConfigKey name) throws ClassNotFoundException {
        return this.config.getInstance(name);
    }

    @Override
    public <T> T getInstance(String name, Class<T> xface) throws ClassNotFoundException {
        return this.config.getInstance(name, xface);
    }
}

