/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jibx.runtime.IXMLReader;
import org.jibx.runtime.IntStack;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.GrowableStringArray;

public class StAXReaderWrapper
implements IXMLReader {
    static final byte[] s_eventTranslations = new byte[256];
    private final XMLStreamReader m_parser;
    final boolean m_isNamespaceAware;
    private final String m_docName;
    int m_nestingDepth;
    private IntStack m_inScopeCounts;
    private GrowableStringArray m_inScopeUris;
    private GrowableStringArray m_inScopePrefixes;
    private String m_accumulatedText;
    private boolean m_isProcessingInstruction;
    private String m_encoding;

    public StAXReaderWrapper(XMLStreamReader rdr, String name, boolean nsa) {
        this.m_parser = rdr;
        this.m_docName = name;
        this.m_isNamespaceAware = nsa;
        this.m_inScopeCounts = new IntStack();
        this.m_inScopeCounts.push(0);
        this.m_inScopeUris = new GrowableStringArray();
        this.m_inScopePrefixes = new GrowableStringArray();
        if (rdr.isStartElement()) {
            this.startTag();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public String buildPositionString() {
        Location location = this.m_parser.getLocation();
        String base = "(line " + location.getLineNumber() + ", col " + location.getColumnNumber();
        if (this.m_docName != null) {
            base = base + ", in " + this.m_docName;
        }
        return base + ')';
    }

    private void startTag() {
        ++this.m_nestingDepth;
        int count = this.m_parser.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            this.m_inScopeUris.add(this.m_parser.getNamespaceURI(i));
            this.m_inScopePrefixes.add(this.m_parser.getNamespacePrefix(i));
        }
        this.m_inScopeCounts.push(this.m_inScopeUris.size());
    }

    private void endTag() {
        --this.m_nestingDepth;
        int count = this.m_inScopeCounts.pop() - (this.m_nestingDepth > 0 ? this.m_inScopeCounts.peek() : 0);
        if (count > 0) {
            this.m_inScopeUris.remove(count);
            this.m_inScopePrefixes.remove(count);
        }
    }

    @Override
    public int nextToken() throws JiBXException {
        if (this.m_accumulatedText == null) {
            try {
                byte code;
                block8: while (true) {
                    code = s_eventTranslations[this.m_parser.next()];
                    switch (code) {
                        case 2: {
                            this.startTag();
                            break block8;
                        }
                        case 3: {
                            this.endTag();
                            break block8;
                        }
                        case 8: {
                            this.m_accumulatedText = this.m_parser.getPITarget() + ' ' + this.m_parser.getPIData();
                            this.m_isProcessingInstruction = true;
                            while (s_eventTranslations[this.m_parser.next()] == 0) {
                            }
                            break block8;
                        }
                        case 0: {
                            continue block8;
                        }
                    }
                    break;
                }
                return code;
            }
            catch (XMLStreamException e) {
                throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
            }
        }
        this.m_accumulatedText = null;
        this.m_isProcessingInstruction = false;
        byte code = s_eventTranslations[this.m_parser.getEventType()];
        if (code == 2) {
            this.startTag();
        } else if (code == 3) {
            this.endTag();
        }
        return code;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int next() throws JiBXException {
        String text = null;
        StringBuffer buff = null;
        try {
            if (this.m_nestingDepth == 0 && this.m_parser.getEventType() == 7) {
                this.m_encoding = this.m_parser.getEncoding();
                if (this.m_encoding == null) {
                    this.m_encoding = this.m_parser.getCharacterEncodingScheme();
                }
            }
            if (this.m_accumulatedText == null) {
                this.m_parser.next();
            } else {
                this.m_accumulatedText = null;
                this.m_isProcessingInstruction = false;
            }
            block9: while (true) {
                byte type = s_eventTranslations[this.m_parser.getEventType()];
                switch (type) {
                    case 6: {
                        if (this.m_parser.getText() == null) {
                            throw new JiBXException("Unexpanded entity reference in text at " + this.buildPositionString());
                        }
                    }
                    case 4: 
                    case 5: {
                        if (text == null) {
                            text = this.m_parser.getText();
                            break;
                        }
                        if (buff == null) {
                            buff = new StringBuffer(text);
                        }
                        buff.append(this.m_parser.getTextCharacters());
                        break;
                    }
                    case 3: {
                        if (text != null) break block9;
                        this.endTag();
                        return type;
                    }
                    case 2: {
                        if (text != null) break block9;
                        this.startTag();
                        return type;
                    }
                    case 1: {
                        if (text != null) break block9;
                        return type;
                    }
                }
                this.m_parser.next();
            }
            if (buff == null) {
                this.m_accumulatedText = text;
                return 4;
            }
            this.m_accumulatedText = buff.toString();
            return 4;
        }
        catch (XMLStreamException e) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
        }
    }

    @Override
    public int getEventType() throws JiBXException {
        if (this.m_accumulatedText == null) {
            return s_eventTranslations[this.m_parser.getEventType()];
        }
        if (this.m_isProcessingInstruction) {
            return 8;
        }
        return 4;
    }

    @Override
    public String getName() {
        return this.m_parser.getLocalName();
    }

    @Override
    public String getNamespace() {
        String uri = this.m_parser.getNamespaceURI();
        if (uri == null) {
            return "";
        }
        return uri;
    }

    @Override
    public String getPrefix() {
        String prefix = this.m_parser.getPrefix();
        if (prefix != null && prefix.length() == 0) {
            return null;
        }
        return prefix;
    }

    @Override
    public int getAttributeCount() {
        return this.m_parser.getAttributeCount();
    }

    @Override
    public String getAttributeName(int index) {
        try {
            return this.m_parser.getAttributeLocalName(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public String getAttributeNamespace(int index) {
        try {
            String uri = this.m_parser.getAttributeNamespace(index);
            if (uri == null) {
                return "";
            }
            return uri;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public String getAttributePrefix(int index) {
        try {
            String prefix = this.m_parser.getAttributePrefix(index);
            if (prefix != null && prefix.length() == 0) {
                return null;
            }
            return prefix;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public String getAttributeValue(int index) {
        try {
            return this.m_parser.getAttributeValue(index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public String getAttributeValue(String ns, String name) {
        return this.m_parser.getAttributeValue(ns, name);
    }

    @Override
    public String getText() {
        if (this.m_accumulatedText == null) {
            return this.m_parser.getText();
        }
        return this.m_accumulatedText;
    }

    @Override
    public int getNestingDepth() {
        return this.m_nestingDepth;
    }

    @Override
    public int getNamespaceCount(int depth) {
        return this.m_inScopeCounts.peek(this.m_nestingDepth - depth);
    }

    @Override
    public String getNamespaceUri(int index) {
        return this.m_inScopeUris.get(index);
    }

    @Override
    public String getNamespacePrefix(int index) {
        String prefix = this.m_inScopePrefixes.get(index);
        if (prefix != null && prefix.length() == 0) {
            return null;
        }
        return prefix;
    }

    @Override
    public String getDocumentName() {
        return this.m_docName;
    }

    @Override
    public int getLineNumber() {
        return this.m_parser.getLocation().getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.m_parser.getLocation().getColumnNumber();
    }

    @Override
    public String getNamespace(String prefix) {
        int index = this.m_inScopePrefixes.size();
        while (--index >= 0) {
            String comp = this.m_inScopePrefixes.get(index);
            if ((prefix != null || comp != null) && (prefix == null || !prefix.equals(comp))) continue;
            return this.m_inScopeUris.get(index);
        }
        return null;
    }

    @Override
    public String getInputEncoding() {
        return this.m_encoding == null ? "UTF-8" : this.m_encoding;
    }

    @Override
    public boolean isNamespaceAware() {
        return this.m_isNamespaceAware;
    }

    static {
        StAXReaderWrapper.s_eventTranslations[12] = 5;
        StAXReaderWrapper.s_eventTranslations[4] = 4;
        StAXReaderWrapper.s_eventTranslations[5] = 9;
        StAXReaderWrapper.s_eventTranslations[11] = 10;
        StAXReaderWrapper.s_eventTranslations[8] = 1;
        StAXReaderWrapper.s_eventTranslations[2] = 3;
        StAXReaderWrapper.s_eventTranslations[9] = 6;
        StAXReaderWrapper.s_eventTranslations[3] = 8;
        StAXReaderWrapper.s_eventTranslations[6] = 7;
        StAXReaderWrapper.s_eventTranslations[7] = 0;
        StAXReaderWrapper.s_eventTranslations[1] = 2;
    }
}

