/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.Builder;
import org.apache.axiom.core.ChildNotAllowedException;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentFragment;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.ElementMatcher;
import org.apache.axiom.core.Mappers;
import org.apache.axiom.core.NodeIterator;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.impl.builder.BuilderImpl;
import org.apache.axiom.core.stream.NamespaceContextProvider;
import org.apache.axiom.core.stream.NamespaceRepairingFilterHandler;
import org.apache.axiom.core.stream.NamespaceURIInterningFilterHandler;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.sax.input.XmlHandlerContentHandler;
import org.apache.axiom.core.stream.serializer.Serializer;
import org.apache.axiom.core.stream.stax.pull.output.StAXPivot;
import org.apache.axiom.core.stream.stax.push.input.XMLStreamWriterNamespaceContextProvider;
import org.apache.axiom.dom.DOMAttribute;
import org.apache.axiom.dom.DOMCDATASection;
import org.apache.axiom.dom.DOMComment;
import org.apache.axiom.dom.DOMConfigurationImpl;
import org.apache.axiom.dom.DOMDocument;
import org.apache.axiom.dom.DOMDocumentFragment;
import org.apache.axiom.dom.DOMElement;
import org.apache.axiom.dom.DOMEntityReference;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.dom.DOMNSAwareAttribute;
import org.apache.axiom.dom.DOMNSAwareElement;
import org.apache.axiom.dom.DOMNSAwareNamedNode;
import org.apache.axiom.dom.DOMNSUnawareAttribute;
import org.apache.axiom.dom.DOMNSUnawareElement;
import org.apache.axiom.dom.DOMNamespaceDeclaration;
import org.apache.axiom.dom.DOMNode;
import org.apache.axiom.dom.DOMProcessingInstruction;
import org.apache.axiom.dom.DOMRootNode;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.dom.DOMText;
import org.apache.axiom.dom.DocumentWhitespaceFilter;
import org.apache.axiom.dom.ElementsByTagName;
import org.apache.axiom.dom.ElementsByTagNameNS;
import org.apache.axiom.dom.NSUtil;
import org.apache.axiom.mime.PartBlob;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.om.XOPEncoded;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.SAXResultContentHandler;
import org.apache.axiom.om.impl.common.builder.OMXMLParserWrapperImpl;
import org.apache.axiom.om.impl.dom.AxiomCoreParentNodeImpl;
import org.apache.axiom.om.impl.dom.intf.DOOMDocument;
import org.apache.axiom.om.impl.dom.intf.DOOMParentNode;
import org.apache.axiom.om.impl.intf.AxiomChildNode;
import org.apache.axiom.om.impl.intf.AxiomContainer;
import org.apache.axiom.om.impl.intf.AxiomDocument;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomSerializable;
import org.apache.axiom.om.impl.stream.NamespaceContextPreservationFilterHandler;
import org.apache.axiom.om.impl.stream.XmlDeclarationRewriterHandler;
import org.apache.axiom.om.impl.stream.XsiTypeFilterHandler;
import org.apache.axiom.om.impl.stream.sax.XMLReaderImpl;
import org.apache.axiom.om.impl.stream.stax.pull.AxiomXMLStreamReaderExtensionFactory;
import org.apache.axiom.om.impl.stream.stax.push.XMLStreamWriterHandler;
import org.apache.axiom.om.impl.stream.xop.ContentIDGenerator;
import org.apache.axiom.om.impl.stream.xop.ContentIDGeneratorImpl;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicy;
import org.apache.axiom.om.impl.stream.xop.OptimizationPolicyImpl;
import org.apache.axiom.om.impl.stream.xop.XOPEncodingFilterHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DOOMDocumentImpl
extends AxiomCoreParentNodeImpl
implements DOOMDocument,
DOOMParentNode,
DOMDocument,
Document,
AxiomDocument,
OMDocument,
DOMRootNode,
AxiomContainer {
    private String inputEncoding;
    private String xmlVersion = "1.0";
    private String xmlEncoding;
    private Boolean standalone;
    private final DOMConfigurationImpl domConfig = new DOMConfigurationImpl();
    private String documentURI;
    private boolean strictErrorChecking = true;
    private static final OMXMLStreamReaderConfiguration defaultReaderConfiguration = new OMXMLStreamReaderConfiguration();

    @Override
    public final NodeType coreGetNodeType() {
        return NodeType.DOCUMENT;
    }

    @Override
    public final CoreNode getRootOrOwnerDocument() {
        return this;
    }

    @Override
    public final void coreSetOwnerDocument(CoreDocument document) {
        if (document != this) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public final CoreElement coreGetDocumentElement() throws CoreModelException {
        for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
            if (!(child instanceof CoreElement)) continue;
            return (CoreElement)child;
        }
        return null;
    }

    @Override
    public final String coreGetInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public final void coreSetInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    @Override
    public final String coreGetXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public final void coreSetXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    @Override
    public final String coreGetXmlEncoding() {
        return this.xmlEncoding;
    }

    @Override
    public final void coreSetXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
    }

    @Override
    public final Boolean coreGetStandalone() {
        return this.standalone;
    }

    @Override
    public final void coreSetStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) {
        CoreDocument o = (CoreDocument)other;
        this.coreSetXmlVersion(o.coreGetXmlVersion());
        this.coreSetXmlEncoding(o.coreGetXmlEncoding());
        this.coreSetStandalone(o.coreGetStandalone());
        this.coreSetInputEncoding(o.coreGetInputEncoding());
    }

    @Override
    public final void serializeStartEvent(XmlHandler handler) throws CoreModelException, StreamException {
        handler.startDocument(this.coreGetInputEncoding(), this.coreGetXmlVersion(), this.coreGetXmlEncoding(), this.coreGetStandalone());
    }

    @Override
    public final void serializeEndEvent(XmlHandler handler) throws StreamException {
        handler.completed();
    }

    @Override
    final void internalCheckNewChild0(CoreChildNode newChild, CoreChildNode replacedChild) throws CoreModelException {
        if (newChild instanceof CoreElement && !(replacedChild instanceof CoreElement) && this.coreGetDocumentElement() != null) {
            throw new ChildNotAllowedException();
        }
    }

    @Override
    public final Document getOwnerDocument() {
        return null;
    }

    @Override
    public final String getNodeName() {
        return "#document";
    }

    @Override
    public final short getNodeType() {
        return 9;
    }

    @Override
    public final String getNodeValue() {
        return null;
    }

    @Override
    public final void setNodeValue(String nodeValue) {
    }

    @Override
    public final String getPrefix() {
        return null;
    }

    @Override
    public final void setPrefix(String prefix) throws DOMException {
        throw DOMExceptionUtil.newDOMException((short)14);
    }

    @Override
    public final String getNamespaceURI() {
        return null;
    }

    @Override
    public final String getLocalName() {
        return null;
    }

    @Override
    public final boolean hasAttributes() {
        return false;
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public final String getTextContent() {
        return null;
    }

    @Override
    public final void setTextContent(String textContent) {
    }

    @Override
    public final Element getDocumentElement() {
        try {
            return (Element)((Object)this.coreGetDocumentElement());
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final CoreElement getNamespaceContext() {
        try {
            return this.coreGetDocumentElement();
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final DOMImplementation getImplementation() {
        return this.getDOMNodeFactory();
    }

    @Override
    public final DOMConfiguration getDomConfig() {
        return this.domConfig;
    }

    @Override
    public final String getInputEncoding() {
        return this.coreGetInputEncoding();
    }

    @Override
    public final String getXmlVersion() {
        String version = this.coreGetXmlVersion();
        return version == null ? "1.0" : version;
    }

    @Override
    public final void setXmlVersion(String version) {
        this.coreSetXmlVersion(version);
    }

    @Override
    public final String getXmlEncoding() {
        return this.coreGetXmlEncoding();
    }

    @Override
    public final boolean getXmlStandalone() {
        Boolean standalone = this.coreGetStandalone();
        return standalone != null && standalone != false;
    }

    @Override
    public final void setXmlStandalone(boolean standalone) {
        this.coreSetStandalone(standalone);
    }

    @Override
    public final void normalizeDocument() {
        if (this.domConfig.isEnabled(1024) || this.domConfig.isEnabled(8192)) {
            throw new UnsupportedOperationException("TODO");
        }
        this.normalizeRecursively(this.domConfig);
    }

    @Override
    public final Text createTextNode(String data) {
        DOMText text = this.getDOMNodeFactory().createCharacterDataNode();
        text.coreSetOwnerDocument(this);
        text.coreSetCharacterData(data);
        return text;
    }

    @Override
    public final CDATASection createCDATASection(String data) {
        try {
            DOMCDATASection cdataSection = this.getDOMNodeFactory().createCDATASection();
            cdataSection.coreSetOwnerDocument(this);
            cdataSection.coreSetCharacterData(data, DOMSemantics.INSTANCE);
            return cdataSection;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Element createElement(String tagName) {
        NSUtil.validateName(tagName);
        DOMNSUnawareElement element = this.getDOMNodeFactory().createNSUnawareElement();
        element.coreSetOwnerDocument(this);
        element.coreSetName(tagName);
        return element;
    }

    @Override
    public final Attr createAttribute(String name) {
        NSUtil.validateName(name);
        DOMNSUnawareAttribute attr = this.getDOMNodeFactory().createNSUnawareAttribute();
        attr.coreSetOwnerDocument(this);
        attr.coreSetName(name);
        attr.coreSetType("CDATA");
        return attr;
    }

    @Override
    public final Element createElementNS(String namespaceURI, String qualifiedName) {
        String localName;
        String prefix;
        int i = NSUtil.validateQualifiedName(qualifiedName);
        if (i == -1) {
            prefix = "";
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, i);
            localName = qualifiedName.substring(i + 1);
        }
        namespaceURI = NSUtil.normalizeNamespaceURI(namespaceURI);
        NSUtil.validateNamespace(namespaceURI, prefix);
        DOMNSAwareElement element = this.getDOMNodeFactory().createNSAwareElement();
        element.coreSetOwnerDocument(this);
        element.coreSetName(namespaceURI, localName, prefix);
        return element;
    }

    @Override
    public final Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        String localName;
        String prefix;
        int i = NSUtil.validateQualifiedName(qualifiedName);
        if (i == -1) {
            prefix = "";
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, i);
            localName = qualifiedName.substring(i + 1);
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            DOMNamespaceDeclaration decl = this.getDOMNodeFactory().createNamespaceDeclaration();
            decl.coreSetOwnerDocument(this);
            decl.coreSetDeclaredNamespace(NSUtil.getDeclaredPrefix(localName, prefix), "");
            return decl;
        }
        namespaceURI = NSUtil.normalizeNamespaceURI(namespaceURI);
        NSUtil.validateAttributeName(namespaceURI, localName, prefix);
        DOMNSAwareAttribute attr = this.getDOMNodeFactory().createNSAwareAttribute();
        attr.coreSetOwnerDocument(this);
        attr.coreSetName(namespaceURI, localName, prefix);
        return attr;
    }

    @Override
    public final ProcessingInstruction createProcessingInstruction(String target, String data) {
        try {
            DOMProcessingInstruction pi = this.getDOMNodeFactory().createProcessingInstruction();
            pi.coreSetOwnerDocument(this);
            pi.coreSetTarget(target);
            pi.coreSetCharacterData(data, DOMSemantics.INSTANCE);
            return pi;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final EntityReference createEntityReference(String name) throws DOMException {
        DOMEntityReference node = this.getDOMNodeFactory().createEntityReference();
        node.coreSetOwnerDocument(this);
        node.coreSetName(name);
        return node;
    }

    @Override
    public final Comment createComment(String data) {
        try {
            DOMComment node = this.getDOMNodeFactory().createComment();
            node.coreSetOwnerDocument(this);
            node.coreSetCharacterData(data, DOMSemantics.INSTANCE);
            return node;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final DocumentFragment createDocumentFragment() {
        DOMDocumentFragment fragment = this.getDOMNodeFactory().createDocumentFragment();
        fragment.coreSetOwnerDocument(this);
        return fragment;
    }

    @Override
    public final NodeList getElementsByTagName(String tagname) {
        return new ElementsByTagName(this, tagname);
    }

    @Override
    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return new ElementsByTagNameNS(this, namespaceURI, localName);
    }

    @Override
    public final Node renameNode(Node node, String namespaceURI, String qualifiedName) {
        String localName;
        String prefix;
        if (!(node instanceof DOMNode) || !((DOMNode)node).coreHasSameOwnerDocument(this)) {
            throw DOMExceptionUtil.newDOMException((short)4);
        }
        if (!(node instanceof DOMNSAwareNamedNode)) {
            throw DOMExceptionUtil.newDOMException((short)9);
        }
        int i = NSUtil.validateQualifiedName(qualifiedName);
        if (i == -1) {
            prefix = "";
            localName = qualifiedName;
        } else {
            prefix = qualifiedName.substring(0, i);
            localName = qualifiedName.substring(i + 1);
        }
        namespaceURI = NSUtil.normalizeNamespaceURI(namespaceURI);
        switch (((DOMNode)node).coreGetNodeType()) {
            case NS_AWARE_ELEMENT: {
                NSUtil.validateNamespace(namespaceURI, prefix);
                ((DOMNSAwareElement)node).coreSetName(namespaceURI, localName, prefix);
                return node;
            }
            case NS_AWARE_ATTRIBUTE: {
                if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                    DOMNamespaceDeclaration decl = this.getDOMNodeFactory().createNamespaceDeclaration();
                    decl.coreSetOwnerDocument(this);
                    decl.coreSetDeclaredNamespace(NSUtil.getDeclaredPrefix(localName, prefix), ((DOMNSAwareAttribute)node).getValue());
                    return decl;
                }
                NSUtil.validateAttributeName(namespaceURI, localName, prefix);
                ((DOMNSAwareAttribute)node).coreSetName(namespaceURI, localName, prefix);
                return node;
            }
            case NAMESPACE_DECLARATION: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public final DocumentType getDoctype() {
        try {
            for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
                if (child instanceof DocumentType) {
                    return (DocumentType)((Object)child);
                }
                if (!(child instanceof Element)) continue;
                return null;
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node adoptNode(Node node) throws DOMException {
        if (node instanceof DOMNode) {
            DOMNode childNode = (DOMNode)node;
            if (childNode instanceof CoreChildNode) {
                ((CoreChildNode)((Object)childNode)).coreDetach(this);
            } else {
                childNode.coreSetOwnerDocument(this);
            }
            if (node instanceof DOMAttribute) {
                ((DOMAttribute)node).coreSetSpecified(true);
            }
            return childNode;
        }
        return null;
    }

    final void checkNewChild0(DOMNode newChild) {
        if (newChild instanceof DOMText) {
            throw DOMExceptionUtil.newDOMException((short)3);
        }
    }

    @Override
    public final Element getElementById(String elementId) {
        try {
            NodeIterator it = this.coreGetNodes(Axis.DESCENDANTS, DOMElement.class, Mappers.identity(), DOMSemantics.INSTANCE);
            while (it.hasNext()) {
                DOMElement element = (DOMElement)it.next();
                for (CoreAttribute attr = element.coreGetFirstAttribute(); attr != null; attr = attr.coreGetNextAttribute()) {
                    if (!((DOMAttribute)attr).isId() || !elementId.equals(attr.coreGetCharacterData().toString())) continue;
                    return element;
                }
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public final void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
    }

    @Override
    public final boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public final void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    public final void normalize(DOMConfigurationImpl config) {
    }

    @Override
    public final Node importNode(Node importedNode, boolean deep) throws DOMException {
        short type = importedNode.getNodeType();
        Node newNode = null;
        switch (type) {
            case 1: {
                Element newElement;
                if (importedNode.getLocalName() == null) {
                    newElement = this.createElement(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newElement = this.createElementNS(ns, importedNode.getNodeName());
                }
                NamedNodeMap sourceAttrs = importedNode.getAttributes();
                if (sourceAttrs != null) {
                    int length = sourceAttrs.getLength();
                    for (int index = 0; index < length; ++index) {
                        ((DOMElement)newElement).coreAppendAttribute((DOMAttribute)this.importNode(sourceAttrs.item(index), true));
                    }
                }
                newNode = newElement;
                break;
            }
            case 2: {
                if (importedNode.getLocalName() == null) {
                    newNode = this.createAttribute(importedNode.getNodeName());
                } else {
                    String ns = importedNode.getNamespaceURI();
                    ns = ns != null ? ns.intern() : null;
                    newNode = this.createAttributeNS(ns, importedNode.getNodeName());
                }
                ((Attr)newNode).setValue(importedNode.getNodeValue());
                break;
            }
            case 3: {
                newNode = this.createTextNode(importedNode.getNodeValue());
                break;
            }
            case 8: {
                newNode = this.createComment(importedNode.getNodeValue());
                break;
            }
            case 11: {
                newNode = this.createDocumentFragment();
                break;
            }
            case 4: {
                newNode = this.createCDATASection(importedNode.getNodeValue());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)importedNode;
                newNode = this.createProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                throw new UnsupportedOperationException("TODO : Implement handling of org.w3c.dom.Node type == " + type);
            }
            default: {
                throw DOMExceptionUtil.newDOMException((short)9);
            }
        }
        if (deep && !(importedNode instanceof Attr)) {
            for (Node srckid = importedNode.getFirstChild(); srckid != null; srckid = srckid.getNextSibling()) {
                newNode.appendChild(this.importNode(srckid, true));
            }
        }
        return newNode;
    }

    public final OMElement getOMDocumentElement() {
        try {
            return (OMElement)this.coreGetDocumentElement();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final void setOMDocumentElement(OMElement documentElement) {
        try {
            if (documentElement == null) {
                throw new IllegalArgumentException("documentElement must not be null");
            }
            AxiomElement existingDocumentElement = (AxiomElement)this.coreGetDocumentElement();
            if (existingDocumentElement == null) {
                this.addChild((OMNode)documentElement);
            } else {
                existingDocumentElement.coreReplaceWith((AxiomElement)documentElement, AxiomSemantics.INSTANCE);
            }
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final String getCharsetEncoding() {
        String inputEncoding = this.coreGetInputEncoding();
        return inputEncoding == null ? "UTF-8" : inputEncoding;
    }

    public final void setCharsetEncoding(String charsetEncoding) {
        this.coreSetInputEncoding(charsetEncoding);
    }

    public final String getXMLVersion() {
        return this.coreGetXmlVersion();
    }

    public final void setXMLVersion(String xmlVersion) {
        this.coreSetXmlVersion(xmlVersion);
    }

    public final String getXMLEncoding() {
        return this.coreGetXmlEncoding();
    }

    public final void setXMLEncoding(String xmlEncoding) {
        this.coreSetXmlEncoding(xmlEncoding);
    }

    public final String isStandalone() {
        Boolean standalone = this.coreGetStandalone();
        if (standalone == null) {
            return null;
        }
        return standalone != false ? "yes" : "no";
    }

    public final void setStandalone(String standalone) {
        this.coreSetStandalone("yes".equalsIgnoreCase(standalone));
    }

    @Override
    public final void checkChild(OMNode child) {
        if (child instanceof OMElement) {
            if (this.getOMDocumentElement() != null) {
                throw new OMException("Document element already exists");
            }
            this.checkDocumentElement((OMElement)child);
        }
    }

    public void checkDocumentElement(OMElement element) {
    }

    @Override
    public final CoreElement getContextElement() {
        return null;
    }

    public Iterator<OMSerializable> getDescendants(boolean includeSelf) {
        return this.coreGetNodes(includeSelf ? Axis.DESCENDANTS_OR_SELF : Axis.DESCENDANTS, AxiomSerializable.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final Node getNextSibling() {
        return null;
    }

    @Override
    public final Node getPreviousSibling() {
        return null;
    }

    @Override
    public final Node getParentNode() {
        return null;
    }

    @Override
    public final NodeList getChildNodes() {
        return this;
    }

    @Override
    public final int getLength() {
        int count = 0;
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ++count;
        }
        return count;
    }

    @Override
    public final Node item(int index) {
        int count = 0;
        Node child = this.getFirstChild();
        while (child != null) {
            if (count == index) {
                return child;
            }
            child = child.getNextSibling();
            ++count;
        }
        return null;
    }

    @Override
    public final Node getFirstChild() {
        try {
            return (Node)((Object)this.coreGetFirstChild(DocumentWhitespaceFilter.INSTANCE));
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node getLastChild() {
        try {
            return (Node)((Object)this.coreGetLastChild(DocumentWhitespaceFilter.INSTANCE));
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    @Override
    public final Node removeChild(Node oldChild) throws DOMException {
        if (oldChild.getParentNode() == this) {
            ((CoreChildNode)((Object)oldChild)).coreDetach(DOMSemantics.INSTANCE);
            return oldChild;
        }
        throw DOMExceptionUtil.newDOMException((short)8);
    }

    @Override
    public final void normalizeRecursively(DOMConfigurationImpl config) {
        try {
            this.normalize(config);
            for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
                ((DOMNode)((Object)child)).normalizeRecursively(config);
            }
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    private void checkNewChild(Node newChild) {
        if (newChild instanceof DOMNode) {
            DOMNode newDomChild = (DOMNode)newChild;
            if (!this.coreHasSameOwnerDocument(newDomChild)) {
                throw DOMExceptionUtil.newDOMException((short)4);
            }
        } else {
            throw DOMExceptionUtil.newDOMException((short)4);
        }
        this.checkNewChild0((DOMNode)newChild);
    }

    @Override
    public final Node appendChild(Node newChild) {
        try {
            this.checkNewChild(newChild);
            if (newChild instanceof CoreChildNode) {
                this.coreAppendChild((CoreChildNode)((Object)newChild));
            } else if (newChild instanceof CoreDocumentFragment) {
                this.coreAppendChildren((CoreDocumentFragment)((Object)newChild));
            } else {
                throw DOMExceptionUtil.newDOMException((short)3);
            }
            return newChild;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        try {
            if (refChild == null) {
                return this.appendChild(newChild);
            }
            if (!(refChild instanceof CoreChildNode) || ((CoreChildNode)((Object)refChild)).coreGetParent() != this) {
                throw DOMExceptionUtil.newDOMException((short)8);
            }
            this.checkNewChild(newChild);
            if (newChild instanceof CoreChildNode) {
                ((CoreChildNode)((Object)refChild)).coreInsertSiblingBefore((CoreChildNode)((Object)newChild));
            } else if (newChild instanceof CoreDocumentFragment) {
                ((CoreChildNode)((Object)refChild)).coreInsertSiblingsBefore((CoreDocumentFragment)((Object)newChild));
            } else {
                throw DOMExceptionUtil.newDOMException((short)3);
            }
            return newChild;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    @Override
    public final Node replaceChild(Node newChild, Node _oldChild) {
        try {
            if (!(_oldChild instanceof CoreChildNode)) {
                throw DOMExceptionUtil.newDOMException((short)8);
            }
            CoreChildNode oldChild = (CoreChildNode)((Object)_oldChild);
            if (oldChild.coreGetParent() != this) {
                throw DOMExceptionUtil.newDOMException((short)8);
            }
            this.checkNewChild(newChild);
            if (newChild instanceof CoreChildNode) {
                oldChild.coreReplaceWith((CoreChildNode)((Object)newChild), DOMSemantics.INSTANCE);
            } else if (newChild instanceof CoreDocumentFragment) {
                CoreChildNode nextSibling = oldChild.coreGetNextSibling();
                oldChild.coreDetach(DOMSemantics.INSTANCE);
                if (nextSibling == null) {
                    this.coreAppendChildren((CoreDocumentFragment)((Object)newChild));
                } else {
                    nextSibling.coreInsertSiblingsBefore((CoreDocumentFragment)((Object)newChild));
                }
            } else {
                throw DOMExceptionUtil.newDOMException((short)3);
            }
            return _oldChild;
        }
        catch (CoreModelException ex) {
            throw DOMExceptionUtil.toUncheckedException(ex);
        }
    }

    public final OMXMLParserWrapper getBuilder() {
        BuilderImpl builder = (BuilderImpl)this.coreGetBuilder();
        if (builder == null) {
            return null;
        }
        OMXMLParserWrapper facade = (OMXMLParserWrapper)builder.getFacade();
        if (facade == null) {
            facade = new OMXMLParserWrapperImpl(builder, null);
        }
        return facade;
    }

    public final XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    public final XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    public final XMLStreamReader getXMLStreamReader(boolean cache) {
        return this.getXMLStreamReader(cache, defaultReaderConfiguration);
    }

    public XMLStreamReader getXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        return this.defaultGetXMLStreamReader(cache, configuration);
    }

    @Override
    public final XMLStreamReader defaultGetXMLStreamReader(boolean cache, OMXMLStreamReaderConfiguration configuration) {
        CoreElement contextElement;
        StAXPivot pivot;
        XmlHandler handler = pivot = new StAXPivot(AxiomXMLStreamReaderExtensionFactory.INSTANCE);
        if (configuration.isNamespaceURIInterning()) {
            handler = new NamespaceURIInterningFilterHandler(handler);
        }
        if ((contextElement = this.getContextElement()) != null) {
            if (configuration.isPreserveNamespaceContext()) {
                handler = new NamespaceContextPreservationFilterHandler(handler, contextElement);
            } else {
                Iterator it = ((OMElement)contextElement).getNamespacesInScope();
                while (it.hasNext()) {
                    OMNamespace ns = (OMNamespace)it.next();
                    pivot.setPrefix(ns.getPrefix(), ns.getNamespaceURI());
                }
                handler = new XsiTypeFilterHandler(handler, contextElement);
            }
        }
        try {
            pivot.setReader(this.coreGetReader(handler, cache, true));
        }
        catch (StreamException ex) {
            throw new OMException((Throwable)ex);
        }
        return pivot;
    }

    public final XOPEncoded<XMLStreamReader> getXOPEncodedStreamReader(boolean cache) {
        StAXPivot pivot = new StAXPivot(AxiomXMLStreamReaderExtensionFactory.INSTANCE);
        XOPEncodingFilterHandler encoder = new XOPEncodingFilterHandler(pivot, ContentIDGenerator.DEFAULT, OptimizationPolicy.ALL);
        try {
            pivot.setReader(this.coreGetReader(encoder, cache, true));
        }
        catch (StreamException ex) {
            throw new OMException((Throwable)ex);
        }
        return new XOPEncoded((Object)pivot, (OMAttachmentAccessor)encoder);
    }

    @Override
    public final AxiomChildNode prepareNewChild(OMNode omNode) {
        AxiomChildNode child = omNode.getOMFactory().getMetaFactory().equals(this.getOMFactory().getMetaFactory()) ? (AxiomChildNode)omNode : (AxiomChildNode)this.getOMFactory().importInformationItem((OMInformationItem)omNode);
        this.checkChild(omNode);
        return child;
    }

    public final void addChild(OMNode omNode) {
        try {
            this.coreAppendChild(this.prepareNewChild(omNode));
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public OMNode getFirstOMChild() {
        try {
            return (OMNode)this.coreGetFirstChild();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public void removeChildren() {
        try {
            this.coreRemoveChildren(AxiomSemantics.INSTANCE);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public Iterator<OMNode> getChildren() {
        return this.coreGetNodes(Axis.CHILDREN, AxiomChildNode.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    public Iterator<OMElement> getChildrenWithLocalName(String localName) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_LOCAL_NAME, null, localName, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    public Iterator<OMElement> getChildrenWithNamespaceURI(String uri) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_NAMESPACE_URI, uri, null, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    public Iterator<OMElement> getChildrenWithName(QName name) {
        return this.coreGetElements(Axis.CHILDREN, AxiomElement.class, ElementMatcher.BY_QNAME, name.getNamespaceURI(), name.getLocalPart(), Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    public final OMElement getFirstChildWithName(QName name) throws OMException {
        try {
            for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
                if (!(child instanceof AxiomElement)) continue;
                AxiomElement element = (AxiomElement)child;
                if (!name.getLocalPart().equals(element.coreGetLocalName()) || !name.getNamespaceURI().equals(element.coreGetNamespaceURI())) continue;
                return element;
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    public final SAXSource getSAXSource(boolean cache) {
        return new SAXSource((XMLReader)((Object)new XMLReaderImpl(this, cache)), new InputSource());
    }

    public final SAXResult getSAXResult() {
        XmlHandlerContentHandler handler = new XmlHandlerContentHandler(new SAXResultContentHandler(this), true);
        SAXResult result = new SAXResult();
        result.setHandler(handler);
        result.setLexicalHandler(handler);
        return result;
    }

    private void serialize(XmlHandler handler, NamespaceContextProvider namespaceContextProvider, OMOutputFormat format, boolean cache) throws StreamException {
        handler = new XmlDeclarationRewriterHandler(handler, format);
        CoreElement contextElement = this.getContextElement();
        if (contextElement != null) {
            handler = new XsiTypeFilterHandler(handler, contextElement);
        }
        handler = new NamespaceRepairingFilterHandler(handler, namespaceContextProvider, true);
        try {
            this.internalSerialize(handler, cache);
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    private void serializeAndSurfaceIOException(XmlHandler handler, NamespaceContextProvider namespaceContextProvider, OMOutputFormat format, boolean cache) throws IOException {
        try {
            this.serialize(handler, namespaceContextProvider, format, cache);
        }
        catch (StreamException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new OMException((Throwable)ex);
        }
    }

    public final void serialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        try {
            this.serialize(new XMLStreamWriterHandler(writer), new XMLStreamWriterNamespaceContextProvider(writer), new OMOutputFormat(), cache);
        }
        catch (StreamException ex) {
            throw AxiomExceptionTranslator.toXMLStreamException(ex);
        }
    }

    public final void serialize(Writer writer, boolean cache) throws IOException {
        this.serialize(writer, new OMOutputFormat(), cache);
    }

    public final void serialize(OutputStream out, boolean cache) throws IOException {
        this.serialize(out, new OMOutputFormat(), cache);
    }

    public final void serialize(OutputStream out, OMOutputFormat format, boolean cache) throws IOException {
        XmlHandler handler;
        XOPEncodingFilterHandler encoder;
        OutputStream rootPartOutputStream;
        OMMultipartWriter multipartWriter;
        String encoding = format.getCharSetEncoding();
        if (encoding == null) {
            encoding = "utf-8";
            format.setCharSetEncoding("utf-8");
        }
        if (format.isOptimized()) {
            multipartWriter = new OMMultipartWriter(out, format);
            rootPartOutputStream = multipartWriter.writeRootPart();
        } else {
            multipartWriter = null;
            rootPartOutputStream = out;
        }
        Serializer serializer = new Serializer(rootPartOutputStream, encoding);
        if (format.isOptimized()) {
            encoder = new XOPEncodingFilterHandler(serializer, new ContentIDGeneratorImpl(format), new OptimizationPolicyImpl(format));
            handler = encoder;
        } else {
            handler = serializer;
            encoder = null;
        }
        this.serializeAndSurfaceIOException(handler, null, format, cache);
        if (encoder != null) {
            rootPartOutputStream.close();
            for (String contentID : encoder.getContentIDs()) {
                Blob blob = encoder.getBlob(contentID);
                if (cache || !(blob instanceof PartBlob)) {
                    multipartWriter.writePart(blob, contentID);
                    continue;
                }
                multipartWriter.writePart((PartBlob)blob, contentID, false);
            }
            multipartWriter.complete();
        }
    }

    public final void serialize(Writer writer, OMOutputFormat format, boolean cache) throws IOException {
        this.serializeAndSurfaceIOException(new Serializer(writer), null, format, cache);
    }

    public final void serialize(OutputStream output) throws XMLStreamException {
        this.serialize(output, new OMOutputFormat());
    }

    public final void serializeAndConsume(OutputStream output) throws XMLStreamException {
        this.serializeAndConsume(output, new OMOutputFormat());
    }

    public final void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(output, format, true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public final void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(output, format, false);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public final void serialize(Writer writer) throws XMLStreamException {
        try {
            this.serialize(writer, true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public final void serializeAndConsume(Writer writer) throws XMLStreamException {
        try {
            this.serialize(writer, false);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public final void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(writer, format, true);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public final void serializeAndConsume(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            this.serialize(writer, format, false);
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    public final void close(boolean build) {
        Builder builder = this.coreGetBuilder();
        if (build) {
            this.build();
        }
        if (builder != null) {
            builder.close();
        }
    }
}

