/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Camel Stripe component
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface StripeEndpointBuilderFactory {

    /**
     * Builder for endpoint for the Stripe component.
     */
    public interface StripeEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedStripeEndpointBuilder advanced() {
            return (AdvancedStripeEndpointBuilder) this;
        }

        /**
         * The Stripe API key for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default StripeEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Stripe component.
     */
    public interface AdvancedStripeEndpointBuilder
            extends
                EndpointProducerBuilder {
        default StripeEndpointBuilder basic() {
            return (StripeEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedStripeEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedStripeEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Override the default Stripe API base URL (for testing purposes).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: advanced
         * 
         * @param apiBase the value to set
         * @return the dsl builder
         */
        default AdvancedStripeEndpointBuilder apiBase(String apiBase) {
            doSetProperty("apiBase", apiBase);
            return this;
        }
    }

    public interface StripeBuilders {
        /**
         * Stripe (camel-stripe)
         * Camel Stripe component
         * 
         * Category: saas,finance
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-stripe
         * 
         * @return the dsl builder for the headers' name.
         */
        default StripeHeaderNameBuilder stripe() {
            return StripeHeaderNameBuilder.INSTANCE;
        }
        /**
         * Stripe (camel-stripe)
         * Camel Stripe component
         * 
         * Category: saas,finance
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-stripe
         * 
         * Syntax: <code>stripe:operation</code>
         * 
         * Path parameter: operation (required)
         * The Stripe operation to perform
         * There are 10 enums and the value can be one of: charges, customers,
         * paymentIntents, paymentMethods, refunds, subscriptions, invoices,
         * products, prices, balanceTransactions
         * 
         * @param path operation
         * @return the dsl builder
         */
        default StripeEndpointBuilder stripe(String path) {
            return StripeEndpointBuilderFactory.endpointBuilder("stripe", path);
        }
        /**
         * Stripe (camel-stripe)
         * Camel Stripe component
         * 
         * Category: saas,finance
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-stripe
         * 
         * Syntax: <code>stripe:operation</code>
         * 
         * Path parameter: operation (required)
         * The Stripe operation to perform
         * There are 10 enums and the value can be one of: charges, customers,
         * paymentIntents, paymentMethods, refunds, subscriptions, invoices,
         * products, prices, balanceTransactions
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operation
         * @return the dsl builder
         */
        default StripeEndpointBuilder stripe(String componentName, String path) {
            return StripeEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Stripe component.
     */
    public static class StripeHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final StripeHeaderNameBuilder INSTANCE = new StripeHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code StripeOperation}.
         */
        public String stripeOperation() {
            return "CamelStripeOperation";
        }
        /**
         * The method to invoke (create, retrieve, update, delete, list, cancel,
         * capture).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code StripeMethod}.
         */
        public String stripeMethod() {
            return "CamelStripeMethod";
        }
        /**
         * The ID of the object to retrieve, update, or delete.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code StripeObjectId}.
         */
        public String stripeObjectId() {
            return "CamelStripeObjectId";
        }
    }
    static StripeEndpointBuilder endpointBuilder(String componentName, String path) {
        class StripeEndpointBuilderImpl extends AbstractEndpointBuilder implements StripeEndpointBuilder, AdvancedStripeEndpointBuilder {
            public StripeEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new StripeEndpointBuilderImpl(path);
    }
}