/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.fhir;

import javax.annotation.processing.Generated;

import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link org.apache.camel.component.fhir.api.FhirSearch}.
 */
@ApiParams(apiName = "search", 
           description = "API to search for resources matching a given set of criteria",
           apiMethods = {@ApiMethod(methodName = "searchByResource", description="Perform a search by resource name", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle searchByResource(String resourceName, java.util.Map<String, java.util.List<String>> searchParameters, ca.uhn.fhir.rest.api.SearchStyleEnum searchStyle, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName = "searchByUrl", description="Perform a search directly by URL", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle searchByUrl(String url, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"})}, aliases = {})
@UriParams
@Configurer(extended = true)
@Generated("org.apache.camel.maven.ApiComponentGeneratorMojo")
public final class FhirSearchEndpointConfiguration extends FhirConfiguration {
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "searchByResource", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName = "searchByUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL")})
    private java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "searchByResource", description="The resource to search for")})
    private String resourceName;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "searchByResource", description="A set of search parameters to the query")})
    private java.util.Map<String, java.util.List<String>> searchParameters;
    @UriParam
    @ApiParam(optional = true, apiMethods = {@ApiMethod(methodName = "searchByResource", description="Forces the query to perform the search using the given method (allowable methods are described in the FHIR Search Specification). The default search style is HTTP POST.")})
    private ca.uhn.fhir.rest.api.SearchStyleEnum searchStyle;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "searchByUrl", description="The URL to search for. Note that this URL may be complete (e.g. http://example.com/base/Patientname=foo) in which case the client's base URL will be ignored. Or it can be relative (e.g. Patientname=foo) in which case the client's base URL will be used.")})
    private String url;

    public java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> getExtraParameters() {
        return extraParameters;
    }

    public void setExtraParameters(java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public java.util.Map<String, java.util.List<String>> getSearchParameters() {
        return searchParameters;
    }

    public void setSearchParameters(java.util.Map<String, java.util.List<String>> searchParameters) {
        this.searchParameters = searchParameters;
    }

    public ca.uhn.fhir.rest.api.SearchStyleEnum getSearchStyle() {
        return searchStyle;
    }

    public void setSearchStyle(ca.uhn.fhir.rest.api.SearchStyleEnum searchStyle) {
        this.searchStyle = searchStyle;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}
