/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.HashMap;
import org.apache.commons.text.similarity.CosineSimilarity;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CosineSimilarityTest {
    @Test
    public void testCosineSimilarityWithNonEmptyMap() {
        CosineSimilarity cosineSimilarity = new CosineSimilarity();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Integer integer = -397;
        hashMap.put("3J/$3.L", integer);
        HashMap hashMapTwo = new HashMap();
        Assertions.assertThat((Double)cosineSimilarity.cosineSimilarity(hashMap, hashMapTwo)).isEqualTo(0.0, Assertions.within((Double)0.01));
    }

    @Test
    public void testCosineSimilarityThrowsIllegalArgumentException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            CosineSimilarity cosineSimilarity = new CosineSimilarity();
            HashMap map = new HashMap();
            cosineSimilarity.cosineSimilarity(map, null);
        });
    }

    @Test
    public void testCosineSimilarityWithNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> {
            CosineSimilarity cosineSimilarity = new CosineSimilarity();
            cosineSimilarity.cosineSimilarity(null, null);
        });
    }

    @Test
    public void testCosineSimilarityReturningDoubleWhereByteValueIsZero() {
        CosineSimilarity cosineSimilarity = new CosineSimilarity();
        HashMap hashMap = new HashMap();
        Assertions.assertThat((Double)cosineSimilarity.cosineSimilarity(hashMap, hashMap)).isEqualTo(0.0, Assertions.within((Double)0.01));
    }
}

