/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.AnotB;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SetOperation;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EmptyTest {
    @Test
    public void checkEmpty() {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().build();
        UpdateSketch sk2 = Sketches.updateSketchBuilder().build();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        int u = 100;
        for (int i = 0; i < 100; ++i) {
            sk1.update((long)i);
            sk2.update((long)(i + 100));
        }
        inter.intersect((Sketch)sk1);
        inter.intersect((Sketch)sk2);
        CompactSketch csk = inter.getResult();
        EmptyTest.println(csk.toString());
        Assert.assertTrue((boolean)csk.isEmpty());
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        CompactSketch csk2 = aNotB.aNotB((Sketch)csk, (Sketch)sk1);
        Assert.assertTrue((boolean)csk2.isEmpty());
    }

    @Test
    public void checkNotEmpty() {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().build();
        UpdateSketch sk2 = Sketches.updateSketchBuilder().build();
        Intersection inter = Sketches.setOperationBuilder().buildIntersection();
        int u = 10000;
        for (int i = 0; i < 10000; ++i) {
            sk1.update((long)i);
            sk2.update((long)(i + 10000));
        }
        inter.intersect((Sketch)sk1);
        inter.intersect((Sketch)sk2);
        CompactSketch csk = inter.getResult();
        EmptyTest.println(csk.toString());
        Assert.assertFalse((boolean)csk.isEmpty());
        AnotB aNotB = Sketches.setOperationBuilder().buildANotB();
        CompactSketch csk2 = aNotB.aNotB((Sketch)csk, (Sketch)sk1);
        EmptyTest.println(csk2.toString());
        Assert.assertFalse((boolean)csk2.isEmpty());
        UpdateSketch sk3 = Sketches.updateSketchBuilder().build();
        aNotB = Sketches.setOperationBuilder().buildANotB();
        CompactSketch csk3 = aNotB.aNotB((Sketch)sk3, (Sketch)sk1);
        EmptyTest.println(csk3.toString());
        Assert.assertTrue((boolean)csk3.isEmpty());
    }

    @Test
    public void checkPsampling() {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setP(0.5f).build();
        Assert.assertTrue((boolean)sk1.isEmpty());
        Assert.assertEquals((int)sk1.compact().toByteArray().length, (int)8);
    }

    @Test
    public void checkBackwardCompatibility1() {
        int k = 16;
        int bytes = Sketches.getMaxUnionBytes((int)16);
        Union union = SetOperation.builder().buildUnion(WritableMemory.allocate((int)bytes));
        Memory mem = EmptyTest.badEmptySk();
        Sketch wsk = Sketches.wrapSketch((Memory)mem);
        union.union(wsk);
    }

    @Test
    public void checkBackwardCompatibility2() {
        Union union = SetOperation.builder().setNominalEntries(16).buildUnion();
        Memory mem = EmptyTest.badEmptySk();
        Sketch wsk = Sketches.wrapSketch((Memory)mem);
        union.union(wsk);
    }

    @Test
    public void checkBackwardCompatibility3() {
        Memory mem = EmptyTest.badEmptySk();
        Sketches.heapifySketch((Memory)mem);
    }

    @Test
    public void checkEmptyToCompact() {
        UpdateSketch sk1 = Sketches.updateSketchBuilder().build();
        CompactSketch csk = sk1.compact();
        Assert.assertTrue((boolean)(csk instanceof EmptyCompactSketch));
        CompactSketch csk2 = csk.compact();
        Assert.assertTrue((boolean)(csk2 instanceof EmptyCompactSketch));
        CompactSketch csk3 = csk.compact(true, WritableMemory.allocate((int)8));
        Assert.assertTrue((boolean)(csk3 instanceof DirectCompactSketch));
        Assert.assertEquals((int)csk2.getCurrentPreambleLongs(), (int)1);
    }

    private static Memory badEmptySk() {
        long preLongs = 1L;
        long serVer = 2L;
        long family = 3L;
        long flags = 26L;
        long seedHash = 37836L;
        long badEmptySk = -7796828267582651903L;
        WritableMemory wmem = WritableMemory.allocate((int)8);
        wmem.putLong(0L, -7796828267582651903L);
        return wmem;
    }

    static void println(String s) {
    }
}

