/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.Arena;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.BackwardConversions;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.tuple.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HeapifyWrapSerVer1and2Test {
    private static final short defaultSeedHash = Util.computeSeedHash((long)9001L);

    @Test
    public void checkHeapifyCompactSketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        Memory cskMem = Memory.wrap((byte[])csk.toByteArray());
        CompactSketch cskResult = Sketches.heapifyCompactSketch((Memory)cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        cskResult = Sketches.heapifyCompactSketch((Memory)sv2cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        cskResult = Sketches.heapifyCompactSketch((Memory)sv1cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifyCompactSketchAssumedDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        Memory cskMem = Memory.wrap((byte[])csk.toByteArray());
        CompactSketch cskResult = Sketches.heapifyCompactSketch((Memory)cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(csk, 128L);
        cskResult = Sketches.heapifyCompactSketch((Memory)sv2cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        cskResult = Sketches.heapifyCompactSketch((Memory)sv1cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)defaultSeedHash);
    }

    @Test
    public void checkHeapifyCompactSketchGivenDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        Memory cskMem = Memory.wrap((byte[])csk.toByteArray());
        CompactSketch cskResult = Sketches.heapifyCompactSketch((Memory)cskMem, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        cskResult = Sketches.heapifyCompactSketch((Memory)sv2cskMem, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        cskResult = Sketches.heapifyCompactSketch((Memory)sv1cskMem, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifyCompactSketchGivenDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        Memory cskMem = Memory.wrap((byte[])csk.toByteArray());
        CompactSketch cskResult = Sketches.heapifyCompactSketch((Memory)cskMem, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(csk, 128L);
        cskResult = Sketches.heapifyCompactSketch((Memory)sv2cskMem, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        cskResult = Sketches.heapifyCompactSketch((Memory)sv1cskMem, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifySketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        Memory cskMem = Memory.wrap((byte[])csk.toByteArray());
        CompactSketch cskResult = (CompactSketch)Sketches.heapifySketch((Memory)cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv2cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv1cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifySketchAssumedDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        Memory cskMem = Memory.wrap((byte[])csk.toByteArray());
        CompactSketch cskResult = (CompactSketch)Sketches.heapifySketch((Memory)cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(csk, 128L);
        cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv2cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv1cskMem);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)defaultSeedHash);
    }

    @Test
    public void checkHeapifySketchGivenDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        Memory cskMem = Memory.wrap((byte[])csk.toByteArray());
        CompactSketch cskResult = (CompactSketch)Sketches.heapifySketch((Memory)cskMem, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(csk, 9001L);
        cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv2cskMem, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv1cskMem, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkHeapifySketchGivenDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        Memory cskMem = Memory.wrap((byte[])csk.toByteArray());
        CompactSketch cskResult = (CompactSketch)Sketches.heapifySketch((Memory)cskMem, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv2cskMem = BackwardConversions.convertSerVer3toSerVer2(csk, 128L);
        cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv2cskMem, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Memory sv1cskMem = BackwardConversions.convertSerVer3toSerVer1(csk);
        cskResult = (CompactSketch)Sketches.heapifySketch((Memory)sv1cskMem, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
    }

    @Test
    public void checkWrapCompactSketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        WritableMemory offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])csk.toByteArray()), Arena.ofConfined());
        CompactSketch cskResult = Sketches.wrapCompactSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(csk, 9001L), Arena.ofConfined());
        cskResult = Sketches.wrapCompactSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(csk), Arena.ofConfined());
        cskResult = Sketches.wrapCompactSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
    }

    @Test
    public void checkWrapCompactSketchAssumedDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        WritableMemory offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])csk.toByteArray()), Arena.ofConfined());
        CompactSketch cskResult = Sketches.wrapCompactSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(csk, 128L), Arena.ofConfined());
        cskResult = Sketches.wrapCompactSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(csk), Arena.ofConfined());
        cskResult = Sketches.wrapCompactSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)defaultSeedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
    }

    @Test
    public void checkWrapCompactSketchGivenDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        WritableMemory offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])csk.toByteArray()), Arena.ofConfined());
        CompactSketch cskResult = Sketches.wrapCompactSketch((Memory)offHeap, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(csk, 9001L), Arena.ofConfined());
        cskResult = Sketches.wrapCompactSketch((Memory)offHeap, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(csk), Arena.ofConfined());
        cskResult = Sketches.wrapCompactSketch((Memory)offHeap, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
    }

    @Test
    public void checkWrapCompactSketchGivenDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        WritableMemory offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])csk.toByteArray()), Arena.ofConfined());
        CompactSketch cskResult = Sketches.wrapCompactSketch((Memory)offHeap, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(csk, 128L), Arena.ofConfined());
        cskResult = Sketches.wrapCompactSketch((Memory)offHeap, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(csk), Arena.ofConfined());
        cskResult = Sketches.wrapCompactSketch((Memory)offHeap, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
    }

    @Test
    public void checkWrapSketchAssumedDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        WritableMemory offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])csk.toByteArray()), Arena.ofConfined());
        CompactSketch cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(csk, 9001L), Arena.ofConfined());
        cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(csk), Arena.ofConfined());
        cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
    }

    @Test
    public void checkWrapSketchAssumedDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        WritableMemory offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])csk.toByteArray()), Arena.ofConfined());
        CompactSketch cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(csk, 128L), Arena.ofConfined());
        cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(csk), Arena.ofConfined());
        cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)defaultSeedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
    }

    @Test
    public void checkWrapSketchGivenDefaultSeed() {
        int k = 64;
        long seed = 9001L;
        short seedHash = Util.computeSeedHash((long)9001L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(9001L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        WritableMemory offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])csk.toByteArray()), Arena.ofConfined());
        CompactSketch cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(csk, 9001L), Arena.ofConfined());
        cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(csk), Arena.ofConfined());
        cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap, (long)9001L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
    }

    @Test
    public void checkWrapSketchGivenDifferentSeed() {
        int k = 64;
        long seed = 128L;
        short seedHash = Util.computeSeedHash((long)128L);
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(64).setSeed(128L).build();
        for (int i = 0; i < 64; ++i) {
            usk.update((long)i);
        }
        CompactSketch csk = usk.compact();
        WritableMemory offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(Memory.wrap((byte[])csk.toByteArray()), Arena.ofConfined());
        CompactSketch cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertTrue((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer2(csk, 128L), Arena.ofConfined());
        cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
        offHeap = HeapifyWrapSerVer1and2Test.putOffHeap(BackwardConversions.convertSerVer3toSerVer1(csk), Arena.ofConfined());
        cskResult = (CompactSketch)Sketches.wrapSketch((Memory)offHeap, (long)128L);
        Assert.assertEquals((double)cskResult.getEstimate(), (double)usk.getEstimate());
        Assert.assertEquals((short)cskResult.getSeedHash(), (short)seedHash);
        Assert.assertFalse((boolean)cskResult.isDirect());
        if (offHeap.isAlive()) {
            offHeap.getArena().close();
        }
    }

    private static WritableMemory putOffHeap(Memory heapMem, Arena arena) {
        long cap = heapMem.getCapacity();
        WritableMemory wmem = WritableMemory.allocateDirect((long)cap, (Arena)arena);
        heapMem.copyTo(0L, wmem, 0L, cap);
        return wmem;
    }

    @Test
    public void printlnTest() {
        HeapifyWrapSerVer1and2Test.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

