/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hash;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.hash.XxHash;
import org.apache.datasketches.hash.XxHash64;
import org.testng.Assert;
import org.testng.annotations.Test;

public class XxHash64Test {
    private static final byte[] barr = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};

    @Test
    public void offsetChecks() {
        long seed = 12345L;
        int blocks = 6;
        int cap = 96;
        MemorySegment wseg = MemorySegment.ofArray(new byte[96]);
        for (int i = 0; i < 96; ++i) {
            wseg.set(ValueLayout.JAVA_BYTE, (long)i, (byte)(-128 + i));
        }
        for (int offset = 0; offset < 16; ++offset) {
            int arrLen = 96 - offset;
            long hash = XxHash64.hash((MemorySegment)wseg, (long)offset, (long)arrLen, (long)12345L);
            Assert.assertTrue((hash != 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void byteArrChecks() {
        long seed = 0L;
        boolean offset = false;
        int bytes = 16;
        for (int j = 1; j < 16; ++j) {
            byte[] in = new byte[16];
            MemorySegment wseg = MemorySegment.ofArray(in);
            for (int i = 0; i < j; ++i) {
                wseg.set(ValueLayout.JAVA_BYTE, (long)i, (byte)(-128 + i));
            }
            long hash = XxHash64.hash((MemorySegment)wseg, (long)0L, (long)16L, (long)0L);
            Assert.assertTrue((hash != 0L ? 1 : 0) != 0);
        }
    }

    @Test
    public void collisionTest() {
        MemorySegment wseg = MemorySegment.ofArray(new byte[128]);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, 1L);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 16L, 42L);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 32L, 2L);
        long h1 = XxHash64.hash((MemorySegment)wseg, (long)0L, (long)wseg.byteSize(), (long)0L);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, 839798700976720816L);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 32L, -7165226614156951550L);
        long h2 = XxHash64.hash((MemorySegment)wseg, (long)0L, (long)wseg.byteSize(), (long)0L);
        Assert.assertEquals((long)h1, (long)h2);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, 1679597401953441631L);
        wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, 32L, 4116290845395648514L);
        long h3 = XxHash64.hash((MemorySegment)wseg, (long)0L, (long)wseg.byteSize(), (long)0L);
        Assert.assertEquals((long)h2, (long)h3);
    }

    @Test
    public void testArrHashes() {
        MemorySegment wseg = MemorySegment.ofArray(barr);
        long hash0 = XxHash64.hash((MemorySegment)wseg, (long)8L, (long)8L, (long)0L);
        long hash1 = XxHash.hashByteArr((byte[])barr, (int)8, (int)8, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        char[] carr = new char[8];
        MemorySegment.copy(wseg, ValueLayout.JAVA_CHAR_UNALIGNED, 0L, carr, 0, 8);
        hash1 = XxHash.hashCharArr((char[])carr, (int)4, (int)4, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        short[] sarr = new short[8];
        MemorySegment.copy(wseg, ValueLayout.JAVA_SHORT_UNALIGNED, 0L, sarr, 0, 8);
        hash1 = XxHash.hashShortArr((short[])sarr, (int)4, (int)4, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        int[] iarr = new int[4];
        MemorySegment.copy(wseg, ValueLayout.JAVA_INT_UNALIGNED, 0L, iarr, 0, 4);
        hash1 = XxHash.hashIntArr((int[])iarr, (int)2, (int)2, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        float[] farr = new float[4];
        MemorySegment.copy(wseg, ValueLayout.JAVA_FLOAT_UNALIGNED, 0L, farr, 0, 4);
        hash1 = XxHash.hashFloatArr((float[])farr, (int)2, (int)2, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        long[] larr = new long[2];
        MemorySegment.copy(wseg, ValueLayout.JAVA_LONG_UNALIGNED, 0L, larr, 0, 2);
        hash1 = XxHash.hashLongArr((long[])larr, (int)1, (int)1, (long)0L);
        long in = wseg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
        long hash2 = XxHash.hashLong((long)in, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
        Assert.assertEquals((long)hash2, (long)hash0);
        double[] darr = new double[2];
        MemorySegment.copy(wseg, ValueLayout.JAVA_DOUBLE_UNALIGNED, 0L, darr, 0, 2);
        hash1 = XxHash.hashDoubleArr((double[])darr, (int)1, (int)1, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
    }

    @Test
    public void testString() {
        String s = "Now is the time for all good men to come to the aid of their country.";
        char[] arr = "Now is the time for all good men to come to the aid of their country.".toCharArray();
        long hash0 = XxHash.hashString((String)"Now is the time for all good men to come to the aid of their country.", (int)0, (int)"Now is the time for all good men to come to the aid of their country.".length(), (long)0L);
        long hash1 = XxHash.hashCharArr((char[])arr, (int)0, (int)arr.length, (long)0L);
        Assert.assertEquals((long)hash1, (long)hash0);
    }
}

