/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketchBuilder;
import org.apache.datasketches.thetacommon.ThetaUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UpdateSketchTest {
    @Test
    public void checkOtherUpdates() {
        int k = 512;
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setNominalEntries(512).build();
        sk1.update(1L);
        sk1.update(1.5);
        sk1.update(0.0);
        sk1.update(-0.0);
        String s = null;
        sk1.update(s);
        s = "";
        sk1.update(s);
        s = "String";
        sk1.update(s);
        byte[] byteArr = null;
        sk1.update(byteArr);
        byteArr = new byte[]{};
        sk1.update(byteArr);
        sk1.update(ByteBuffer.wrap(byteArr));
        byteArr = "Byte Array".getBytes(StandardCharsets.UTF_8);
        sk1.update(byteArr);
        sk1.update(ByteBuffer.wrap(byteArr, 0, 10));
        sk1.update(ByteBuffer.wrap(byteArr, 2, 6));
        char[] charArr = null;
        sk1.update(charArr);
        charArr = new char[]{};
        sk1.update(charArr);
        charArr = "String".toCharArray();
        sk1.update(charArr);
        int[] intArr = null;
        sk1.update(intArr);
        intArr = new int[]{};
        sk1.update(intArr);
        int[] intArr2 = new int[]{1, 2, 3, 4, 5};
        sk1.update(intArr2);
        long[] longArr = null;
        sk1.update(longArr);
        longArr = new long[]{};
        sk1.update(longArr);
        long[] longArr2 = new long[]{6L, 7L, 8L, 9L};
        sk1.update(longArr2);
        double est = sk1.getEstimate();
        Assert.assertEquals((double)est, (double)9.0, (double)0.0);
    }

    @Test
    public void checkStartingSubMultiple() {
        int lgSubMul = ThetaUtil.startingSubMultiple((int)10, (int)ResizeFactor.X1.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)10);
        lgSubMul = ThetaUtil.startingSubMultiple((int)10, (int)ResizeFactor.X2.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)5);
        lgSubMul = ThetaUtil.startingSubMultiple((int)10, (int)ResizeFactor.X4.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)6);
        lgSubMul = ThetaUtil.startingSubMultiple((int)10, (int)ResizeFactor.X8.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)7);
        lgSubMul = ThetaUtil.startingSubMultiple((int)4, (int)ResizeFactor.X1.lg(), (int)5);
        Assert.assertEquals((int)lgSubMul, (int)5);
    }

    @Test
    public void checkBuilder() {
        UpdatableThetaSketchBuilder bldr = UpdatableThetaSketch.builder();
        long seed = 12345L;
        bldr.setSeed(12345L);
        Assert.assertEquals((long)bldr.getSeed(), (long)12345L);
        float p = 0.5f;
        bldr.setP(0.5f);
        Assert.assertEquals((float)bldr.getP(), (float)0.5f);
        ResizeFactor rf = ResizeFactor.X4;
        bldr.setResizeFactor(rf);
        Assert.assertEquals((Object)bldr.getResizeFactor(), (Object)rf);
        Family fam = Family.ALPHA;
        bldr.setFamily(fam);
        Assert.assertEquals((Object)bldr.getFamily(), (Object)fam);
        int lgK = 10;
        int k = 1024;
        bldr.setNominalEntries(1024);
        Assert.assertEquals((int)bldr.getLgNominalEntries(), (int)10);
        UpdateSketchTest.println(bldr.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderNomEntries() {
        UpdatableThetaSketchBuilder bldr = UpdatableThetaSketch.builder();
        int k = 0x8000000;
        bldr.setNominalEntries(0x8000000);
    }

    @Test
    public void checkCompact() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        CompactThetaSketch csk = sk.compact();
        Assert.assertEquals((int)csk.getCompactBytes(), (int)8);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIncompatibleFamily() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        sk.update(1L);
        MemorySegment wseg = MemorySegment.ofArray(sk.compact().toByteArray());
        UpdatableThetaSketch.wrap((MemorySegment)wseg, null, (long)9001L);
    }

    @Test
    public void checkCorruption() {
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().build();
        sk.update(1L);
        MemorySegment wseg = MemorySegment.ofArray(sk.toByteArray());
        try {
            wseg.set(ValueLayout.JAVA_BYTE, 1L, (byte)2);
            ThetaSketch.wrap((MemorySegment)wseg, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            wseg.set(ValueLayout.JAVA_BYTE, 1L, (byte)3);
            wseg.set(ValueLayout.JAVA_BYTE, 0L, (byte)2);
            ThetaSketch.wrap((MemorySegment)wseg, (long)9001L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkIsResizeFactorIncorrect() {
        MemorySegment wseg = MemorySegment.ofArray(new byte[8]);
        PreambleUtil.insertLgNomLongs((MemorySegment)wseg, (int)26);
        for (int lgK = 4; lgK <= 26; ++lgK) {
            PreambleUtil.insertLgNomLongs((MemorySegment)wseg, (int)lgK);
            int lgT = lgK + 1;
            for (int lgA = 5; lgA <= lgT; ++lgA) {
                PreambleUtil.insertLgArrLongs((MemorySegment)wseg, (int)lgA);
                for (int lgR = 0; lgR <= 3; ++lgR) {
                    PreambleUtil.insertLgResizeFactor((MemorySegment)wseg, (int)lgR);
                    boolean lgRbad = UpdatableThetaSketch.isResizeFactorIncorrect((MemorySegment)wseg, (int)lgK, (int)lgA);
                    boolean rf123 = lgR > 0 && (lgT - lgA) % lgR != 0;
                    boolean rf0 = lgR == 0 && lgA != lgT;
                    Assert.assertTrue((lgRbad == rf0 || lgRbad == rf123 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void checkCompactOpsMemorySegmentToCompact() {
        int lgK = 6;
        UpdatableThetaSketch sk = UpdatableThetaSketch.builder().setLogNominalEntries(6).build();
        int n = 128;
        for (int i = 2; i < 128; ++i) {
            sk.update((long)i);
        }
        int cbytes = sk.getCompactBytes();
        byte[] byteArr = sk.toByteArray();
        MemorySegment skwseg = MemorySegment.ofArray(byteArr);
        MemorySegment cskwseg1 = MemorySegment.ofArray(new byte[cbytes]);
        MemorySegment cskwseg2 = MemorySegment.ofArray(new byte[cbytes]);
        MemorySegment cskwseg3 = MemorySegment.ofArray(new byte[cbytes]);
        CompactThetaSketch csk1 = sk.compact(true, cskwseg1);
        CompactThetaSketch csk2 = CompactOperations.segmentToCompact((MemorySegment)skwseg, (boolean)true, (MemorySegment)cskwseg2);
        CompactThetaSketch csk3 = CompactOperations.segmentToCompact((MemorySegment)cskwseg1, (boolean)true, (MemorySegment)cskwseg3);
        Assert.assertTrue((boolean)Util.equalContents((MemorySegment)cskwseg1, (MemorySegment)cskwseg2));
        Assert.assertTrue((boolean)Util.equalContents((MemorySegment)cskwseg1, (MemorySegment)cskwseg3));
        Assert.assertTrue((boolean)csk1.hasMemorySegment());
        Assert.assertTrue((boolean)csk2.hasMemorySegment());
        Assert.assertTrue((boolean)csk3.hasMemorySegment());
    }

    @Test
    public void printlnTest() {
        UpdateSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

