package org.apache.torque.generated.peer;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.torque.NoRowsException;
import org.apache.torque.OptimisticLockingFailedException;
import org.apache.torque.TorqueException;
import org.apache.torque.test.dbobject.OptimisticLocking;
import org.apache.torque.test.peer.OptimisticLockingPeerImpl;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import static org.junit.Assert.assertNull;

/**
 * Tests whether optimistic locking with select for update works.
 *
 * @version $Id: OptimisticLockingSelectForUpdateTest.java 1870836 2019-12-04 15:51:06Z gk $
 */
public class OptimisticLockingSelectForUpdateTest
extends BaseOptimisticLockingTest<OptimisticLocking>
{
    public OptimisticLockingSelectForUpdateTest()
    {
        super(new OptimisticLockingPeerImpl());
    }

    @Override
    public OptimisticLocking newObject()
    {
        return new OptimisticLocking();
    }

    @Override
    public void assertOptimisticLockingDeleteException(TorqueException e) {
        assertTrue(e instanceof NoRowsException);
        assertEquals(
                "The row to update does not exist in the database",
                e.getMessage());
    }

    @Override
    public void assertOptimisticLockingUpdateException(TorqueException e) {
        assertTrue(e instanceof OptimisticLockingFailedException);
        assertEquals(
                "The row was updated concurrently. Version in database: 1"
                        + ", version in memory: 0",
                        e.getMessage());
    }
}
