/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.search.reference;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ReferralImpl;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreReference
extends GrammarAction<LdapMessageContainer<SearchResultReference>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreReference.class);

    public StoreReference() {
        super("Store a reference");
    }

    @Override
    public void action(LdapMessageContainer<SearchResultReference> container) throws DecoderException {
        SearchResultReference searchResultReference = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        Referral referral = searchResultReference.getReferral();
        if (referral == null) {
            referral = new ReferralImpl();
            searchResultReference.setReferral(referral);
        }
        LdapUrl url = LdapUrl.EMPTY_URL;
        if (tlv.getLength() == 0) {
            referral.addLdapUrl("");
        } else {
            String urlStr = Strings.utf8ToString(tlv.getValue().getData());
            try {
                url = new LdapUrl(urlStr);
                referral.addLdapUrl(urlStr);
            }
            catch (LdapURLEncodingException luee) {
                LOG.error(I18n.err(I18n.ERR_05103_INVALID_URL, urlStr, luee.getMessage()));
                throw new DecoderException(I18n.err(I18n.ERR_05104_INVALID_URL, luee.getMessage()), luee);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg(I18n.MSG_05184_SEARCH_REFERENCE_URL, url));
        }
        container.setGrammarEndAllowed(true);
    }
}

