/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras;

import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.IntermediateOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncRequestFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdDirSyncResponseFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdPolicyHintsFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdShowDeletedFactory;
import org.apache.directory.api.ldap.extras.controls.ad_impl.TreeDeleteFactory;
import org.apache.directory.api.ldap.extras.controls.changeNotifications_impl.ChangeNotificationsFactory;
import org.apache.directory.api.ldap.extras.controls.passwordExpired_impl.PasswordExpiredResponseFactory;
import org.apache.directory.api.ldap.extras.controls.permissiveModify_impl.PermissiveModifyFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyRequestFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyResponseFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory;
import org.apache.directory.api.ldap.extras.controls.transaction_impl.TransactionSpecificationFactory;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewRequestFactory;
import org.apache.directory.api.ldap.extras.controls.vlv_impl.VirtualListViewResponseFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.EndTransactionFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.nod.NoDFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.startTls.StartTlsFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.startTransaction.StartTransactionFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.whoAmI.WhoAmIFactory;
import org.apache.directory.api.ldap.extras.intermediate.syncrepl_impl.SyncInfoValueFactory;
import org.apache.directory.api.ldap.model.message.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtrasCodecFactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExtrasCodecFactoryUtil.class);

    private ExtrasCodecFactoryUtil() {
    }

    public static void loadExtrasControls(LdapApiService apiService) {
        Map<String, ControlFactory<? extends Control>> requestControlFactories = apiService.getRequestControlFactories();
        Map<String, ControlFactory<? extends Control>> responseControlFactories = apiService.getResponseControlFactories();
        AdDirSyncRequestFactory adDirSyncRequestFactory = new AdDirSyncRequestFactory(apiService);
        requestControlFactories.put(adDirSyncRequestFactory.getOid(), adDirSyncRequestFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, adDirSyncRequestFactory.getOid()));
        }
        AdDirSyncResponseFactory adDirSyncResponseFactory = new AdDirSyncResponseFactory(apiService);
        responseControlFactories.put(adDirSyncResponseFactory.getOid(), adDirSyncResponseFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, adDirSyncRequestFactory.getOid()));
        }
        AdPolicyHintsFactory adPolicyHintsFactory = new AdPolicyHintsFactory(apiService);
        requestControlFactories.put(adPolicyHintsFactory.getOid(), adPolicyHintsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, adPolicyHintsFactory.getOid()));
        }
        AdShowDeletedFactory adShowDeletedFactory = new AdShowDeletedFactory(apiService);
        requestControlFactories.put(adShowDeletedFactory.getOid(), adShowDeletedFactory);
        TreeDeleteFactory treeDeleteFactory = new TreeDeleteFactory(apiService);
        requestControlFactories.put(treeDeleteFactory.getOid(), treeDeleteFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, adShowDeletedFactory.getOid()));
        }
        ChangeNotificationsFactory changeNotificationsFactory = new ChangeNotificationsFactory(apiService);
        requestControlFactories.put(changeNotificationsFactory.getOid(), changeNotificationsFactory);
        responseControlFactories.put(changeNotificationsFactory.getOid(), changeNotificationsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, changeNotificationsFactory.getOid()));
        }
        PasswordExpiredResponseFactory passwordExpiredResponseFactory = new PasswordExpiredResponseFactory(apiService);
        responseControlFactories.put(passwordExpiredResponseFactory.getOid(), passwordExpiredResponseFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, passwordExpiredResponseFactory.getOid()));
        }
        PasswordPolicyRequestFactory passwordPolicyRequestFactory = new PasswordPolicyRequestFactory(apiService);
        requestControlFactories.put(passwordPolicyRequestFactory.getOid(), passwordPolicyRequestFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, passwordPolicyRequestFactory.getOid()));
        }
        PasswordPolicyResponseFactory passwordPolicyResponseFactory = new PasswordPolicyResponseFactory(apiService);
        responseControlFactories.put(passwordPolicyResponseFactory.getOid(), passwordPolicyResponseFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, passwordPolicyResponseFactory.getOid()));
        }
        PermissiveModifyFactory permissiveModifyFactory = new PermissiveModifyFactory(apiService);
        requestControlFactories.put(permissiveModifyFactory.getOid(), permissiveModifyFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, permissiveModifyFactory.getOid()));
        }
        SyncDoneValueFactory syncDoneValueFactory = new SyncDoneValueFactory(apiService);
        responseControlFactories.put(syncDoneValueFactory.getOid(), syncDoneValueFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, syncDoneValueFactory.getOid()));
        }
        SyncRequestValueFactory syncRequestValueFactory = new SyncRequestValueFactory(apiService);
        requestControlFactories.put(syncRequestValueFactory.getOid(), syncRequestValueFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, syncRequestValueFactory.getOid()));
        }
        SyncStateValueFactory syncStateValueFactory = new SyncStateValueFactory(apiService);
        requestControlFactories.put(syncStateValueFactory.getOid(), syncStateValueFactory);
        responseControlFactories.put(syncStateValueFactory.getOid(), syncStateValueFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, syncStateValueFactory.getOid()));
        }
        TransactionSpecificationFactory transactionSpecificationFactory = new TransactionSpecificationFactory(apiService);
        requestControlFactories.put(transactionSpecificationFactory.getOid(), transactionSpecificationFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, transactionSpecificationFactory.getOid()));
        }
        VirtualListViewRequestFactory virtualListViewRequestFactory = new VirtualListViewRequestFactory(apiService);
        requestControlFactories.put(virtualListViewRequestFactory.getOid(), virtualListViewRequestFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, virtualListViewRequestFactory.getOid()));
        }
        VirtualListViewResponseFactory virtualListViewResponseFactory = new VirtualListViewResponseFactory(apiService);
        responseControlFactories.put(virtualListViewResponseFactory.getOid(), virtualListViewResponseFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06000_REGISTERED_CONTROL_FACTORY, virtualListViewResponseFactory.getOid()));
        }
    }

    public static void loadExtrasExtendedOperations(LdapApiService apiService) {
        Map<String, ExtendedOperationFactory> extendedRequestFactories = apiService.getExtendedRequestFactories();
        Map<String, ExtendedOperationFactory> extendedResponseFactories = apiService.getExtendedResponseFactories();
        CancelFactory cancelFactory = new CancelFactory(apiService);
        extendedRequestFactories.put(cancelFactory.getOid(), cancelFactory);
        extendedResponseFactories.put(cancelFactory.getOid(), cancelFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, cancelFactory.getOid()));
        }
        CertGenerationFactory certGenerationFactory = new CertGenerationFactory(apiService);
        extendedRequestFactories.put(certGenerationFactory.getOid(), certGenerationFactory);
        extendedResponseFactories.put(certGenerationFactory.getOid(), certGenerationFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, certGenerationFactory.getOid()));
        }
        EndTransactionFactory endTransactionFactory = new EndTransactionFactory(apiService);
        extendedRequestFactories.put(endTransactionFactory.getOid(), endTransactionFactory);
        extendedResponseFactories.put(endTransactionFactory.getOid(), endTransactionFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, endTransactionFactory.getOid()));
        }
        GracefulDisconnectFactory gracefulDisconnectFactory = new GracefulDisconnectFactory(apiService);
        extendedResponseFactories.put(gracefulDisconnectFactory.getOid(), gracefulDisconnectFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, gracefulDisconnectFactory.getOid()));
        }
        GracefulShutdownFactory gracefulShutdownFactory = new GracefulShutdownFactory(apiService);
        extendedRequestFactories.put(gracefulShutdownFactory.getOid(), gracefulShutdownFactory);
        extendedResponseFactories.put(gracefulShutdownFactory.getOid(), gracefulShutdownFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, gracefulShutdownFactory.getOid()));
        }
        NoDFactory noticeOfDisconnectFactory = new NoDFactory(apiService);
        extendedResponseFactories.put(noticeOfDisconnectFactory.getOid(), noticeOfDisconnectFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, noticeOfDisconnectFactory.getOid()));
        }
        PasswordModifyFactory passwordModifyFactory = new PasswordModifyFactory(apiService);
        extendedRequestFactories.put(passwordModifyFactory.getOid(), passwordModifyFactory);
        extendedResponseFactories.put(passwordModifyFactory.getOid(), passwordModifyFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, passwordModifyFactory.getOid()));
        }
        StartTlsFactory startTlsFactory = new StartTlsFactory(apiService);
        extendedRequestFactories.put(startTlsFactory.getOid(), startTlsFactory);
        extendedResponseFactories.put(startTlsFactory.getOid(), startTlsFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, startTlsFactory.getOid()));
        }
        StartTransactionFactory startTransactionFactory = new StartTransactionFactory(apiService);
        extendedRequestFactories.put(startTransactionFactory.getOid(), startTransactionFactory);
        extendedResponseFactories.put(startTransactionFactory.getOid(), startTransactionFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, startTransactionFactory.getOid()));
        }
        StoredProcedureFactory storedProcedureFactory = new StoredProcedureFactory(apiService);
        extendedRequestFactories.put(storedProcedureFactory.getOid(), storedProcedureFactory);
        extendedResponseFactories.put(storedProcedureFactory.getOid(), storedProcedureFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, storedProcedureFactory.getOid()));
        }
        WhoAmIFactory whoAmIFactory = new WhoAmIFactory(apiService);
        extendedRequestFactories.put(whoAmIFactory.getOid(), whoAmIFactory);
        extendedResponseFactories.put(whoAmIFactory.getOid(), whoAmIFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06001_REGISTERED_EXTENDED_OP_FACTORY, whoAmIFactory.getOid()));
        }
    }

    public static void loadExtrasIntermediateResponses(LdapApiService apiService) {
        Map<String, IntermediateOperationFactory> intermediateResponseFactories = apiService.getIntermediateResponseFactories();
        SyncInfoValueFactory syncInfoValueFactory = new SyncInfoValueFactory();
        intermediateResponseFactories.put(syncInfoValueFactory.getOid(), syncInfoValueFactory);
        if (LOG.isInfoEnabled()) {
            LOG.info(I18n.msg(I18n.MSG_06002_REGISTERED_INTERMEDIATE_FACTORY, syncInfoValueFactory.getOid()));
        }
    }
}

