/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.response.search.entry;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.DnFactory;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchResultEntryObjectName
extends GrammarAction<LdapMessageContainer<SearchResultEntry>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchResultEntryObjectName.class);

    public StoreSearchResultEntryObjectName() {
        super("Store SearchResultEntry name");
    }

    public void action(LdapMessageContainer<SearchResultEntry> container) throws DecoderException {
        SearchResultEntry searchResultEntry = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            searchResultEntry.setObjectName(Dn.EMPTY_DN);
        } else {
            byte[] dnBytes = tlv.getValue().getData();
            String dnStr = Strings.utf8ToString((byte[])dnBytes);
            try {
                DnFactory dnFactory = container.getDnFactory();
                Dn objectName = dnFactory == null ? new Dn(new String[]{dnStr}) : dnFactory.create(dnStr);
                searchResultEntry.setObjectName(objectName);
            }
            catch (LdapInvalidDnException ine) {
                String msg = I18n.err((I18n)I18n.ERR_05157_INVALID_DN, (Object[])new Object[]{Strings.dumpBytes((byte[])dnBytes), ine.getMessage()});
                LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, ine.getMessage()}));
                throw new DecoderException(msg, (Throwable)ine);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05182_SEARCH_RESULT_ENTRY_DN, (Object[])new Object[]{searchResultEntry.getObjectName()}));
        }
    }
}

