/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletException;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.dispatch.InvocationChain;
import org.apache.felix.http.base.internal.dispatch.MultipartConfig;
import org.apache.felix.http.base.internal.dispatch.RequestInfo;
import org.apache.felix.http.base.internal.dispatch.ServletRequestMultipartWrapper;
import org.apache.felix.http.base.internal.dispatch.ServletRequestWrapper;
import org.apache.felix.http.base.internal.dispatch.ServletResponseWrapper;
import org.apache.felix.http.base.internal.handler.FilterHandler;
import org.apache.felix.http.base.internal.handler.HttpSessionWrapper;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.registry.PathResolution;
import org.apache.felix.http.base.internal.registry.PerContextHandlerRegistry;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.apache.felix.http.jakartawrappers.ServletExceptionWrapper;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.servlet.whiteboard.Preprocessor;

public final class Dispatcher {
    private final HandlerRegistry handlerRegistry;
    private volatile WhiteboardManager whiteboardManager;

    public Dispatcher(HandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public void setWhiteboardManager(@Nullable WhiteboardManager service) {
        this.whiteboardManager = service;
    }

    public void dispatch(HttpServletRequest req, HttpServletResponse res) throws jakarta.servlet.ServletException, IOException {
        WhiteboardManager mgr = this.whiteboardManager;
        if (mgr == null) {
            if (!res.isCommitted()) {
                res.sendError(404);
            }
            return;
        }
        HttpSession session = req.getSession(false);
        if (session != null) {
            Set<String> names = HttpSessionWrapper.getExpiredSessionContextNames(session);
            mgr.sessionDestroyed(session, names);
        }
        mgr.invokePreprocessors(req, res, new Preprocessor(){

            public void init(FilterConfig filterConfig) throws jakarta.servlet.ServletException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, jakarta.servlet.ServletException {
                String requestURI;
                PathResolution pr;
                HttpServletRequest req = (HttpServletRequest)request;
                HttpServletResponse res = (HttpServletResponse)response;
                String path = req.getServletPath();
                if (path == null) {
                    path = "";
                }
                if (req.getPathInfo() != null) {
                    path = path.concat(req.getPathInfo());
                }
                PerContextHandlerRegistry errorRegistry = (pr = Dispatcher.this.handlerRegistry.resolveServlet(requestURI = path)) != null ? pr.handlerRegistry : Dispatcher.this.handlerRegistry.getBestMatchingRegistry(requestURI);
                String servletName = pr != null ? pr.handler.getName() : null;
                ServletResponseWrapper wrappedResponse = new ServletResponseWrapper(req, res, servletName, errorRegistry);
                if (pr == null) {
                    if (!wrappedResponse.isCommitted()) {
                        wrappedResponse.sendError(404);
                    }
                    return;
                }
                ExtServletContext servletContext = pr.handler.getContext();
                RequestInfo requestInfo = new RequestInfo(pr.servletPath, pr.pathInfo, null, req.getRequestURI(), pr.handler.getName(), pr.matchedPattern, pr.matchValue, pr.match, false);
                MultipartConfig multipartConfig = pr.handler.getMultipartConfig();
                ServletRequestWrapper wrappedRequest = multipartConfig == null ? new ServletRequestWrapper(req, servletContext, requestInfo, null, pr.handler.getServletInfo().isAsyncSupported()) : new ServletRequestMultipartWrapper(req, servletContext, requestInfo, null, pr.handler.getServletInfo().isAsyncSupported(), multipartConfig, pr.handler.getMultipartSecurityContext());
                FilterHandler[] filterHandlers = Dispatcher.this.handlerRegistry.getFilters(pr, req.getDispatcherType(), pr.requestURI);
                try {
                    if (servletContext.getServletRequestListener() != null) {
                        servletContext.getServletRequestListener().requestInitialized(new ServletRequestEvent((ServletContext)servletContext, (ServletRequest)wrappedRequest));
                    }
                    InvocationChain filterChain = new InvocationChain(pr.handler, filterHandlers);
                    filterChain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
                }
                catch (Exception e2) {
                    ServletException e2;
                    if (e2 instanceof ServletExceptionWrapper) {
                        e2 = ((ServletExceptionWrapper)e2).getException();
                    }
                    SystemLogger.LOGGER.error("Exception while processing request to " + requestURI, (Throwable)e2);
                    req.setAttribute("jakarta.servlet.error.exception", (Object)e2);
                    req.setAttribute("jakarta.servlet.error.exception_type", e2.getClass());
                    if (!wrappedResponse.isCommitted()) {
                        wrappedResponse.sendError(500);
                    }
                }
                finally {
                    if (servletContext.getServletRequestListener() != null) {
                        servletContext.getServletRequestListener().requestDestroyed(new ServletRequestEvent((ServletContext)servletContext, (ServletRequest)wrappedRequest));
                    }
                }
            }

            public void destroy() {
            }
        });
    }
}

