/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.util.Map;
import java.util.Queue;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.ext.ArrayIdQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcknowledgedMessagesClientExtension
implements ServerSession.Extension {
    private final Logger _logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final ServerSessionImpl _session;
    private final Object _lock;
    private final ArrayIdQueue<ServerMessage> _unackedQueue;
    private long _lastAck;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AcknowledgedMessagesClientExtension(ServerSession session) {
        this._session = (ServerSessionImpl)session;
        Object object = this._lock = this._session.getLock();
        synchronized (object) {
            Queue<ServerMessage> queue = this._session.getQueue();
            this._unackedQueue = new ArrayIdQueue(16, 32, queue);
            this._unackedQueue.setCurrentId(1);
        }
    }

    public boolean rcv(ServerSession from, ServerMessage.Mutable message) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rcvMeta(ServerSession session, ServerMessage.Mutable message) {
        Map<String, Object> ext;
        if ("/meta/connect".equals(message.getChannel()) && (ext = message.getExt(false)) != null) {
            assert (session == this._session);
            Object object = this._lock;
            synchronized (object) {
                Number ackValue = (Number)ext.get("ack");
                this._logger.debug("Session {} received ack {}, lastAck {}", new Object[]{session, ackValue, this._lastAck});
                if (ackValue != null) {
                    long acked = ackValue.longValue();
                    if (acked <= this._lastAck) {
                        this._session.replaceQueue(this._unackedQueue);
                    } else {
                        this._lastAck = acked;
                        int s = this._unackedQueue.size();
                        if (s > 0) {
                            if ((long)this._unackedQueue.getAssociatedIdUnsafe(s - 1) <= acked) {
                                this._unackedQueue.clear();
                            } else {
                                long a;
                                for (int i = 0; i < s && (a = (long)this._unackedQueue.getAssociatedIdUnsafe(0)) <= acked; ++i) {
                                    this._unackedQueue.remove();
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerMessage send(ServerSession to, ServerMessage message) {
        if (message.containsKey("data")) {
            Object object = this._lock;
            synchronized (object) {
                this._unackedQueue.add(message);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMeta(ServerSession to, ServerMessage.Mutable message) {
        if (message.getChannel().equals("/meta/connect")) {
            Object object = this._lock;
            synchronized (object) {
                Map<String, Object> ext = message.getExt(true);
                ext.put("ack", this._unackedQueue.getCurrentId());
                this._unackedQueue.incrementCurrentId();
            }
        }
        return true;
    }
}

