/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.testing.async;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.AsyncServerExchangeHandler;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;

public class ServiceUnavailableAsyncDecorator
implements AsyncServerExchangeHandler {
    private final AsyncServerExchangeHandler exchangeHandler;
    private final Resolver<HttpRequest, TimeValue> serviceAvailabilityResolver;
    private final AtomicBoolean serviceUnavailable;

    public ServiceUnavailableAsyncDecorator(AsyncServerExchangeHandler exchangeHandler, Resolver<HttpRequest, TimeValue> serviceAvailabilityResolver) {
        this.exchangeHandler = (AsyncServerExchangeHandler)Args.notNull((Object)exchangeHandler, (String)"Exchange handler");
        this.serviceAvailabilityResolver = (Resolver)Args.notNull(serviceAvailabilityResolver, (String)"Service availability resolver");
        this.serviceUnavailable = new AtomicBoolean();
    }

    public void handleRequest(HttpRequest request, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext context) throws HttpException, IOException {
        TimeValue retryAfter = (TimeValue)this.serviceAvailabilityResolver.resolve((Object)request);
        this.serviceUnavailable.set(TimeValue.isPositive((TimeValue)retryAfter));
        if (this.serviceUnavailable.get()) {
            BasicHttpResponse response = new BasicHttpResponse(503);
            response.addHeader("Retry-After", (Object)Long.toString(retryAfter.toSeconds()));
            ProtocolVersion version = request.getVersion();
            if (version != null && version.compareToVersion((ProtocolVersion)HttpVersion.HTTP_2) < 0) {
                response.addHeader("Connection", (Object)"Close");
            }
            responseChannel.sendResponse((HttpResponse)response, null, context);
        } else {
            this.exchangeHandler.handleRequest(request, entityDetails, responseChannel, context);
        }
    }

    public final void updateCapacity(CapacityChannel capacityChannel) throws IOException {
        if (!this.serviceUnavailable.get()) {
            this.exchangeHandler.updateCapacity(capacityChannel);
        } else {
            capacityChannel.update(Integer.MAX_VALUE);
        }
    }

    public final void consume(ByteBuffer src) throws IOException {
        if (!this.serviceUnavailable.get()) {
            this.exchangeHandler.consume(src);
        }
    }

    public final void streamEnd(List<? extends Header> trailers) throws HttpException, IOException {
        if (!this.serviceUnavailable.get()) {
            this.exchangeHandler.streamEnd(trailers);
        }
    }

    public int available() {
        if (!this.serviceUnavailable.get()) {
            return this.exchangeHandler.available();
        }
        return 0;
    }

    public void produce(DataStreamChannel channel) throws IOException {
        if (!this.serviceUnavailable.get()) {
            this.exchangeHandler.produce(channel);
        }
    }

    public void failed(Exception cause) {
        if (!this.serviceUnavailable.get()) {
            this.exchangeHandler.failed(cause);
        }
    }

    public void releaseResources() {
        this.exchangeHandler.releaseResources();
    }
}

