/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer;

import java.util.ArrayList;
import org.apache.ignite.internal.cli.commands.TopLevelCliReplCommand;
import picocli.CommandLine;

public class DynamicCompletionInsider {
    private final CommandLine commandLine = new CommandLine(TopLevelCliReplCommand.class);

    private static String[] trim(String[] typedWords) {
        ArrayList<String> trimmedWords = new ArrayList<String>(typedWords.length);
        int offset = 0;
        for (String typedWord : typedWords) {
            String currentTrim = typedWord.trim();
            if (currentTrim.isEmpty()) {
                ++offset;
                continue;
            }
            trimmedWords.add(currentTrim);
        }
        return trimmedWords.toArray(new String[typedWords.length - offset]);
    }

    public boolean wasPositionalParameterCompleted(String[] typedWords) {
        try {
            String[] trimmedWords = DynamicCompletionInsider.trim(typedWords);
            CommandLine.ParseResult parseResult = this.commandLine.parseArgs(trimmedWords);
            while (parseResult.hasSubcommand()) {
                parseResult = parseResult.subcommand();
            }
            boolean hasPositional = parseResult.hasMatchedPositional(0);
            boolean wasTrimmed = trimmedWords.length == typedWords.length;
            String matchedPositional = (String)((CommandLine.Model.PositionalParamSpec)parseResult.matchedPositionals().get(0)).originalStringValues().get(0);
            boolean lastWordIsPositional = matchedPositional.equals(trimmedWords[trimmedWords.length - 1]);
            boolean positionalTyping = wasTrimmed && hasPositional && lastWordIsPositional;
            return !positionalTyping && hasPositional;
        }
        catch (CommandLine.MissingParameterException e) {
            return e.getMissing().stream().noneMatch(CommandLine.Model.ArgSpec::isPositional);
        }
        catch (Exception e) {
            return false;
        }
    }
}

