/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.sql;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ignite3.internal.catalog.sql.QueryContext;
import org.apache.ignite3.internal.catalog.sql.QueryPart;

class QueryPartCollection<T extends QueryPart>
extends QueryPart
implements Collection<T> {
    private final Collection<T> wrapped;
    private static final String SEPARATOR = ", ";
    private boolean formatSeparator = false;

    static <T extends QueryPart> QueryPartCollection<T> partsList(Collection<T> wrapped) {
        return new QueryPartCollection<T>(wrapped);
    }

    @SafeVarargs
    static <T extends QueryPart> QueryPartCollection<T> partsList(T ... wrapped) {
        return QueryPartCollection.partsList(Arrays.asList(wrapped));
    }

    private QueryPartCollection(Collection<T> wrapped) {
        this.wrapped = wrapped;
    }

    QueryPartCollection<T> formatSeparator() {
        return this.formatSeparator(true);
    }

    QueryPartCollection<T> formatSeparator(boolean b) {
        this.formatSeparator = b;
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        boolean first = true;
        for (QueryPart part : this.wrapped) {
            if (!first) {
                ctx.sql(SEPARATOR);
                if (this.formatSeparator) {
                    ctx.formatSeparator();
                }
            }
            ctx.visit(part);
            first = false;
        }
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.wrapped.toArray(a);
    }

    @Override
    public boolean add(T t) {
        return this.wrapped.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.wrapped.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.wrapped.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.wrapped.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.wrapped.retainAll(c);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }
}

