/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage;

import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.commands.CatalogUtils;
import org.apache.ignite3.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.storage.UpdateEntry;
import org.apache.ignite3.internal.hlc.HybridTimestamp;

abstract class UpdateTable
implements UpdateEntry {
    UpdateTable() {
    }

    @Override
    public final Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(catalog, this.tableId());
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, table.schemaId());
        CatalogTableDescriptor modifiedTable = this.newTableDescriptor(table).timestamp(timestamp).build();
        CatalogSchemaDescriptor modifiedSchemaDescriptor = CatalogUtils.replaceTable(schema, modifiedTable);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(modifiedSchemaDescriptor, catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    abstract CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor var1);

    abstract int tableId();

    static int newSchemaVersion(CatalogTableDescriptor table) {
        return table.latestSchemaVersion() + 1;
    }
}

