/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.sql;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.apache.ignite3.internal.cli.call.sql.SqlQueryCall;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.sql.SqlCompleter;
import org.apache.ignite3.internal.cli.commands.sql.SqlReplTopLevelCliCommand;
import org.apache.ignite3.internal.cli.commands.sql.help.IgniteSqlCommandCompleter;
import org.apache.ignite3.internal.cli.commands.treesitter.highlighter.SqlAttributedStringHighlighter;
import org.apache.ignite3.internal.cli.config.CliConfigKeys;
import org.apache.ignite3.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite3.internal.cli.core.CallExecutionPipelineProvider;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.call.SingleCallExecutionPipelineBuilder;
import org.apache.ignite3.internal.cli.core.call.StringCallInput;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.handler.SqlExceptionHandler;
import org.apache.ignite3.internal.cli.core.repl.Repl;
import org.apache.ignite3.internal.cli.core.repl.Session;
import org.apache.ignite3.internal.cli.core.repl.executor.RegistryCommandExecutor;
import org.apache.ignite3.internal.cli.core.repl.executor.ReplExecutorProvider;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.core.style.AnsiStringSupport;
import org.apache.ignite3.internal.cli.decorators.SqlQueryResultDecorator;
import org.apache.ignite3.internal.cli.sql.SqlManager;
import org.apache.ignite3.internal.cli.sql.SqlSchemaProvider;
import org.apache.ignite3.internal.util.StringUtils;
import org.apache.ignite3.rest.client.api.ClusterManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.jline.reader.Completer;
import org.jline.reader.EOFError;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.SyntaxError;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.completer.AggregateCompleter;
import org.jline.utils.AttributedString;
import picocli.CommandLine;

@CommandLine.Command(name="sql", description={"Executes SQL query"})
public class SqlExecReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Option(names={"--jdbc-url"}, required=true, descriptionKey="ignite.jdbc-url", description={"JDBC url to ignite cluster. For example, 'jdbc:ignite:thin://127.0.0.1:10800'"})
    private String jdbc;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @CommandLine.ArgGroup
    private ExecOptions execOptions;
    @Inject
    private ReplExecutorProvider replExecutorProvider;
    @Inject
    private ConfigManagerProvider configManagerProvider;
    @Inject
    private Session session;
    @Inject
    private ApiClientFactory clientFactory;

    private static String extract(File file) {
        try {
            return String.join((CharSequence)"\n", Files.readAllLines(file.toPath(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IgniteCliException("File [" + file.getAbsolutePath() + "] not found");
        }
    }

    @Override
    public void run() {
        try (SqlManager sqlManager = new SqlManager(this.jdbc);){
            if (this.execOptions == null || StringUtils.nullOrBlank(this.execOptions.command) && this.execOptions.file == null) {
                SqlSchemaProvider schemaProvider = new SqlSchemaProvider(sqlManager::getMetadata);
                schemaProvider.initStateAsync();
                SqlCompleter sqlCompleter = new SqlCompleter(schemaProvider);
                IgniteSqlCommandCompleter sqlCommandCompleter = new IgniteSqlCommandCompleter();
                this.replExecutorProvider.get().execute(Repl.builder().withPromptProvider(() -> AnsiStringSupport.ansi(AnsiStringSupport.fg(AnsiStringSupport.Color.GREEN).mark("sql-cli> "))).withCompleter((Completer)new AggregateCompleter(new Completer[]{sqlCommandCompleter, sqlCompleter})).withCommandClass(SqlReplTopLevelCliCommand.class).withCallExecutionPipelineProvider(this.provider(sqlManager)).withHistoryFileName("sqlhistory").withAutosuggestionsWidgets().withHighlighter(this.highlightingEnabled() ? new HighlighterImpl() : new DefaultHighlighter()).withParser(this.multilineSupported() ? new MultilineParser() : new DefaultParser()).build());
            } else {
                String executeCommand = this.execOptions.file != null ? SqlExecReplCommand.extract(this.execOptions.file) : this.execOptions.command;
                this.createSqlExecPipeline(sqlManager, executeCommand).runPipeline();
            }
        }
        catch (SQLException e) {
            String url = this.session.info() == null ? null : this.session.info().nodeUrl();
            ExceptionWriter exceptionWriter = ExceptionWriter.fromPrintWriter(this.spec.commandLine().getErr());
            try {
                if (url != null) {
                    new ClusterManagementApi(this.clientFactory.getClient(url)).clusterState();
                }
                SqlExceptionHandler.INSTANCE.handle(exceptionWriter, e);
            }
            catch (ApiException apiE) {
                new ClusterNotInitializedExceptionHandler("Failed to start sql repl mode", "cluster init").handle(exceptionWriter, new IgniteCliApiException(apiE, url));
            }
        }
    }

    private boolean multilineSupported() {
        return Boolean.parseBoolean(this.configManagerProvider.get().getCurrentProperty(CliConfigKeys.SQL_MULTILINE.value()));
    }

    private boolean highlightingEnabled() {
        return Boolean.parseBoolean(this.configManagerProvider.get().getCurrentProperty(CliConfigKeys.SYNTAX_HIGHLIGHTING.value()));
    }

    private CallExecutionPipelineProvider provider(SqlManager sqlManager) {
        return (executor, exceptionHandlers, line) -> executor.hasCommand(SqlExecReplCommand.dropSemicolon(line)) ? this.createInternalCommandPipeline(executor, exceptionHandlers, line) : this.createSqlExecPipeline(sqlManager, line);
    }

    private CallExecutionPipeline<?, ?> createSqlExecPipeline(SqlManager sqlManager, String line) {
        return ((SingleCallExecutionPipelineBuilder)((SingleCallExecutionPipelineBuilder)((SingleCallExecutionPipelineBuilder)CallExecutionPipeline.builder(new SqlQueryCall(sqlManager)).inputProvider(() -> new StringCallInput(line)).output(this.spec.commandLine().getOut())).errOutput(this.spec.commandLine().getErr())).decorator(new SqlQueryResultDecorator(this.plain)).verbose(this.verbose)).exceptionHandler(SqlExceptionHandler.INSTANCE).build();
    }

    private CallExecutionPipeline<?, ?> createInternalCommandPipeline(RegistryCommandExecutor call, ExceptionHandlers exceptionHandlers, String line) {
        return ((SingleCallExecutionPipelineBuilder)((SingleCallExecutionPipelineBuilder)((SingleCallExecutionPipelineBuilder)CallExecutionPipeline.builder(call).inputProvider(() -> new StringCallInput(SqlExecReplCommand.dropSemicolon(line))).output(this.spec.commandLine().getOut())).errOutput(this.spec.commandLine().getErr())).exceptionHandlers(exceptionHandlers).verbose(this.verbose)).build();
    }

    private static String dropSemicolon(String line) {
        if (line.trim().endsWith(";")) {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }

    private static class ExecOptions {
        @CommandLine.Parameters(index="0", description={"SQL query to execute"}, defaultValue="_NULL_")
        private String command;
        @CommandLine.Option(names={"--file"}, description={"Path to file with SQL commands to execute"}, defaultValue="_NULL_")
        private File file;

        private ExecOptions() {
        }
    }

    private static class HighlighterImpl
    implements Highlighter {
        private HighlighterImpl() {
        }

        public AttributedString highlight(LineReader lineReader, String s) {
            return SqlAttributedStringHighlighter.highlight(s);
        }

        public void setErrorPattern(Pattern pattern) {
        }

        public void setErrorIndex(int i) {
        }
    }

    private static final class MultilineParser
    implements Parser {
        private static final Parser DEFAULT_PARSER = new DefaultParser();

        private MultilineParser() {
        }

        public ParsedLine parse(String line, int cursor, Parser.ParseContext context) throws SyntaxError {
            if (!(Parser.ParseContext.UNSPECIFIED != context && Parser.ParseContext.ACCEPT_LINE != context || line.trim().endsWith(";"))) {
                throw new EOFError(-1, cursor, "Missing semicolon (;)");
            }
            return DEFAULT_PARSER.parse(line, cursor, context);
        }
    }
}

