/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.completer.path;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite3.internal.cli.core.repl.completer.DynamicCompleter;
import org.apache.ignite3.internal.cli.util.ArrayUtils;

public class FilePathCompleter
implements DynamicCompleter {
    @Override
    public List<String> complete(String[] words) {
        String notEmptyWord = ArrayUtils.findLastNotEmptyWord(words);
        try {
            return FilePathCompleter.scan(notEmptyWord);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    private static List<String> scan(String path) throws IOException {
        Path filePath = Paths.get(path, new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            if (Files.isDirectory(filePath, new LinkOption[0])) {
                return FilePathCompleter.listFiles(filePath, "");
            }
            return Collections.singletonList(path);
        }
        int lastIndexOfPathSeparator = path.lastIndexOf(File.separator);
        if (lastIndexOfPathSeparator > -1) {
            String dir = path.substring(0, lastIndexOfPathSeparator + 1);
            String filePrefix = path.substring(lastIndexOfPathSeparator + 1);
            return FilePathCompleter.listFiles(Paths.get(dir, new String[0]), filePrefix);
        }
        return Collections.emptyList();
    }

    private static List<String> listFiles(Path path, String prefix) throws IOException {
        try (Stream<Path> stream = Files.list(path);){
            List<String> list = stream.filter(it -> it.getFileName().toString().startsWith(prefix)).map(Path::toString).collect(Collectors.toList());
            return list;
        }
    }
}

