/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.client.tx;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.ignite3.internal.client.ClientChannel;
import org.apache.ignite3.internal.client.PayloadInputChannel;
import org.apache.ignite3.internal.client.ReliableChannel;
import org.apache.ignite3.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite3.internal.client.tx.ClientLazyTransaction;
import org.apache.ignite3.internal.client.tx.ClientTransaction;
import org.apache.ignite3.internal.util.ViewUtils;
import org.apache.ignite3.tx.IgniteTransactions;
import org.apache.ignite3.tx.Transaction;
import org.apache.ignite3.tx.TransactionOptions;
import org.jetbrains.annotations.Nullable;

public class ClientTransactions
implements IgniteTransactions {
    public static final int USE_CONFIGURED_TIMEOUT_DEFAULT = 0;
    private final ReliableChannel ch;

    public ClientTransactions(ReliableChannel ch) {
        this.ch = ch;
    }

    @Override
    public Transaction begin(@Nullable TransactionOptions options) {
        return ViewUtils.sync(this.beginAsync(options));
    }

    @Override
    public CompletableFuture<Transaction> beginAsync(@Nullable TransactionOptions options) {
        return CompletableFuture.completedFuture(new ClientLazyTransaction(this.ch.observableTimestamp(), options));
    }

    static CompletableFuture<ClientTransaction> beginAsync(ReliableChannel ch, @Nullable TransactionOptions options, long observableTimestamp, Supplier<CompletableFuture<ClientChannel>> channelResolver) {
        boolean readOnly = options != null && options.readOnly();
        long timeout = options == null ? 0L : options.timeoutMillis();
        return ch.serviceAsync(43, w -> {
            w.out().packBoolean(readOnly);
            w.out().packLong(timeout);
            w.out().packLong(observableTimestamp);
        }, r -> ClientTransactions.readTx(r, readOnly, timeout), channelResolver, null, false);
    }

    private static ClientTransaction readTx(PayloadInputChannel r, boolean isReadOnly, long timeout) {
        ClientMessageUnpacker in = r.in();
        long id = in.unpackLong();
        return new ClientTransaction(r.clientChannel(), id, isReadOnly, ClientTransaction.EMPTY, null, ClientTransaction.EMPTY, null, timeout);
    }
}

