/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.distributionzones;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ignite3.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite3.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite3.internal.distributionzones.NodeWithAttributesSerializer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.apache.ignite3.internal.versioned.VersionedSerializer;

public class DistributionZoneTimer {
    public static final DistributionZoneTimer DEFAULT_TIMER = new DistributionZoneTimer(HybridTimestamp.MIN_VALUE, 0, Set.of());
    private final HybridTimestamp createTimestamp;
    private final int timeToWaitInSeconds;
    private final Set<NodeWithAttributes> nodes;

    public DistributionZoneTimer(HybridTimestamp createTimestamp, int timeToWaitInSeconds, Set<NodeWithAttributes> nodes) {
        this.createTimestamp = createTimestamp;
        this.timeToWaitInSeconds = timeToWaitInSeconds;
        this.nodes = nodes;
    }

    public HybridTimestamp createTimestamp() {
        return this.createTimestamp;
    }

    public int timeToWaitInSeconds() {
        return this.timeToWaitInSeconds;
    }

    public Set<NodeWithAttributes> nodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public HybridTimestamp timeToTrigger() {
        if (this.timeToWaitInSeconds == Integer.MAX_VALUE) {
            return HybridTimestamp.MAX_VALUE;
        }
        return this.createTimestamp.addPhysicalTime((long)this.timeToWaitInSeconds * 1000L);
    }

    public DistributionZoneTimer modifyTimeToWait(int newTimeToWaitInSeconds) {
        if (this.equals(DEFAULT_TIMER)) {
            return DEFAULT_TIMER;
        }
        return new DistributionZoneTimer(this.createTimestamp, newTimeToWaitInSeconds, this.nodes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionZoneTimer that = (DistributionZoneTimer)o;
        return this.timeToWaitInSeconds == that.timeToWaitInSeconds && Objects.equals(this.createTimestamp, that.createTimestamp) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.createTimestamp, this.timeToWaitInSeconds, this.nodes);
    }

    public String toString() {
        String timeToWaitStr = this.timeToWaitInSeconds == Integer.MAX_VALUE ? "[infinite]" : String.valueOf(this.timeToWaitInSeconds);
        return this.equals(DEFAULT_TIMER) ? "[empty]" : "[timestamp=" + this.createTimestamp + ", timeToWaitInSeconds=" + timeToWaitStr + ", nodes=" + DistributionZonesUtil.nodeNames(this.nodes) + "]";
    }

    public static class DistributionZoneTimerSerializer
    extends VersionedSerializer<DistributionZoneTimer> {
        private static final DistributionZoneTimerSerializer INSTANCE = new DistributionZoneTimerSerializer();

        @Override
        protected void writeExternalData(DistributionZoneTimer object, IgniteDataOutput out) throws IOException {
            out.writeVarInt(object.createTimestamp.longValue());
            out.writeVarInt(object.timeToWaitInSeconds);
            out.writeCollection(new TreeSet<NodeWithAttributes>(object.nodes), NodeWithAttributesSerializer.INSTANCE::writeExternal);
        }

        @Override
        protected DistributionZoneTimer readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
            HybridTimestamp timestamp = HybridTimestamp.hybridTimestamp(in.readVarInt());
            int timeToWaitInSeconds = in.readVarIntAsInt();
            Set nodes = in.readCollection(unused -> new TreeSet(), NodeWithAttributesSerializer.INSTANCE::readExternal);
            return new DistributionZoneTimer(timestamp, timeToWaitInSeconds, nodes);
        }

        public static byte[] serialize(DistributionZoneTimer timer) {
            return VersionedSerialization.toBytes(timer, INSTANCE);
        }

        public static DistributionZoneTimer deserialize(byte[] bytes) {
            return VersionedSerialization.fromBytes(bytes, INSTANCE);
        }
    }
}

