/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowEx;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.InternalTupleEx;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.SqlOutputBinaryRow;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;

public class TableRowConverterImpl
implements TableRowConverter {
    protected final SchemaRegistry schemaRegistry;
    protected final SchemaDescriptor schemaDescriptor;

    TableRowConverterImpl(SchemaRegistry schemaRegistry, SchemaDescriptor schemaDescriptor) {
        this.schemaRegistry = schemaRegistry;
        this.schemaDescriptor = schemaDescriptor;
    }

    @Override
    public <RowT> BinaryRowEx toFullRow(ExecutionContext<RowT> ectx, RowT row) {
        BinaryTuple binaryTuple = ectx.rowHandler().toBinaryTuple(row);
        return SqlOutputBinaryRow.newRow(this.schemaDescriptor, binaryTuple);
    }

    @Override
    public <RowT> BinaryRowEx toKeyRow(ExecutionContext<RowT> ectx, RowT row) {
        BinaryTuple binaryTuple = ectx.rowHandler().toBinaryTuple(row);
        return SqlOutputBinaryRow.newKeyRow(this.schemaDescriptor, binaryTuple);
    }

    @Override
    public <RowT> RowT toRow(ExecutionContext<RowT> ectx, BinaryRow tableRow, RowHandler.RowFactory<RowT> factory) {
        InternalTupleEx tuple = tableRow.schemaVersion() == this.schemaDescriptor.version() ? new BinaryTuple(this.schemaDescriptor.length(), tableRow.tupleSlice()) : this.schemaRegistry.resolve(tableRow, this.schemaDescriptor);
        return factory.create(tuple);
    }
}

