/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.schema.IgniteDataSource;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectableFilterableTableScan
extends TableScan {
    @Nullable
    protected final RexNode condition;
    @Nullable
    protected final List<RexNode> projects;
    @Nullable
    protected final List<String> names;
    @Nullable
    protected final ImmutableIntList requiredColumns;

    protected ProjectableFilterableTableScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, @Nullable List<String> names, @Nullable List<RexNode> projects, @Nullable RexNode condition, @Nullable ImmutableIntList requiredColumns) {
        super(cluster, traitSet, hints, table);
        this.names = names;
        this.projects = projects;
        this.condition = condition;
        this.requiredColumns = requiredColumns;
    }

    protected ProjectableFilterableTableScan(RelInput input) {
        super(input);
        this.condition = input.getExpression("filters");
        this.names = input.get("names") == null ? null : input.getStringList("names");
        this.projects = input.get("projects") == null ? null : input.getExpressionList("projects");
        List requiredColumns0 = input.getIntegerList("requiredColumns");
        this.requiredColumns = requiredColumns0 == null ? null : ImmutableIntList.copyOf((Iterable)requiredColumns0);
    }

    @Nullable
    public List<String> fieldNames() {
        return this.names;
    }

    @Nullable
    public List<RexNode> projects() {
        return this.projects;
    }

    @Nullable
    public RexNode condition() {
        return this.condition;
    }

    @Nullable
    public ImmutableIntList requiredColumns() {
        return this.requiredColumns;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    protected abstract ProjectableFilterableTableScan copy(@Nullable List<RexNode> var1, @Nullable RexNode var2);

    public RelWriter explainTerms(RelWriter pw) {
        return this.explainTerms0(pw.item("table", (Object)this.table.getQualifiedName()).item("tableId", (Object)Integer.toString(((IgniteDataSource)this.table.unwrap(IgniteDataSource.class)).id())));
    }

    public RelNode accept(RexShuttle shuttle) {
        RexNode condition0 = shuttle.apply(this.condition);
        List projects0 = shuttle.apply(this.projects);
        if (condition0 == this.condition && projects0 == this.projects) {
            return this;
        }
        return this.copy(projects0, condition0);
    }

    protected RelWriter explainTerms0(RelWriter pw) {
        if (this.condition != null) {
            pw.item("filters", (Object)(pw.nest() ? this.condition : RexUtil.expandSearch((RexBuilder)this.getCluster().getRexBuilder(), null, (RexNode)this.condition)));
        }
        return pw.itemIf("names", this.names, this.names != null).itemIf("projects", this.projects, this.projects != null).itemIf("requiredColumns", (Object)this.requiredColumns, this.requiredColumns != null);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rows = this.table.getRowCount();
        double cost = rows * 1.0;
        if (this.condition != null) {
            cost += rows * 3.0;
        }
        return planner.getCostFactory().makeCost(rows, cost, 0.0);
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return this.table.getRowCount() * mq.getSelectivity((RelNode)this, null);
    }

    public RelDataType deriveRowType() {
        IgniteTypeFactory typeFactory = Commons.typeFactory(this.getCluster());
        List projects = this.projects;
        if (projects == null && this.names != null) {
            RelDataType type = ((IgniteDataSource)this.table.unwrap(IgniteDataSource.class)).getRowType((RelDataTypeFactory)typeFactory, this.requiredColumns);
            projects = this.getCluster().getRexBuilder().identityProjects(type);
        }
        if (projects != null) {
            return RexUtil.createStructType((RelDataTypeFactory)typeFactory, projects, this.names, (SqlValidatorUtil.Suggester)SqlValidatorUtil.ATTEMPT_SUGGESTER);
        }
        return ((IgniteDataSource)this.table.unwrap(IgniteDataSource.class)).getRowType((RelDataTypeFactory)typeFactory, this.requiredColumns);
    }

    public RexNode pushUpPredicate() {
        if (this.condition == null || this.projects == null) {
            return RexUtils.replaceLocalRefs(this.condition);
        }
        IgniteTypeFactory typeFactory = Commons.typeFactory(this.getCluster());
        IgniteTable tbl = (IgniteTable)this.getTable().unwrap(IgniteTable.class);
        final Mappings.TargetMapping mapping = RexUtils.inversePermutation(this.projects, tbl.getRowType((RelDataTypeFactory)typeFactory, this.requiredColumns), true);
        RexShuttle shuttle = new RexShuttle(){

            public RexNode visitLocalRef(RexLocalRef ref) {
                int targetRef = mapping.getSourceOpt(ref.getIndex());
                if (targetRef == -1) {
                    throw new ControlFlowException();
                }
                return new RexInputRef(targetRef, ref.getType());
            }
        };
        ArrayList<RexNode> conjunctions = new ArrayList<RexNode>();
        for (RexNode conjunction : RelOptUtil.conjunctions((RexNode)this.condition)) {
            try {
                conjunctions.add(shuttle.apply(conjunction));
            }
            catch (ControlFlowException controlFlowException) {}
        }
        return RexUtil.composeConjunction((RexBuilder)RexUtils.builder(this.getCluster()), conjunctions, (boolean)true);
    }

    protected IgniteRelWriter explainAttributes(IgniteRelWriter writer) {
        writer.addTable(this.table);
        if (this.condition != null || this.projects != null) {
            RelDataType rowType = this.getTable().getRowType();
            if (this.requiredColumns != null) {
                RelDataTypeFactory tf = this.getCluster().getTypeFactory();
                IgniteDataSource dataSource = (IgniteDataSource)this.getTable().unwrap(IgniteDataSource.class);
                assert (dataSource != null);
                rowType = dataSource.getRowType(tf, this.requiredColumns);
            }
            if (this.condition != null) {
                writer.addPredicate(this.condition, rowType);
            }
            if (this.projects != null && this.projects.stream().anyMatch(p -> !p.isA(SqlKind.LOCAL_REF))) {
                writer.addProjection(this.projects, rowType);
            }
        }
        return writer;
    }
}

