/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.close.ManuallyCloseable;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AbortResult;
import org.apache.ignite3.internal.storage.AddWriteCommittedResult;
import org.apache.ignite3.internal.storage.AddWriteResult;
import org.apache.ignite3.internal.storage.CommitResult;
import org.apache.ignite3.internal.storage.PartitionTimestampCursor;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.gc.GcEntry;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public interface MvPartitionStorage
extends ManuallyCloseable {
    public static final long REBALANCE_IN_PROGRESS = -1L;

    public <V> V runConsistently(WriteClosure<V> var1) throws StorageException;

    default public CompletableFuture<Void> flush() {
        return this.flush(true);
    }

    public CompletableFuture<Void> flush(boolean var1);

    public long lastAppliedIndex();

    public long lastAppliedTerm();

    public void lastApplied(long var1, long var3) throws StorageException;

    public byte @Nullable [] committedGroupConfiguration();

    public void committedGroupConfiguration(byte[] var1);

    public ReadResult read(RowId var1, HybridTimestamp var2) throws StorageException;

    public AddWriteResult addWrite(RowId var1, @Nullable BinaryRow var2, UUID var3, int var4, int var5) throws StorageException;

    public AbortResult abortWrite(RowId var1, UUID var2) throws StorageException;

    public CommitResult commitWrite(RowId var1, HybridTimestamp var2, UUID var3) throws StorageException;

    public AddWriteCommittedResult addWriteCommitted(RowId var1, @Nullable BinaryRow var2, HybridTimestamp var3) throws StorageException;

    public Cursor<ReadResult> scanVersions(RowId var1) throws StorageException;

    public PartitionTimestampCursor scan(HybridTimestamp var1) throws StorageException;

    @Nullable
    public RowId closestRowId(RowId var1) throws StorageException;

    @Nullable
    public GcEntry peek(HybridTimestamp var1);

    @Nullable
    public BinaryRow vacuum(GcEntry var1);

    public void updateLease(LeaseInfo var1);

    @Nullable
    public LeaseInfo leaseInfo();

    public long estimatedSize();

    @Override
    public void close();

    public static interface Locker {
        public void lock(RowId var1);

        public boolean tryLock(RowId var1);
    }

    @FunctionalInterface
    public static interface WriteClosure<V> {
        public V execute(Locker var1) throws StorageException;
    }
}

