/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxStateMetaFinishingMessage;
import org.apache.ignite3.internal.tx.message.TxStateMetaFinishingMessageBuilder;

class TxStateMetaFinishingMessageDeserializer
implements MessageDeserializer<TxStateMetaFinishingMessage> {
    private final TxStateMetaFinishingMessageBuilder msg;

    TxStateMetaFinishingMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txStateMetaFinishingMessage();
    }

    @Override
    public Class<TxStateMetaFinishingMessage> klass() {
        return TxStateMetaFinishingMessage.class;
    }

    @Override
    public TxStateMetaFinishingMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readBoxedLong("cleanupCompletionTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.cleanupCompletionTimestamp((Long)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitPartitionId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTimestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readBoxedLong("initialVacuumObservationTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initialVacuumObservationTimestamp((Long)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readBoxedBoolean("isFinishedDueToTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.isFinishedDueToTimeout((Boolean)tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readUuid("txCoordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txCoordinatorId((UUID)tmp);
                reader.incrementState();
            }
            case 6: {
                int shiftedId = reader.readInt("txState");
                if (!reader.isLastRead()) {
                    return false;
                }
                TxState tmp = shiftedId == 0 ? null : TxState.fromId(shiftedId - 1);
                this.msg.txState(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxStateMetaFinishingMessage.class);
    }
}

