/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.cache.configuration.Factory;
import javax.net.ssl.SSLContext;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.client.SslMode;
import org.apache.ignite.client.SslProtocol;
import org.apache.ignite.configuration.ClientConfiguration;
import org.apache.ignite.internal.client.monitoring.EventListenerDemultiplexer;

final class ClientChannelConfiguration {
    private final List<InetSocketAddress> addrs;
    private final SslMode sslMode;
    private final boolean tcpNoDelay;
    private final int timeout;
    private final int sndBufSize;
    private final int rcvBufSize;
    private final String sslClientCertKeyStorePath;
    private final String sslClientCertKeyStoreType;
    private final String sslClientCertKeyStorePwd;
    private final String sslTrustCertKeyStorePath;
    private final String sslTrustCertKeyStoreType;
    private final String sslTrustCertKeyStorePwd;
    private final String sslKeyAlgorithm;
    private final SslProtocol sslProto;
    private final boolean sslTrustAll;
    private final Factory<SSLContext> sslCtxFactory;
    private final String userName;
    private final String userPwd;
    private final long reconnectThrottlingPeriod;
    private final int reconnectThrottlingRetries;
    private final Executor asyncContinuationExecutor;
    private final Map<String, String> userAttrs;
    private final boolean heartbeatEnabled;
    private final long heartbeatInterval;
    private final boolean autoBinaryConfigurationEnabled;
    private final IgniteLogger logger;
    private final EventListenerDemultiplexer eventListener;

    ClientChannelConfiguration(ClientConfiguration cfg, List<InetSocketAddress> addrs) {
        this.sslMode = cfg.getSslMode();
        this.tcpNoDelay = cfg.isTcpNoDelay();
        this.timeout = cfg.getTimeout();
        this.sndBufSize = cfg.getSendBufferSize();
        this.rcvBufSize = cfg.getReceiveBufferSize();
        this.sslClientCertKeyStorePath = cfg.getSslClientCertificateKeyStorePath();
        this.sslClientCertKeyStoreType = cfg.getSslClientCertificateKeyStoreType();
        this.sslClientCertKeyStorePwd = cfg.getSslClientCertificateKeyStorePassword();
        this.sslTrustCertKeyStorePath = cfg.getSslTrustCertificateKeyStorePath();
        this.sslTrustCertKeyStoreType = cfg.getSslTrustCertificateKeyStoreType();
        this.sslTrustCertKeyStorePwd = cfg.getSslTrustCertificateKeyStorePassword();
        this.sslKeyAlgorithm = cfg.getSslKeyAlgorithm();
        this.sslProto = cfg.getSslProtocol();
        this.sslTrustAll = cfg.isSslTrustAll();
        this.sslCtxFactory = cfg.getSslContextFactory();
        this.userName = cfg.getUserName();
        this.userPwd = cfg.getUserPassword();
        this.reconnectThrottlingPeriod = cfg.getReconnectThrottlingPeriod();
        this.reconnectThrottlingRetries = cfg.getReconnectThrottlingRetries();
        this.addrs = Collections.unmodifiableList(addrs);
        this.userAttrs = cfg.getUserAttributes();
        this.asyncContinuationExecutor = cfg.getAsyncContinuationExecutor();
        this.heartbeatEnabled = cfg.isHeartbeatEnabled();
        this.heartbeatInterval = cfg.getHeartbeatInterval();
        this.autoBinaryConfigurationEnabled = cfg.isAutoBinaryConfigurationEnabled();
        this.logger = cfg.getLogger();
        this.eventListener = EventListenerDemultiplexer.create(cfg);
    }

    public List<InetSocketAddress> getAddresses() {
        return this.addrs;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getSendBufferSize() {
        return this.sndBufSize;
    }

    public int getReceiveBufferSize() {
        return this.rcvBufSize;
    }

    public String getSslClientCertificateKeyStorePath() {
        return this.sslClientCertKeyStorePath;
    }

    public String getSslClientCertificateKeyStoreType() {
        return this.sslClientCertKeyStoreType;
    }

    public String getSslClientCertificateKeyStorePassword() {
        return this.sslClientCertKeyStorePwd;
    }

    public String getSslTrustCertificateKeyStorePath() {
        return this.sslTrustCertKeyStorePath;
    }

    public String getSslTrustCertificateKeyStoreType() {
        return this.sslTrustCertKeyStoreType;
    }

    public String getSslTrustCertificateKeyStorePassword() {
        return this.sslTrustCertKeyStorePwd;
    }

    public String getSslKeyAlgorithm() {
        return this.sslKeyAlgorithm;
    }

    public SslProtocol getSslProtocol() {
        return this.sslProto;
    }

    public boolean isSslTrustAll() {
        return this.sslTrustAll;
    }

    public Factory<SSLContext> getSslContextFactory() {
        return this.sslCtxFactory;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPwd;
    }

    public long getReconnectThrottlingPeriod() {
        return this.reconnectThrottlingPeriod;
    }

    public int getReconnectThrottlingRetries() {
        return this.reconnectThrottlingRetries;
    }

    public Map<String, String> getUserAttributes() {
        return this.userAttrs;
    }

    public Executor getAsyncContinuationExecutor() {
        return this.asyncContinuationExecutor;
    }

    public boolean getHeartbeatEnabled() {
        return this.heartbeatEnabled;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public boolean isAutoBinaryConfigurationEnabled() {
        return this.autoBinaryConfigurationEnabled;
    }

    public IgniteLogger getLogger() {
        return this.logger;
    }

    public EventListenerDemultiplexer eventListener() {
        return this.eventListener;
    }
}

