/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.Positional;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheDistributionCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Positional
    @Argument(example="nodeId|null")
    private String nodeIdOrNull;
    @Positional
    @Argument(optional=true, example="cacheName1,...,cacheNameN")
    private String[] caches;
    private UUID nodeId;
    @Argument(optional=true, example="attrName1,...,attrNameN")
    private String[] userAttributes;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.nodeIdOrNull);
        U.writeArray(out, this.caches);
        U.writeUuid(out, this.nodeId);
        U.writeArray(out, this.userAttributes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeIdOrNull = U.readString(in);
        this.caches = U.readArray(in, String.class);
        this.nodeId = U.readUuid(in);
        this.userAttributes = U.readArray(in, String.class);
    }

    private void parse(String value) {
        if (!"null".equals(value)) {
            this.nodeId = CommandUtils.parseVal(value, UUID.class);
        }
    }

    public String nodeIdOrNull() {
        return this.nodeIdOrNull;
    }

    public void nodeIdOrNull(String nodeIdOrNull) {
        this.nodeIdOrNull = nodeIdOrNull;
        this.parse(nodeIdOrNull);
    }

    public String[] caches() {
        return this.caches;
    }

    public void caches(String[] caches) {
        this.caches = caches;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public String[] userAttributes() {
        return this.userAttributes;
    }

    public void userAttributes(String[] userAttributes) {
        this.userAttributes = userAttributes;
    }
}

