/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcThinFeature;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcUtils;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResultMarshaler;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQueryExecuteResult
extends JdbcResult {
    private long cursorId;
    private List<List<Object>> items;
    private boolean last;
    private boolean isQuery;
    private long updateCnt;
    private PartitionResult partRes;
    private int txId;

    JdbcQueryExecuteResult() {
        super((byte)2);
    }

    JdbcQueryExecuteResult(long cursorId, List<List<Object>> items, boolean last, PartitionResult partRes, int txId) {
        super((byte)2);
        this.cursorId = cursorId;
        this.items = items;
        this.last = last;
        this.isQuery = true;
        this.partRes = partRes;
        this.txId = txId;
    }

    public JdbcQueryExecuteResult(long cursorId, long updateCnt, PartitionResult partRes, int txId) {
        super((byte)2);
        this.cursorId = cursorId;
        this.last = true;
        this.isQuery = false;
        this.updateCnt = updateCnt;
        this.partRes = partRes;
        this.txId = txId;
    }

    public long cursorId() {
        return this.cursorId;
    }

    public List<List<Object>> items() {
        return this.items;
    }

    public boolean last() {
        return this.last;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public long updateCount() {
        return this.updateCnt;
    }

    public int txId() {
        return this.txId;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        writer.writeLong(this.cursorId);
        writer.writeBoolean(this.isQuery);
        if (this.isQuery) {
            assert (this.items != null);
            writer.writeBoolean(this.last);
            JdbcUtils.writeItems(writer, this.items, protoCtx);
        } else {
            writer.writeLong(this.updateCnt);
        }
        writer.writeBoolean(this.partRes != null);
        if (protoCtx.isAffinityAwarenessSupported() && this.partRes != null) {
            PartitionResultMarshaler.marshal(writer, this.partRes);
        }
        if (protoCtx.isFeatureSupported(JdbcThinFeature.TX_AWARE_QUERIES)) {
            writer.writeInt(this.txId);
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        this.cursorId = reader.readLong();
        this.isQuery = reader.readBoolean();
        if (this.isQuery) {
            this.last = reader.readBoolean();
            this.items = JdbcUtils.readItems(reader, protoCtx);
        } else {
            this.last = true;
            this.updateCnt = reader.readLong();
        }
        if (protoCtx.isAffinityAwarenessSupported() && reader.readBoolean()) {
            this.partRes = PartitionResultMarshaler.unmarshal(reader);
        }
        if (protoCtx.isFeatureSupported(JdbcThinFeature.TX_AWARE_QUERIES)) {
            this.txId = reader.readInt();
        }
    }

    public PartitionResult partitionResult() {
        return this.partRes;
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryExecuteResult.class, this, super.toString());
    }
}

