/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public final class GridMessageCollection<M extends Message>
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectCollection(value=Message.class)
    private Collection<M> msgs;

    public GridMessageCollection() {
    }

    public GridMessageCollection(Collection<M> msgs) {
        this.msgs = msgs;
    }

    public static <X extends Message> GridMessageCollection<X> of(X ... msgs) {
        if (msgs == null || msgs.length == 0) {
            return null;
        }
        List<X> list = msgs.length == 1 ? Collections.singletonList(msgs[0]) : Arrays.asList(msgs);
        return new GridMessageCollection<X>(list);
    }

    public Collection<M> messages() {
        return this.msgs;
    }

    public void messages(Collection<M> msgs) {
        this.msgs = msgs;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("msgs", this.msgs, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msgs = reader.readCollection("msgs", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridMessageCollection.class);
    }

    @Override
    public short directType() {
        return 124;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridMessageCollection that = (GridMessageCollection)o;
        return this.msgs == that.msgs || this.msgs != null && this.msgs.equals(that.msgs);
    }

    public int hashCode() {
        return this.msgs != null ? this.msgs.hashCode() : 0;
    }

    public String toString() {
        return S.toString(GridMessageCollection.class, this, "msgsSize", this.msgs == null ? null : Integer.valueOf(this.msgs.size()));
    }
}

