/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.query.aggregate;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.cluster.ClusterIoTDB;
import org.apache.iotdb.cluster.client.async.AsyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncClientAdaptor;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.config.ClusterConstant;
import org.apache.iotdb.cluster.config.ClusterDescriptor;
import org.apache.iotdb.cluster.exception.CheckConsistencyException;
import org.apache.iotdb.cluster.exception.EmptyIntervalException;
import org.apache.iotdb.cluster.exception.RequestTimeOutException;
import org.apache.iotdb.cluster.partition.PartitionGroup;
import org.apache.iotdb.cluster.query.LocalQueryExecutor;
import org.apache.iotdb.cluster.query.RemoteQueryContext;
import org.apache.iotdb.cluster.query.manage.QueryCoordinator;
import org.apache.iotdb.cluster.rpc.thrift.GetAggrResultRequest;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.DataGroupMember;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.utils.SerializeUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAggregator {
    private static final Logger logger = LoggerFactory.getLogger(ClusterAggregator.class);
    private MetaGroupMember metaGroupMember;

    public ClusterAggregator(MetaGroupMember metaGroupMember) {
        this.metaGroupMember = metaGroupMember;
    }

    public List<AggregateResult> getAggregateResult(PartialPath path, Set<String> deviceMeasurements, List<String> aggregations, TSDataType dataType, Filter timeFilter, QueryContext context, boolean ascending) throws StorageEngineException {
        List<PartitionGroup> partitionGroups;
        try {
            this.metaGroupMember.syncLeaderWithConsistencyCheck(false);
        }
        catch (CheckConsistencyException e) {
            throw new StorageEngineException((Throwable)e);
        }
        try {
            partitionGroups = this.metaGroupMember.routeFilter(timeFilter, path);
        }
        catch (EmptyIntervalException e) {
            logger.info(e.getMessage());
            partitionGroups = Collections.emptyList();
        }
        logger.debug("{}: Sending aggregation query of {} to {} groups", new Object[]{this.metaGroupMember.getName(), path, partitionGroups.size()});
        List<AggregateResult> results = null;
        for (PartitionGroup partitionGroup : partitionGroups) {
            List<AggregateResult> groupResult = this.getAggregateResult(path, deviceMeasurements, aggregations, dataType, timeFilter, partitionGroup, context, ascending);
            if (results == null) {
                results = groupResult;
                continue;
            }
            for (int i = 0; i < results.size(); ++i) {
                results.get(i).merge(groupResult.get(i));
            }
        }
        return results;
    }

    private List<AggregateResult> getAggregateResult(PartialPath path, Set<String> deviceMeasurements, List<String> aggregations, TSDataType dataType, Filter timeFilter, PartitionGroup partitionGroup, QueryContext context, boolean ascending) throws StorageEngineException {
        if (!partitionGroup.contains(this.metaGroupMember.getThisNode())) {
            return this.getRemoteAggregateResult((Path)path, deviceMeasurements, aggregations, dataType, timeFilter, partitionGroup, context, ascending);
        }
        DataGroupMember dataMember = this.metaGroupMember.getLocalDataMember(partitionGroup.getHeader(), partitionGroup.getRaftId());
        LocalQueryExecutor localQueryExecutor = new LocalQueryExecutor(dataMember);
        try {
            logger.debug("{}: querying aggregation {} of {} in {} locally", new Object[]{this.metaGroupMember.getName(), aggregations, path, partitionGroup.getHeader()});
            List<AggregateResult> aggrResult = localQueryExecutor.getAggrResult(aggregations, deviceMeasurements, dataType, path, timeFilter, context, ascending);
            logger.debug("{}: queried aggregation {} of {} in {} locally are {}", new Object[]{this.metaGroupMember.getName(), aggregations, path, partitionGroup.getHeader(), aggrResult});
            return aggrResult;
        }
        catch (IOException | QueryProcessException e) {
            throw new StorageEngineException(e);
        }
    }

    private List<AggregateResult> getRemoteAggregateResult(Path path, Set<String> deviceMeasurements, List<String> aggregations, TSDataType dataType, Filter timeFilter, PartitionGroup partitionGroup, QueryContext context, boolean ascending) throws StorageEngineException {
        GetAggrResultRequest request = new GetAggrResultRequest();
        request.setPath(path.getFullPath());
        request.setAggregations(aggregations);
        request.setDataTypeOrdinal(dataType.ordinal());
        request.setQueryId(context.getQueryId());
        request.setRequestor(this.metaGroupMember.getThisNode());
        request.setHeader(partitionGroup.getHeader());
        request.setDeviceMeasurements(deviceMeasurements);
        request.setAscending(ascending);
        if (timeFilter != null) {
            request.setTimeFilterBytes(SerializeUtils.serializeFilter((Filter)timeFilter));
        }
        List<Node> reorderedNodes = QueryCoordinator.getINSTANCE().reorderNodes(partitionGroup);
        for (Node node : reorderedNodes) {
            logger.debug("{}: querying aggregation {} of {} from {} of {}", new Object[]{this.metaGroupMember.getName(), aggregations, path, node, partitionGroup.getHeader()});
            try {
                List<ByteBuffer> resultBuffers = this.getRemoteAggregateResult(node, request);
                if (resultBuffers == null) continue;
                ArrayList<AggregateResult> results = new ArrayList<AggregateResult>(resultBuffers.size());
                for (ByteBuffer resultBuffer : resultBuffers) {
                    AggregateResult result = AggregateResult.deserializeFrom((ByteBuffer)resultBuffer);
                    results.add(result);
                }
                ((RemoteQueryContext)context).registerRemoteNode(node, partitionGroup.getHeader());
                logger.debug("{}: queried aggregation {} of {} from {} of {} are {}", new Object[]{this.metaGroupMember.getName(), aggregations, path, node, partitionGroup.getHeader(), results});
                return results;
            }
            catch (TApplicationException e) {
                logger.error(this.metaGroupMember.getName() + " query aggregation error " + path + " from " + node, (Throwable)e);
                throw new StorageEngineException(e.getMessage());
            }
            catch (IOException | TException e) {
                logger.error(this.metaGroupMember.getName() + " cannot query aggregation " + path + " from " + node, e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error(this.metaGroupMember.getName() + " query interrupted " + path + " from " + node, (Throwable)e);
            }
        }
        throw new StorageEngineException((Throwable)new RequestTimeOutException("Query aggregate: " + path + " in " + partitionGroup));
    }

    private List<ByteBuffer> getRemoteAggregateResult(Node node, GetAggrResultRequest request) throws IOException, TException, InterruptedException {
        List resultBuffers = null;
        if (ClusterDescriptor.getInstance().getConfig().isUseAsyncServer()) {
            AsyncDataClient client = ClusterIoTDB.getInstance().getAsyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
            resultBuffers = SyncClientAdaptor.getAggrResult(client, request);
        } else {
            SyncDataClient syncDataClient = null;
            try {
                syncDataClient = ClusterIoTDB.getInstance().getSyncDataClient(node, ClusterConstant.getReadOperationTimeoutMS());
                resultBuffers = syncDataClient.getAggrResult(request);
            }
            catch (TException e) {
                syncDataClient.close();
                throw e;
            }
            finally {
                if (syncDataClient != null) {
                    syncDataClient.returnSelf();
                }
            }
        }
        return resultBuffers;
    }
}

