/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.log.applier;

import org.apache.iotdb.cluster.exception.ChangeMembershipException;
import org.apache.iotdb.cluster.log.Log;
import org.apache.iotdb.cluster.log.applier.BaseApplier;
import org.apache.iotdb.cluster.log.logtypes.AddNodeLog;
import org.apache.iotdb.cluster.log.logtypes.EmptyContentLog;
import org.apache.iotdb.cluster.log.logtypes.PhysicalPlanLog;
import org.apache.iotdb.cluster.log.logtypes.RemoveNodeLog;
import org.apache.iotdb.cluster.server.NodeCharacter;
import org.apache.iotdb.cluster.server.member.MetaGroupMember;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaLogApplier
extends BaseApplier {
    private static final Logger logger = LoggerFactory.getLogger(MetaLogApplier.class);
    private MetaGroupMember member;

    public MetaLogApplier(MetaGroupMember member) {
        super(member);
        this.member = member;
    }

    @Override
    public void apply(Log log) {
        try {
            logger.debug("MetaMember [{}] starts applying Log {}", (Object)this.metaGroupMember.getName(), (Object)log);
            if (log instanceof AddNodeLog) {
                this.applyAddNodeLog((AddNodeLog)log);
            } else if (log instanceof PhysicalPlanLog) {
                this.applyPhysicalPlan(((PhysicalPlanLog)log).getPlan(), null);
            } else if (log instanceof RemoveNodeLog) {
                this.applyRemoveNodeLog((RemoveNodeLog)log);
            } else if (log instanceof EmptyContentLog) {
            } else {
                logger.error("Unsupported log: {} {}", (Object)log.getClass().getName(), (Object)log);
            }
        }
        catch (Exception e) {
            logger.debug("Exception occurred when executing {}", (Object)log, (Object)e);
            log.setException(e);
        }
        finally {
            log.setApplied(true);
        }
    }

    private void applyAddNodeLog(AddNodeLog log) throws ChangeMembershipException {
        if (!this.metaGroupMember.getPartitionTable().deserialize(log.getPartitionTable())) {
            logger.info("Ignore previous change membership log");
            return;
        }
        if (this.metaGroupMember.getCharacter() == NodeCharacter.LEADER) {
            this.metaGroupMember.getCoordinator().sendLogToAllDataGroups(log);
        }
        this.member.applyAddNode(log);
    }

    private void applyRemoveNodeLog(RemoveNodeLog log) throws ChangeMembershipException {
        if (!this.metaGroupMember.getPartitionTable().deserialize(log.getPartitionTable())) {
            return;
        }
        if (this.metaGroupMember.getCharacter() == NodeCharacter.LEADER) {
            this.metaGroupMember.getCoordinator().sendLogToAllDataGroups(log);
        }
        this.member.applyRemoveNode(log);
    }
}

