/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotCatchUpHandler
implements AsyncMethodCallback<Void> {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotCatchUpHandler.class);
    private AtomicBoolean succeed;
    private Node receiver;
    private Snapshot snapshot;

    public SnapshotCatchUpHandler(AtomicBoolean succeed, Node receiver, Snapshot snapshot) {
        this.succeed = succeed;
        this.receiver = receiver;
        this.snapshot = snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(Void resp) {
        AtomicBoolean atomicBoolean = this.succeed;
        synchronized (atomicBoolean) {
            this.succeed.set(true);
            this.succeed.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        logger.error("Cannot send snapshot {} to {}", new Object[]{this.snapshot, this.receiver, exception});
        AtomicBoolean atomicBoolean = this.succeed;
        synchronized (atomicBoolean) {
            this.succeed.notifyAll();
        }
    }
}

