/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion.realtime.assigner;

import com.lmax.disruptor.EventHandler;
import java.io.Closeable;
import java.util.Set;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.ProgressReportEvent;
import org.apache.iotdb.commons.pipe.metric.PipeEventCounter;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEventFactory;
import org.apache.iotdb.db.pipe.metric.source.PipeAssignerMetrics;
import org.apache.iotdb.db.pipe.metric.source.PipeDataRegionEventCounter;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.PipeRealtimeDataRegionSource;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.assigner.DisruptorQueue;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.matcher.CachedSchemaPatternMatcher;
import org.apache.iotdb.db.pipe.source.dataregion.realtime.matcher.PipeDataRegionMatcher;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataRegionAssigner
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataRegionAssigner.class);
    private final PipeDataRegionMatcher matcher;
    private final DisruptorQueue disruptor;
    private final String dataRegionId;
    private final PipeEventCounter eventCounter = new PipeDataRegionEventCounter();

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public PipeDataRegionAssigner(String dataRegionId) {
        this.matcher = new CachedSchemaPatternMatcher();
        this.disruptor = new DisruptorQueue((EventHandler<PipeRealtimeEvent>)((EventHandler)this::assignToExtractor), this::onAssignedHook);
        this.dataRegionId = dataRegionId;
        PipeAssignerMetrics.getInstance().register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishToAssign(PipeRealtimeEvent event) {
        if (!event.increaseReferenceCount(PipeDataRegionAssigner.class.getName())) {
            LOGGER.warn("The reference count of the realtime event {} cannot be increased, skipping it.", (Object)event);
            return;
        }
        EnrichedEvent innerEvent = event.getEvent();
        this.eventCounter.increaseEventCount((Event)innerEvent);
        if (innerEvent instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)innerEvent).onPublished();
        }
        PipeDataRegionAssigner pipeDataRegionAssigner = this;
        synchronized (pipeDataRegionAssigner) {
            if (!this.disruptor.isClosed()) {
                this.disruptor.publish(event);
            } else {
                this.onAssignedHook(event);
            }
        }
    }

    private void onAssignedHook(PipeRealtimeEvent realtimeEvent) {
        realtimeEvent.gcSchemaInfo();
        realtimeEvent.decreaseReferenceCount(PipeDataRegionAssigner.class.getName(), false);
        EnrichedEvent innerEvent = realtimeEvent.getEvent();
        if (innerEvent instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)innerEvent).onAssigned();
        }
        this.eventCounter.decreaseEventCount((Event)innerEvent);
    }

    private void assignToExtractor(PipeRealtimeEvent event, long sequence, boolean endOfBatch) {
        if (this.disruptor.isClosed()) {
            return;
        }
        Pair<Set<PipeRealtimeDataRegionSource>, Set<PipeRealtimeDataRegionSource>> matchedAndUnmatched = this.matcher.match(event);
        ((Set)matchedAndUnmatched.getLeft()).forEach(extractor -> {
            if (this.disruptor.isClosed()) {
                return;
            }
            if (event.getEvent().isGeneratedByPipe() && !extractor.isForwardingPipeRequests()) {
                ProgressReportEvent reportEvent = new ProgressReportEvent(extractor.getPipeName(), extractor.getCreationTime(), extractor.getPipeTaskMeta());
                reportEvent.bindProgressIndex(event.getProgressIndex());
                if (!reportEvent.increaseReferenceCount(PipeDataRegionAssigner.class.getName())) {
                    LOGGER.warn("The reference count of the event {} cannot be increased, skipping it.", (Object)reportEvent);
                    return;
                }
                extractor.extract(PipeRealtimeEventFactory.createRealtimeEvent(reportEvent));
                return;
            }
            PipeRealtimeEvent copiedEvent = event.shallowCopySelfAndBindPipeTaskMetaForProgressReport(extractor.getPipeName(), extractor.getCreationTime(), extractor.getPipeTaskMeta(), extractor.getPipePattern(), extractor.getRealtimeDataExtractionStartTime(), extractor.getRealtimeDataExtractionEndTime());
            EnrichedEvent innerEvent = copiedEvent.getEvent();
            if (innerEvent instanceof PipeTsFileInsertionEvent) {
                PipeTsFileInsertionEvent tsFileInsertionEvent = (PipeTsFileInsertionEvent)innerEvent;
                tsFileInsertionEvent.disableMod4NonTransferPipes(extractor.isShouldTransferModFile());
            }
            if (!copiedEvent.increaseReferenceCount(PipeDataRegionAssigner.class.getName())) {
                LOGGER.warn("The reference count of the event {} cannot be increased, skipping it.", (Object)copiedEvent);
                return;
            }
            extractor.extract(copiedEvent);
        });
        ((Set)matchedAndUnmatched.getRight()).forEach(extractor -> {
            if (this.disruptor.isClosed()) {
                return;
            }
            EnrichedEvent innerEvent = event.getEvent();
            if (innerEvent instanceof TabletInsertionEvent || innerEvent instanceof TsFileInsertionEvent) {
                ProgressReportEvent reportEvent = new ProgressReportEvent(extractor.getPipeName(), extractor.getCreationTime(), extractor.getPipeTaskMeta());
                reportEvent.bindProgressIndex(event.getProgressIndex());
                if (!reportEvent.increaseReferenceCount(PipeDataRegionAssigner.class.getName())) {
                    LOGGER.warn("The reference count of the event {} cannot be increased, skipping it.", (Object)reportEvent);
                    return;
                }
                extractor.extract(PipeRealtimeEventFactory.createRealtimeEvent(reportEvent));
            }
        });
    }

    public void startAssignTo(PipeRealtimeDataRegionSource extractor) {
        this.matcher.register(extractor);
    }

    public void stopAssignTo(PipeRealtimeDataRegionSource extractor) {
        this.matcher.deregister(extractor);
    }

    public boolean notMoreExtractorNeededToBeAssigned() {
        return this.matcher.getRegisterCount() == 0;
    }

    @Override
    public synchronized void close() {
        PipeAssignerMetrics.getInstance().deregister(this.dataRegionId);
        long startTime = System.currentTimeMillis();
        this.disruptor.shutdown();
        this.matcher.clear();
        LOGGER.info("Pipe: Assigner on data region {} shutdown internal disruptor within {} ms", (Object)this.dataRegionId, (Object)(System.currentTimeMillis() - startTime));
    }

    public int getTabletInsertionEventCount() {
        return this.eventCounter.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.eventCounter.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.eventCounter.getPipeHeartbeatEventCount();
    }
}

