/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.progress.interval;

import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.task.progress.interval.PipeCommitInterval;
import org.apache.iotdb.commons.pipe.datastructure.interval.IntervalManager;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;

public class PipeCommitQueue {
    private final IntervalManager<PipeCommitInterval> intervalManager = new IntervalManager();
    private long lastCommitted = 0L;

    public void offer(EnrichedEvent event) {
        PipeCommitInterval interval = new PipeCommitInterval(event.getCommitId(), event.getCommitId(), event.isShouldReportOnCommit() ? event.getProgressIndex() : MinimumProgressIndex.INSTANCE, event.getOnCommittedHooks(), event.getPipeTaskMeta());
        this.intervalManager.addInterval(interval);
        if (interval.start == this.lastCommitted + 1L) {
            this.intervalManager.remove(interval);
            this.lastCommitted = interval.end;
        }
    }

    public int size() {
        return this.intervalManager.size();
    }

    public String toString() {
        return "PipeCommitQueue{lastCommitted='" + this.lastCommitted + "', IntervalManager=" + this.intervalManager + "}";
    }
}

