/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.Model;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchemaUtil;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.ainode.RemoveAINodePlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.confignode.RemoveConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RemoveDataNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.procedure.UpdateProcedurePlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.procedure.PartitionTableAutoCleaner;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.ProcedureExecutor;
import org.apache.iotdb.confignode.procedure.ProcedureMetrics;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.env.RegionMaintainHandler;
import org.apache.iotdb.confignode.procedure.env.RemoveDataNodeHandler;
import org.apache.iotdb.confignode.procedure.impl.cq.CreateCQProcedure;
import org.apache.iotdb.confignode.procedure.impl.model.CreateModelProcedure;
import org.apache.iotdb.confignode.procedure.impl.model.DropModelProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AddConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveAINodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveDataNodesProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.plugin.CreatePipePluginProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.plugin.DropPipePluginProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.runtime.PipeHandleLeaderChangeProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.runtime.PipeHandleMetaChangeProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.runtime.PipeMetaSyncProcedure;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.AlterPipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.CreatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.DropPipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.StartPipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.StopPipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.region.AddRegionPeerProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.CreateRegionGroupsProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.ReconstructRegionProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RegionMigrateProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RegionMigrationPlan;
import org.apache.iotdb.confignode.procedure.impl.region.RegionOperationProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RemoveRegionPeerProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.AlterLogicalViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeactivateTemplateProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteDatabaseProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteLogicalViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteTimeSeriesProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.SetTTLProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.SetTemplateProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.UnsetTemplateProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AbstractAlterOrDropTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.AddTableColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.CreateTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.DeleteDevicesProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.DropTableColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.DropTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.RenameTableColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.RenameTableProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.SetTablePropertiesProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.AddViewColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.CreateTableViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.DropViewColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.DropViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.RenameViewColumnProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.RenameViewProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.table.view.SetViewPropertiesProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.CreateConsumerProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.DropConsumerProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.runtime.ConsumerGroupMetaSyncProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.subscription.CreateSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.subscription.DropSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.topic.CreateTopicProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.topic.DropTopicProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.topic.runtime.TopicMetaSyncProcedure;
import org.apache.iotdb.confignode.procedure.impl.sync.AuthOperationProcedure;
import org.apache.iotdb.confignode.procedure.impl.testonly.AddNeverFinishSubProcedureProcedure;
import org.apache.iotdb.confignode.procedure.impl.testonly.CreateManyDatabasesProcedure;
import org.apache.iotdb.confignode.procedure.impl.trigger.CreateTriggerProcedure;
import org.apache.iotdb.confignode.procedure.impl.trigger.DropTriggerProcedure;
import org.apache.iotdb.confignode.procedure.scheduler.ProcedureScheduler;
import org.apache.iotdb.confignode.procedure.scheduler.SimpleProcedureScheduler;
import org.apache.iotdb.confignode.procedure.store.ConfigProcedureStore;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TAlterLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterOrDropTableReq;
import org.apache.iotdb.confignode.rpc.thrift.TAlterPipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCloseConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateTopicReq;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteLogicalViewReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTableDeviceReq;
import org.apache.iotdb.confignode.rpc.thrift.TDeleteTableDeviceResp;
import org.apache.iotdb.confignode.rpc.thrift.TDropPipePluginReq;
import org.apache.iotdb.confignode.rpc.thrift.TExtendRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TMigrateRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TReconstructRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TRemoveRegionReq;
import org.apache.iotdb.confignode.rpc.thrift.TSubscribeReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.iotdb.db.exception.BatchProcessException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.ratis.util.AutoCloseableLock;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcedureManager.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONFIG = ConfigNodeDescriptor.getInstance().getConf();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    public static final long PROCEDURE_WAIT_TIME_OUT = COMMON_CONFIG.getDnConnectionTimeoutInMS();
    public static final int PROCEDURE_WAIT_RETRY_TIMEOUT = 10;
    private static final String PROCEDURE_TIMEOUT_MESSAGE = "Timed out to wait for procedure return. The procedure is still running.";
    private final ConfigManager configManager;
    private ProcedureExecutor<ConfigNodeProcedureEnv> executor;
    private ProcedureScheduler scheduler;
    private IProcedureStore store;
    private ConfigNodeProcedureEnv env;
    private final long planSizeLimit;
    private ProcedureMetrics procedureMetrics;
    private final PartitionTableAutoCleaner partitionTableCleaner;
    private final ReentrantLock tableLock = new ReentrantLock();

    public ProcedureManager(ConfigManager configManager, ProcedureInfo procedureInfo) {
        this.configManager = configManager;
        this.scheduler = new SimpleProcedureScheduler();
        this.store = new ConfigProcedureStore(configManager, procedureInfo);
        this.env = new ConfigNodeProcedureEnv(configManager, this.scheduler);
        this.executor = new ProcedureExecutor<ConfigNodeProcedureEnv>(this.env, this.store, this.scheduler);
        this.planSizeLimit = ConfigNodeDescriptor.getInstance().getConf().getConfigNodeRatisConsensusLogAppenderBufferSize() - 48L;
        this.procedureMetrics = new ProcedureMetrics(this);
        this.partitionTableCleaner = new PartitionTableAutoCleaner(configManager);
    }

    public void startExecutor() {
        if (!this.executor.isRunning()) {
            this.executor.init(CONFIG_NODE_CONFIG.getProcedureCoreWorkerThreadsCount());
            this.executor.startWorkers();
            this.executor.startCompletedCleaner(CONFIG_NODE_CONFIG.getProcedureCompletedCleanInterval(), CONFIG_NODE_CONFIG.getProcedureCompletedEvictTTL());
            this.executor.addInternalProcedure(this.partitionTableCleaner);
            this.store.start();
            LOGGER.info("ProcedureManager is started successfully.");
        }
    }

    public void stopExecutor() {
        if (this.executor.isRunning()) {
            this.executor.stop();
            if (!this.executor.isRunning()) {
                this.executor.join();
                this.store.stop();
                LOGGER.info("ProcedureManager is stopped successfully.");
            }
            this.executor.removeInternalProcedure(this.partitionTableCleaner);
        }
    }

    @TestOnly
    public TSStatus createManyDatabases() {
        this.executor.submitProcedure(new CreateManyDatabasesProcedure());
        return StatusUtils.OK;
    }

    @TestOnly
    public TSStatus testSubProcedure() {
        this.executor.submitProcedure(new AddNeverFinishSubProcedureProcedure());
        return StatusUtils.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TSStatus deleteDatabases(List<TDatabaseSchema> deleteSgSchemaList, boolean isGeneratedByPipe) {
        ArrayList<DeleteDatabaseProcedure> procedures = new ArrayList<DeleteDatabaseProcedure>();
        long startCheckTimeForProcedures = System.currentTimeMillis();
        Iterator<TDatabaseSchema> iterator = deleteSgSchemaList.iterator();
        while (true) {
            boolean hasOverlappedTask;
            String database;
            TDatabaseSchema databaseSchema;
            if (iterator.hasNext()) {
                databaseSchema = iterator.next();
                database = databaseSchema.getName();
                hasOverlappedTask = false;
                ProcedureManager procedureManager = this;
                synchronized (procedureManager) {
                }
            } else {
                ArrayList results = new ArrayList(procedures.size());
                procedures.forEach(procedure -> results.add(this.waitingProcedureFinished((Procedure<?>)procedure)));
                PartitionManager partitionManager = this.getConfigManager().getPartitionManager();
                partitionManager.getRegionMaintainer().submit(partitionManager::maintainRegionReplicas);
                if (results.stream().allMatch(result -> result.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode())) {
                    return StatusUtils.OK;
                }
                return RpcUtils.getStatus(results);
            }
            {
                while (this.executor.isRunning() && System.currentTimeMillis() - startCheckTimeForProcedures < PROCEDURE_WAIT_TIME_OUT) {
                    Pair<Long, Boolean> procedureIdDuplicatePair = this.checkDuplicateTableTask(database, null, null, null, null, ProcedureType.DELETE_DATABASE_PROCEDURE);
                    hasOverlappedTask = (Boolean)procedureIdDuplicatePair.getRight();
                    if (Boolean.FALSE.equals(procedureIdDuplicatePair.getRight())) {
                        DeleteDatabaseProcedure procedure2 = new DeleteDatabaseProcedure(databaseSchema, isGeneratedByPipe);
                        this.executor.submitProcedure(procedure2);
                        procedures.add(procedure2);
                        break;
                    }
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)String.format("Some other task is operating table under the database %s, please retry after the procedure finishes.", database));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteTimeSeries(String queryId, PathPatternTree patternTree, boolean isGeneratedByPipe) {
        DeleteTimeSeriesProcedure procedure = null;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            boolean hasOverlappedTask = false;
            for (Procedure<ConfigNodeProcedureEnv> runningProcedure : this.executor.getProcedures().values()) {
                ProcedureType type = ProcedureFactory.getProcedureType(runningProcedure);
                if (type == null || !type.equals((Object)ProcedureType.DELETE_TIMESERIES_PROCEDURE)) continue;
                DeleteTimeSeriesProcedure deleteTimeSeriesProcedure = (DeleteTimeSeriesProcedure)runningProcedure;
                if (queryId.equals(deleteTimeSeriesProcedure.getQueryId())) {
                    procedure = deleteTimeSeriesProcedure;
                    break;
                }
                if (!patternTree.isOverlapWith(deleteTimeSeriesProcedure.getPatternTree())) continue;
                hasOverlappedTask = true;
                break;
            }
            if (procedure == null) {
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)"Some other task is deleting some target timeseries.");
                }
                procedure = new DeleteTimeSeriesProcedure(queryId, patternTree, isGeneratedByPipe);
                this.executor.submitProcedure(procedure);
            }
        }
        return this.waitingProcedureFinished(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteLogicalView(TDeleteLogicalViewReq req) {
        String queryId = req.getQueryId();
        PathPatternTree patternTree = PathPatternTree.deserialize((ByteBuffer)ByteBuffer.wrap(req.getPathPatternTree()));
        DeleteLogicalViewProcedure procedure = null;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            boolean hasOverlappedTask = false;
            for (Procedure<ConfigNodeProcedureEnv> runningProcedure : this.executor.getProcedures().values()) {
                ProcedureType type = ProcedureFactory.getProcedureType(runningProcedure);
                if (type == null || !type.equals((Object)ProcedureType.DELETE_LOGICAL_VIEW_PROCEDURE)) continue;
                DeleteLogicalViewProcedure deleteLogicalViewProcedure = (DeleteLogicalViewProcedure)runningProcedure;
                if (queryId.equals(deleteLogicalViewProcedure.getQueryId())) {
                    procedure = deleteLogicalViewProcedure;
                    break;
                }
                if (!patternTree.isOverlapWith(deleteLogicalViewProcedure.getPatternTree())) continue;
                hasOverlappedTask = true;
                break;
            }
            if (procedure == null) {
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)"Some other task is deleting some target views.");
                }
                procedure = new DeleteLogicalViewProcedure(queryId, patternTree, req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe());
                this.executor.submitProcedure(procedure);
            }
        }
        return this.waitingProcedureFinished(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus alterLogicalView(TAlterLogicalViewReq req) {
        String queryId = req.getQueryId();
        ByteBuffer byteBuffer = ByteBuffer.wrap(req.getViewBinary());
        HashMap<PartialPath, ViewExpression> viewPathToSourceMap = new HashMap<PartialPath, ViewExpression>();
        int size = byteBuffer.getInt();
        for (int i = 0; i < size; ++i) {
            PartialPath path = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)byteBuffer);
            ViewExpression viewExpression = ViewExpression.deserialize((ByteBuffer)byteBuffer);
            viewPathToSourceMap.put(path, viewExpression);
        }
        AlterLogicalViewProcedure procedure = null;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            for (Procedure<ConfigNodeProcedureEnv> runningProcedure : this.executor.getProcedures().values()) {
                AlterLogicalViewProcedure alterLogicalViewProcedure;
                ProcedureType type = ProcedureFactory.getProcedureType(runningProcedure);
                if (type == null || !type.equals((Object)ProcedureType.ALTER_LOGICAL_VIEW_PROCEDURE) || !queryId.equals((alterLogicalViewProcedure = (AlterLogicalViewProcedure)runningProcedure).getQueryId())) continue;
                procedure = alterLogicalViewProcedure;
                break;
            }
            if (procedure == null) {
                procedure = new AlterLogicalViewProcedure(queryId, viewPathToSourceMap, req.isSetIsGeneratedByPipe() && req.isIsGeneratedByPipe());
                this.executor.submitProcedure(procedure);
            }
        }
        return this.waitingProcedureFinished(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setSchemaTemplate(String queryId, String templateName, String templateSetPath, boolean isGeneratedByPipe) {
        SetTemplateProcedure procedure = null;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            boolean hasOverlappedTask = false;
            for (Procedure<ConfigNodeProcedureEnv> runningProcedure : this.executor.getProcedures().values()) {
                ProcedureType type = ProcedureFactory.getProcedureType(runningProcedure);
                if (type == null || !type.equals((Object)ProcedureType.SET_TEMPLATE_PROCEDURE)) continue;
                SetTemplateProcedure setTemplateProcedure = (SetTemplateProcedure)runningProcedure;
                if (queryId.equals(setTemplateProcedure.getQueryId())) {
                    procedure = setTemplateProcedure;
                    break;
                }
                if (!templateSetPath.equals(setTemplateProcedure.getTemplateSetPath())) continue;
                hasOverlappedTask = true;
                break;
            }
            if (procedure == null) {
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)"Some other task is setting template on target path.");
                }
                procedure = new SetTemplateProcedure(queryId, templateName, templateSetPath, isGeneratedByPipe);
                this.executor.submitProcedure(procedure);
            }
        }
        return this.waitingProcedureFinished(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deactivateTemplate(String queryId, Map<PartialPath, List<Template>> templateSetInfo, boolean isGeneratedByPipe) {
        DeactivateTemplateProcedure procedure = null;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            boolean hasOverlappedTask = false;
            for (Procedure<ConfigNodeProcedureEnv> runningProcedure : this.executor.getProcedures().values()) {
                ProcedureType type = ProcedureFactory.getProcedureType(runningProcedure);
                if (type == null || !type.equals((Object)ProcedureType.DEACTIVATE_TEMPLATE_PROCEDURE)) continue;
                DeactivateTemplateProcedure deactivateTemplateProcedure = (DeactivateTemplateProcedure)runningProcedure;
                if (queryId.equals(deactivateTemplateProcedure.getQueryId())) {
                    procedure = deactivateTemplateProcedure;
                    break;
                }
                for (PartialPath pattern : templateSetInfo.keySet()) {
                    for (PartialPath existingPattern : deactivateTemplateProcedure.getTemplateSetInfo().keySet()) {
                        if (!pattern.overlapWith(existingPattern)) continue;
                        hasOverlappedTask = true;
                        break;
                    }
                    if (!hasOverlappedTask) continue;
                    break;
                }
                if (!hasOverlappedTask) continue;
                break;
            }
            if (procedure == null) {
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)"Some other task is deactivating some target template from target path.");
                }
                procedure = new DeactivateTemplateProcedure(queryId, templateSetInfo, isGeneratedByPipe);
                this.executor.submitProcedure(procedure);
            }
        }
        return this.waitingProcedureFinished(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus unsetSchemaTemplate(String queryId, Template template, PartialPath path, boolean isGeneratedByPipe) {
        UnsetTemplateProcedure procedure = null;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            boolean hasOverlappedTask = false;
            for (Procedure<ConfigNodeProcedureEnv> runningProcedure : this.executor.getProcedures().values()) {
                ProcedureType type = ProcedureFactory.getProcedureType(runningProcedure);
                if (type == null || !type.equals((Object)ProcedureType.UNSET_TEMPLATE_PROCEDURE)) continue;
                UnsetTemplateProcedure unsetTemplateProcedure = (UnsetTemplateProcedure)runningProcedure;
                if (queryId.equals(unsetTemplateProcedure.getQueryId())) {
                    procedure = unsetTemplateProcedure;
                    break;
                }
                if (template.getId() != unsetTemplateProcedure.getTemplateId() || !path.equals((Object)unsetTemplateProcedure.getPath())) continue;
                hasOverlappedTask = true;
                break;
            }
            if (procedure == null) {
                if (hasOverlappedTask) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)("Some other task is unsetting target template from target path " + path.getFullPath()));
                }
                procedure = new UnsetTemplateProcedure(queryId, template, path, isGeneratedByPipe);
                this.executor.submitProcedure(procedure);
            }
        }
        return this.waitingProcedureFinished(procedure);
    }

    public void addConfigNode(TConfigNodeRegisterReq req) {
        AddConfigNodeProcedure addConfigNodeProcedure = new AddConfigNodeProcedure(req.getConfigNodeLocation(), req.getVersionInfo());
        this.executor.submitProcedure(addConfigNodeProcedure);
    }

    public void removeConfigNode(RemoveConfigNodePlan removeConfigNodePlan) {
        RemoveConfigNodeProcedure removeConfigNodeProcedure = new RemoveConfigNodeProcedure(removeConfigNodePlan.getConfigNodeLocation());
        this.executor.submitProcedure(removeConfigNodeProcedure);
        LOGGER.info("Submit RemoveConfigNodeProcedure successfully: {}", (Object)removeConfigNodePlan);
    }

    public boolean removeDataNode(RemoveDataNodePlan removeDataNodePlan) {
        HashMap<Integer, NodeStatus> nodeStatusMap = new HashMap<Integer, NodeStatus>();
        removeDataNodePlan.getDataNodeLocations().forEach(datanode -> nodeStatusMap.put(datanode.getDataNodeId(), this.configManager.getLoadManager().getNodeStatus(datanode.getDataNodeId())));
        this.executor.submitProcedure(new RemoveDataNodesProcedure(removeDataNodePlan.getDataNodeLocations(), nodeStatusMap));
        LOGGER.info("Submit RemoveDataNodesProcedure successfully, {}", removeDataNodePlan.getDataNodeLocations());
        return true;
    }

    public boolean removeAINode(RemoveAINodePlan removeAINodePlan) {
        this.executor.submitProcedure(new RemoveAINodeProcedure(removeAINodePlan.getAINodeLocation()));
        LOGGER.info("Submit RemoveAINodeProcedure successfully, {}", (Object)removeAINodePlan.getAINodeLocation());
        return true;
    }

    public TSStatus checkRemoveDataNodes(List<TDataNodeLocation> dataNodeLocations) {
        Optional<Procedure> anotherRemoveProcedure = this.getExecutor().getProcedures().values().stream().filter(procedure -> {
            if (procedure instanceof RemoveDataNodesProcedure) {
                return !procedure.isFinished();
            }
            return false;
        }).findAny();
        String failMessage = null;
        if (anotherRemoveProcedure.isPresent()) {
            List<TDataNodeLocation> anotherRemoveDataNodes = ((RemoveDataNodesProcedure)anotherRemoveProcedure.get()).getRemovedDataNodes();
            failMessage = String.format("Submit RemoveDataNodesProcedure failed, because another RemoveDataNodesProcedure %s is already in processing. IoTDB is able to have at most 1 RemoveDataNodesProcedure at the same time. For further information, please search [pid%d] in log. ", anotherRemoveDataNodes, anotherRemoveProcedure.get().getProcId());
        }
        Set<TConsensusGroupId> removedDataNodesRegionSet = this.getEnv().getRemoveDataNodeHandler().getRemovedDataNodesRegionSet(dataNodeLocations);
        Optional<Procedure> conflictRegionMigrateProcedure = this.getExecutor().getProcedures().values().stream().filter(procedure -> {
            if (procedure instanceof RegionMigrateProcedure) {
                RegionMigrateProcedure regionMigrateProcedure = (RegionMigrateProcedure)procedure;
                if (regionMigrateProcedure.isFinished()) {
                    return false;
                }
                return removedDataNodesRegionSet.contains(regionMigrateProcedure.getRegionId()) || dataNodeLocations.contains(regionMigrateProcedure.getDestDataNode());
            }
            return false;
        }).findAny();
        if (conflictRegionMigrateProcedure.isPresent()) {
            failMessage = String.format("Submit RemoveDataNodesProcedure failed, because another RegionMigrateProcedure %s is already in processing which conflicts with this RemoveDataNodesProcedure. The RegionMigrateProcedure is migrating the region %s to the DataNode %s. For further information, please search [pid%d] in log. ", conflictRegionMigrateProcedure.get().getProcId(), ((RegionMigrateProcedure)conflictRegionMigrateProcedure.get()).getRegionId(), ((RegionMigrateProcedure)conflictRegionMigrateProcedure.get()).getDestDataNode(), conflictRegionMigrateProcedure.get().getProcId());
        }
        List<RegionMigrationPlan> regionMigrationPlans = this.getEnv().getRemoveDataNodeHandler().getRegionMigrationPlans(dataNodeLocations);
        removedDataNodesRegionSet.clear();
        for (RegionMigrationPlan regionMigrationPlan : regionMigrationPlans) {
            if (removedDataNodesRegionSet.contains(regionMigrationPlan.getRegionId())) {
                failMessage = String.format("Submit RemoveDataNodesProcedure failed, because the RegionMigrateProcedure generated by this RemoveDataNodesProcedure conflicts with each other. Only one replica of the same consensus group is allowed to be migrated at the same time.The conflict region id is %s . ", regionMigrationPlan.getRegionId());
                break;
            }
            removedDataNodesRegionSet.add(regionMigrationPlan.getRegionId());
        }
        for (TDataNodeLocation removeDataNode : dataNodeLocations) {
            Set<TDataNodeLocation> relatedDataNodes = this.getEnv().getRemoveDataNodeHandler().getRelatedDataNodeLocations(removeDataNode);
            relatedDataNodes.remove(removeDataNode);
            for (TDataNodeLocation relatedDataNode : relatedDataNodes) {
                NodeStatus nodeStatus = this.getConfigManager().getLoadManager().getNodeStatus(relatedDataNode.getDataNodeId());
                if (nodeStatus != NodeStatus.Unknown && nodeStatus != NodeStatus.ReadOnly) continue;
                failMessage = String.format("Submit RemoveDataNodesProcedure failed, because when there are other unknown or readonly nodes in the consensus group that are not remove nodes, the remove operation cannot be performed for security reasons. Please check the status of the node %s and ensure it is running.", relatedDataNode.getDataNodeId());
            }
        }
        if (failMessage != null) {
            LOGGER.warn(failMessage);
            TSStatus failStatus = new TSStatus(TSStatusCode.REMOVE_DATANODE_ERROR.getStatusCode());
            failStatus.setMessage(failMessage);
            return failStatus;
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private TSStatus checkMigrateRegion(TMigrateRegionReq migrateRegionReq, TConsensusGroupId regionGroupId, TDataNodeLocation originalDataNode, TDataNodeLocation destDataNode, TDataNodeLocation coordinatorForAddPeer) {
        String failMessage = this.regionOperationCommonCheck(regionGroupId, destDataNode, Arrays.asList(new Pair((Object)"Original DataNode", (Object)originalDataNode), new Pair((Object)"Destination DataNode", (Object)destDataNode), new Pair((Object)"Coordinator for add peer", (Object)coordinatorForAddPeer)), migrateRegionReq.getModel());
        if (failMessage == null) {
            if (this.configManager.getPartitionManager().getAllReplicaSets(originalDataNode.getDataNodeId()).stream().noneMatch(replicaSet -> replicaSet.getRegionId().equals(regionGroupId))) {
                failMessage = String.format("Submit RegionMigrateProcedure failed, because the original DataNode %s doesn't contain Region %s", migrateRegionReq.getFromId(), migrateRegionReq.getRegionId());
            } else if (this.configManager.getPartitionManager().getAllReplicaSets(destDataNode.getDataNodeId()).stream().anyMatch(replicaSet -> replicaSet.getRegionId().equals(regionGroupId))) {
                failMessage = String.format("Submit RegionMigrateProcedure failed, because the target DataNode %s already contains Region %s", migrateRegionReq.getToId(), migrateRegionReq.getRegionId());
            }
        }
        if (failMessage != null) {
            LOGGER.warn(failMessage);
            TSStatus failStatus = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
            failStatus.setMessage(failMessage);
            return failStatus;
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private TSStatus checkReconstructRegion(TReconstructRegionReq req, TConsensusGroupId regionId, TDataNodeLocation targetDataNode, TDataNodeLocation coordinator) {
        String failMessage = this.regionOperationCommonCheck(regionId, targetDataNode, Arrays.asList(new Pair((Object)"Target DataNode", (Object)targetDataNode), new Pair((Object)"Coordinator", (Object)coordinator)), req.getModel());
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        if (this.configManager.getPartitionManager().getAllReplicaSetsMap(regionId.getType()).get(regionId).getDataNodeLocationsSize() == 1) {
            failMessage = String.format("%s only has 1 replica, it cannot be reconstructed", regionId);
        } else if (this.configManager.getPartitionManager().getAllReplicaSets(targetDataNode.getDataNodeId()).stream().noneMatch(replicaSet -> replicaSet.getRegionId().equals(regionId))) {
            failMessage = String.format("Submit ReconstructRegionProcedure failed, because the target DataNode %s doesn't contain Region %s", req.getDataNodeId(), regionId);
        }
        if (failMessage != null) {
            LOGGER.warn(failMessage);
            TSStatus failStatus = new TSStatus(TSStatusCode.RECONSTRUCT_REGION_ERROR.getStatusCode());
            failStatus.setMessage(failMessage);
            return failStatus;
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private TSStatus checkExtendRegion(TExtendRegionReq req, TConsensusGroupId regionId, TDataNodeLocation targetDataNode, TDataNodeLocation coordinator) {
        String failMessage = this.regionOperationCommonCheck(regionId, targetDataNode, Arrays.asList(new Pair((Object)"Target DataNode", (Object)targetDataNode), new Pair((Object)"Coordinator", (Object)coordinator)), req.getModel());
        if (this.configManager.getPartitionManager().getAllReplicaSets(targetDataNode.getDataNodeId()).stream().anyMatch(replicaSet -> replicaSet.getRegionId().equals(regionId))) {
            failMessage = String.format("Target DataNode %s already contains region %s", targetDataNode.getDataNodeId(), req.getRegionId());
        }
        if (failMessage != null) {
            LOGGER.warn(failMessage);
            TSStatus failStatus = new TSStatus(TSStatusCode.RECONSTRUCT_REGION_ERROR.getStatusCode());
            failStatus.setMessage(failMessage);
            return failStatus;
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private TSStatus checkRemoveRegion(TRemoveRegionReq req, TConsensusGroupId regionId, @Nullable TDataNodeLocation targetDataNode, TDataNodeLocation coordinator) {
        String failMessage = this.regionOperationCommonCheck(regionId, targetDataNode, Arrays.asList(new Pair((Object)"Coordinator", (Object)coordinator)), req.getModel());
        if (this.configManager.getPartitionManager().getAllReplicaSetsMap(regionId.getType()).get(regionId).getDataNodeLocationsSize() == 1) {
            failMessage = String.format("%s only has 1 replica, it cannot be removed", regionId);
        } else if (targetDataNode != null && this.configManager.getPartitionManager().getAllReplicaSets(targetDataNode.getDataNodeId()).stream().noneMatch(replicaSet -> replicaSet.getRegionId().equals(regionId))) {
            failMessage = String.format("Target DataNode %s doesn't contain Region %s", req.getDataNodeId(), regionId);
        }
        if (failMessage != null) {
            LOGGER.warn(failMessage);
            TSStatus failStatus = new TSStatus(TSStatusCode.REMOVE_REGION_PEER_ERROR.getStatusCode());
            failStatus.setMessage(failMessage);
            return failStatus;
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private String regionOperationCommonCheck(TConsensusGroupId regionId, TDataNodeLocation targetDataNode, List<Pair<String, TDataNodeLocation>> relatedDataNodes, Model model) {
        String failMessage;
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        if (TConsensusGroupType.DataRegion == regionId.getType() && "org.apache.iotdb.consensus.simple.SimpleConsensus".equals(conf.getDataRegionConsensusProtocolClass())) {
            failMessage = "SimpleConsensus not supports region operation.";
        } else if (TConsensusGroupType.SchemaRegion == regionId.getType() && "org.apache.iotdb.consensus.simple.SimpleConsensus".equals(conf.getSchemaRegionConsensusProtocolClass())) {
            failMessage = "SimpleConsensus not supports region operation.";
        } else {
            failMessage = this.checkRegionOperationDuplication(regionId);
            if (failMessage == null) {
                if (relatedDataNodes.stream().anyMatch(pair -> pair.getRight() == null)) {
                    Pair nullPair = relatedDataNodes.stream().filter(pair -> pair.getRight() == null).findAny().get();
                    failMessage = String.format("Cannot find %s", nullPair.getLeft());
                } else if (targetDataNode != null && !this.configManager.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running).stream().map(TDataNodeConfiguration::getLocation).map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()).contains(targetDataNode.getDataNodeId())) {
                    failMessage = String.format("Target DataNode %s is not in Running status.", targetDataNode.getDataNodeId());
                } else {
                    failMessage = this.checkRegionOperationWithRemoveDataNode(regionId, targetDataNode);
                    if (failMessage != null || (failMessage = this.checkRegionOperationModelCorrectness(regionId, model)) != null) {
                        // empty if block
                    }
                }
            }
        }
        return failMessage;
    }

    private String checkRegionOperationWithRemoveDataNode(TConsensusGroupId regionId, TDataNodeLocation targetDataNode) {
        Optional<Procedure> conflictRemoveDataNodesProcedure = this.getExecutor().getProcedures().values().stream().filter(procedure -> {
            if (procedure instanceof RemoveDataNodesProcedure) {
                return !procedure.isFinished();
            }
            return false;
        }).findAny();
        if (conflictRemoveDataNodesProcedure.isPresent()) {
            List<TDataNodeLocation> removedDataNodes;
            RemoveDataNodeHandler removeDataNodeHandler = this.env.getRemoveDataNodeHandler();
            Set<TConsensusGroupId> removedDataNodesRegionSet = removeDataNodeHandler.getRemovedDataNodesRegionSet(removedDataNodes = ((RemoveDataNodesProcedure)conflictRemoveDataNodesProcedure.get()).getRemovedDataNodes());
            if (removedDataNodesRegionSet.contains(regionId)) {
                return String.format("Another RemoveDataNodesProcedure %s is already in processing which conflicts with this procedure. The RemoveDataNodesProcedure is removing the DataNodes %s which contains the region %s. For further information, please search [pid%d] in log. ", conflictRemoveDataNodesProcedure.get().getProcId(), removedDataNodes, regionId, conflictRemoveDataNodesProcedure.get().getProcId());
            }
            if (removedDataNodes.contains(targetDataNode)) {
                return String.format("Another RemoveDataNodesProcedure %s is already in processing which conflicts with this procedure. The RemoveDataNodesProcedure is removing the target DataNode %s. For further information, please search [pid%d] in log. ", conflictRemoveDataNodesProcedure.get().getProcId(), targetDataNode, conflictRemoveDataNodesProcedure.get().getProcId());
            }
        }
        return null;
    }

    private String checkRegionOperationDuplication(TConsensusGroupId regionId) {
        List otherRegionMemberChangeProcedures = this.getRegionOperationProcedures().filter(regionMemberChangeProcedure -> regionId.equals(regionMemberChangeProcedure.getRegionId())).collect(Collectors.toList());
        if (!otherRegionMemberChangeProcedures.isEmpty()) {
            return String.format("%s has some other region operation procedures in progress, their procedure id is: %s", regionId, otherRegionMemberChangeProcedures);
        }
        return null;
    }

    public List<TConsensusGroupId> getRegionOperationConsensusIds() {
        return this.getRegionOperationProcedures().map(RegionOperationProcedure::getRegionId).distinct().collect(Collectors.toList());
    }

    private Stream<RegionOperationProcedure<?>> getRegionOperationProcedures() {
        return this.getExecutor().getProcedures().values().stream().filter(procedure -> !procedure.isFinished()).filter(procedure -> procedure instanceof RegionOperationProcedure).map(procedure -> (RegionOperationProcedure)procedure);
    }

    private String checkRegionOperationModelCorrectness(TConsensusGroupId regionId, Model model) {
        String databaseName = this.configManager.getPartitionManager().getRegionDatabase(regionId);
        boolean isTreeModelDatabase = databaseName.startsWith("root.");
        if (Model.TREE == model && isTreeModelDatabase || Model.TABLE == model && !isTreeModelDatabase) {
            return null;
        }
        return String.format("The region's database %s is belong to %s model, but the model you are operating is %s", databaseName, isTreeModelDatabase ? Model.TREE.toString() : Model.TABLE.toString(), model.toString());
    }

    public TSStatus migrateRegion(TMigrateRegionReq migrateRegionReq) {
        try (AutoCloseableLock ignoredLock = AutoCloseableLock.acquire((Lock)this.env.getSubmitRegionMigrateLock());){
            Optional<TConsensusGroupId> optional = this.configManager.getPartitionManager().generateTConsensusGroupIdByRegionId(migrateRegionReq.getRegionId());
            if (!optional.isPresent()) {
                LOGGER.error("get region group id fail");
                TSStatus tSStatus = new TSStatus(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode()).setMessage("get region group id fail");
                return tSStatus;
            }
            TConsensusGroupId regionGroupId = optional.get();
            TDataNodeLocation originalDataNode = this.configManager.getNodeManager().getRegisteredDataNode(migrateRegionReq.getFromId()).getLocation();
            TDataNodeLocation destDataNode = this.configManager.getNodeManager().getRegisteredDataNode(migrateRegionReq.getToId()).getLocation();
            RegionMaintainHandler handler = this.env.getRegionMaintainHandler();
            TDataNodeLocation coordinatorForAddPeer = handler.filterDataNodeWithOtherRegionReplica(regionGroupId, destDataNode, NodeStatus.Running, NodeStatus.Removing, NodeStatus.ReadOnly).orElse(null);
            TDataNodeLocation coordinatorForRemovePeer = destDataNode;
            TSStatus status = this.checkMigrateRegion(migrateRegionReq, regionGroupId, originalDataNode, destDataNode, coordinatorForAddPeer);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = status;
                return tSStatus;
            }
            this.executor.submitProcedure(new RegionMigrateProcedure(regionGroupId, originalDataNode, destDataNode, coordinatorForAddPeer, coordinatorForRemovePeer));
            LOGGER.info("[MigrateRegion] Submit RegionMigrateProcedure successfully, Region: {}, Origin DataNode: {}, Dest DataNode: {}, Add Coordinator: {}, Remove Coordinator: {}", new Object[]{regionGroupId, originalDataNode, destDataNode, coordinatorForAddPeer, coordinatorForRemovePeer});
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
    }

    public TSStatus reconstructRegion(TReconstructRegionReq req) {
        RegionMaintainHandler handler = this.env.getRegionMaintainHandler();
        TDataNodeLocation targetDataNode = this.configManager.getNodeManager().getRegisteredDataNode(req.getDataNodeId()).getLocation();
        try (AutoCloseableLock ignoredLock = AutoCloseableLock.acquire((Lock)this.env.getSubmitRegionMigrateLock());){
            ArrayList<ReconstructRegionProcedure> procedures = new ArrayList<ReconstructRegionProcedure>();
            Iterator iterator = req.getRegionIds().iterator();
            while (iterator.hasNext()) {
                int x = (Integer)iterator.next();
                TConsensusGroupId regionId = this.configManager.getPartitionManager().generateTConsensusGroupIdByRegionId(x).orElseThrow(() -> new IllegalArgumentException("Region id " + x + " is invalid"));
                TDataNodeLocation coordinator = handler.filterDataNodeWithOtherRegionReplica(regionId, targetDataNode, NodeStatus.Running, NodeStatus.Removing, NodeStatus.ReadOnly).orElse(null);
                TSStatus status = this.checkReconstructRegion(req, regionId, targetDataNode, coordinator);
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    TSStatus tSStatus = status;
                    return tSStatus;
                }
                procedures.add(new ReconstructRegionProcedure(regionId, targetDataNode, coordinator));
            }
            procedures.forEach(reconstructRegionProcedure -> {
                this.executor.submitProcedure((Procedure<ConfigNodeProcedureEnv>)reconstructRegionProcedure);
                LOGGER.info("[ReconstructRegion] Submit ReconstructRegionProcedure successfully, {}", reconstructRegionProcedure);
            });
        }
        return RpcUtils.SUCCESS_STATUS;
    }

    public TSStatus extendRegion(TExtendRegionReq req) {
        try (AutoCloseableLock ignoredLock = AutoCloseableLock.acquire((Lock)this.env.getSubmitRegionMigrateLock());){
            Optional<TConsensusGroupId> optional = this.configManager.getPartitionManager().generateTConsensusGroupIdByRegionId(req.getRegionId());
            if (!optional.isPresent()) {
                LOGGER.error("get region group id fail");
                TSStatus tSStatus = new TSStatus(TSStatusCode.EXTEND_REGION_ERROR.getStatusCode()).setMessage("get region group id fail");
                return tSStatus;
            }
            TConsensusGroupId regionId = optional.get();
            TDataNodeLocation targetDataNode = this.configManager.getNodeManager().getRegisteredDataNode(req.getDataNodeId()).getLocation();
            RegionMaintainHandler handler = this.env.getRegionMaintainHandler();
            TDataNodeLocation coordinator = handler.filterDataNodeWithOtherRegionReplica(regionId, targetDataNode, NodeStatus.Running, NodeStatus.Removing, NodeStatus.ReadOnly).orElse(null);
            TSStatus status = this.checkExtendRegion(req, regionId, targetDataNode, coordinator);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = status;
                return tSStatus;
            }
            AddRegionPeerProcedure procedure = new AddRegionPeerProcedure(regionId, coordinator, targetDataNode);
            this.executor.submitProcedure(procedure);
            LOGGER.info("[ExtendRegion] Submit AddRegionPeerProcedure successfully: {}", (Object)procedure);
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
    }

    public TSStatus removeRegion(TRemoveRegionReq req) {
        try (AutoCloseableLock ignoredLock = AutoCloseableLock.acquire((Lock)this.env.getSubmitRegionMigrateLock());){
            Optional<TConsensusGroupId> optional = this.configManager.getPartitionManager().generateTConsensusGroupIdByRegionId(req.getRegionId());
            if (!optional.isPresent()) {
                LOGGER.error("get region group id fail");
                TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_REGION_PEER_ERROR.getStatusCode()).setMessage("get region group id fail");
                return tSStatus;
            }
            TConsensusGroupId regionId = optional.get();
            TDataNodeLocation targetDataNode = this.configManager.getNodeManager().getRegisteredDataNode(req.getDataNodeId()).getLocation();
            RegionMaintainHandler handler = this.env.getRegionMaintainHandler();
            TDataNodeLocation coordinator = handler.filterDataNodeWithOtherRegionReplica(regionId, targetDataNode, NodeStatus.Running, NodeStatus.Removing, NodeStatus.ReadOnly).orElse(null);
            TSStatus status = this.checkRemoveRegion(req, regionId, targetDataNode, coordinator);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                TSStatus tSStatus = status;
                return tSStatus;
            }
            if (targetDataNode == null) {
                LOGGER.warn("Remove region: Target DataNode {} not found, will simply clean up the partition table of region {} and do nothing else.", (Object)req.getDataNodeId(), (Object)req.getRegionId());
                this.executor.getEnvironment().getRegionMaintainHandler().removeRegionLocation(regionId, ProcedureManager.buildFakeDataNodeLocation(req.getDataNodeId(), "FakeIpForRemoveRegion"));
                TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
                return tSStatus;
            }
            RemoveRegionPeerProcedure procedure = new RemoveRegionPeerProcedure(regionId, coordinator, targetDataNode);
            this.executor.submitProcedure(procedure);
            LOGGER.info("[RemoveRegionPeer] Submit RemoveRegionPeerProcedure successfully: {}", (Object)procedure);
            TSStatus tSStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            return tSStatus;
        }
    }

    private static TDataNodeLocation buildFakeDataNodeLocation(int dataNodeId, String message) {
        TEndPoint fakeEndPoint = new TEndPoint(message, -1);
        return new TDataNodeLocation(dataNodeId, fakeEndPoint, fakeEndPoint, fakeEndPoint, fakeEndPoint, fakeEndPoint);
    }

    public TSStatus createRegionGroups(TConsensusGroupType consensusGroupType, CreateRegionGroupsPlan createRegionGroupsPlan) {
        CreateRegionGroupsProcedure procedure = new CreateRegionGroupsProcedure(consensusGroupType, createRegionGroupsPlan);
        this.executor.submitProcedure(procedure);
        TSStatus status = this.waitingProcedureFinished(procedure);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return new TSStatus(TSStatusCode.CREATE_REGION_ERROR.getStatusCode()).setMessage(status.getMessage());
    }

    public TSStatus createTrigger(TriggerInformation triggerInformation, Binary jarFile, boolean isGeneratedByPipe) {
        CreateTriggerProcedure createTriggerProcedure = new CreateTriggerProcedure(triggerInformation, jarFile, isGeneratedByPipe);
        try {
            if (jarFile != null && (long)new UpdateProcedurePlan(createTriggerProcedure).getSerializedSize() > this.planSizeLimit) {
                return new TSStatus(TSStatusCode.CREATE_TRIGGER_ERROR.getStatusCode()).setMessage(String.format("Fail to create trigger[%s], the size of Jar is too large, you can increase the value of property 'config_node_ratis_log_appender_buffer_size_max' on ConfigNode", triggerInformation.getTriggerName()));
            }
        }
        catch (IOException e) {
            return new TSStatus(TSStatusCode.CREATE_TRIGGER_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        this.executor.submitProcedure(createTriggerProcedure);
        TSStatus status = this.waitingProcedureFinished(createTriggerProcedure);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return new TSStatus(TSStatusCode.CREATE_TRIGGER_ERROR.getStatusCode()).setMessage(status.getMessage());
    }

    public TSStatus dropTrigger(String triggerName, boolean isGeneratedByPipe) {
        DropTriggerProcedure procedure = new DropTriggerProcedure(triggerName, isGeneratedByPipe);
        this.executor.submitProcedure(procedure);
        TSStatus status = this.waitingProcedureFinished(procedure);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return new TSStatus(TSStatusCode.DROP_TRIGGER_ERROR.getStatusCode()).setMessage(status.getMessage());
    }

    public TSStatus createCQ(TCreateCQReq req, ScheduledExecutorService scheduledExecutor) {
        CreateCQProcedure procedure = new CreateCQProcedure(req, scheduledExecutor);
        this.executor.submitProcedure(procedure);
        return this.waitingProcedureFinished(procedure);
    }

    public TSStatus createModel(String modelName, String uri) {
        long procedureId = this.executor.submitProcedure(new CreateModelProcedure(modelName, uri));
        LOGGER.info("CreateModelProcedure was submitted, procedureId: {}.", (Object)procedureId);
        return RpcUtils.SUCCESS_STATUS;
    }

    public TSStatus dropModel(String modelId) {
        DropModelProcedure procedure = new DropModelProcedure(modelId);
        this.executor.submitProcedure(procedure);
        TSStatus status = this.waitingProcedureFinished(procedure);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return new TSStatus(TSStatusCode.DROP_MODEL_ERROR.getStatusCode()).setMessage(status.getMessage());
    }

    public TSStatus createPipePlugin(PipePluginMeta pipePluginMeta, byte[] jarFile, boolean isSetIfNotExistsCondition) {
        CreatePipePluginProcedure createPipePluginProcedure = new CreatePipePluginProcedure(pipePluginMeta, jarFile, isSetIfNotExistsCondition);
        try {
            if (jarFile != null && (long)new UpdateProcedurePlan(createPipePluginProcedure).getSerializedSize() > this.planSizeLimit) {
                return new TSStatus(TSStatusCode.CREATE_PIPE_PLUGIN_ERROR.getStatusCode()).setMessage(String.format("Fail to create pipe plugin[%s], the size of Jar is too large, you can increase the value of property 'config_node_ratis_log_appender_buffer_size_max' on ConfigNode", pipePluginMeta.getPluginName()));
            }
        }
        catch (IOException e) {
            return new TSStatus(TSStatusCode.CREATE_PIPE_PLUGIN_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
        this.executor.submitProcedure(createPipePluginProcedure);
        TSStatus status = this.waitingProcedureFinished(createPipePluginProcedure);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return new TSStatus(TSStatusCode.CREATE_PIPE_PLUGIN_ERROR.getStatusCode()).setMessage(status.getMessage());
    }

    public TSStatus dropPipePlugin(TDropPipePluginReq req) {
        DropPipePluginProcedure procedure = new DropPipePluginProcedure(req.getPluginName(), req.isSetIfExistsCondition() && req.isIfExistsCondition());
        this.executor.submitProcedure(procedure);
        TSStatus status = this.waitingProcedureFinished(procedure);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        return new TSStatus(TSStatusCode.DROP_PIPE_PLUGIN_ERROR.getStatusCode()).setMessage(status.getMessage());
    }

    public TSStatus createConsensusPipe(TCreatePipeReq req) {
        try {
            CreatePipeProcedureV2 procedure = new CreatePipeProcedureV2(req);
            this.executor.submitProcedure(procedure);
            return this.handleConsensusPipeProcedure(procedure);
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus createPipe(TCreatePipeReq req) {
        try {
            CreatePipeProcedureV2 procedure = new CreatePipeProcedureV2(req);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus alterPipe(TAlterPipeReq req) {
        try {
            AlterPipeProcedureV2 procedure = new AlterPipeProcedureV2(req);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus startConsensusPipe(String pipeName) {
        try {
            StartPipeProcedureV2 procedure = new StartPipeProcedureV2(pipeName);
            this.executor.submitProcedure(procedure);
            return this.handleConsensusPipeProcedure(procedure);
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus startPipe(String pipeName) {
        try {
            StartPipeProcedureV2 procedure = new StartPipeProcedureV2(pipeName);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus stopConsensusPipe(String pipeName) {
        try {
            StopPipeProcedureV2 procedure = new StopPipeProcedureV2(pipeName);
            this.executor.submitProcedure(procedure);
            return this.handleConsensusPipeProcedure(procedure);
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus stopPipe(String pipeName) {
        try {
            StopPipeProcedureV2 procedure = new StopPipeProcedureV2(pipeName);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropConsensusPipe(String pipeName) {
        try {
            DropPipeProcedureV2 procedure = new DropPipeProcedureV2(pipeName);
            this.executor.submitProcedure(procedure);
            return this.handleConsensusPipeProcedure(procedure);
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropPipe(String pipeName) {
        try {
            DropPipeProcedureV2 procedure = new DropPipeProcedureV2(pipeName);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    private TSStatus handleConsensusPipeProcedure(Procedure<?> procedure) {
        TSStatus status = this.waitingProcedureFinished(procedure);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return status;
        }
        if (status.getMessage().equals(PROCEDURE_TIMEOUT_MESSAGE)) {
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
    }

    public void pipeHandleLeaderChange(Map<TConsensusGroupId, Pair<Integer, Integer>> dataRegionGroupToOldAndNewLeaderPairMap) {
        try {
            long procedureId = this.executor.submitProcedure(new PipeHandleLeaderChangeProcedure(dataRegionGroupToOldAndNewLeaderPairMap));
            LOGGER.info("PipeHandleLeaderChangeProcedure was submitted, procedureId: {}.", (Object)procedureId);
        }
        catch (Exception e) {
            LOGGER.warn("PipeHandleLeaderChangeProcedure was failed to submit.", (Throwable)e);
        }
    }

    public void pipeHandleMetaChange(boolean needWriteConsensusOnConfigNodes, boolean needPushPipeMetaToDataNodes) {
        try {
            long procedureId = this.executor.submitProcedure(new PipeHandleMetaChangeProcedure(needWriteConsensusOnConfigNodes, needPushPipeMetaToDataNodes));
            LOGGER.info("PipeHandleMetaChangeProcedure was submitted, procedureId: {}.", (Object)procedureId);
        }
        catch (Exception e) {
            LOGGER.warn("PipeHandleMetaChangeProcedure was failed to submit.", (Throwable)e);
        }
    }

    public TSStatus pipeHandleMetaChangeWithBlock(boolean needWriteConsensusOnConfigNodes, boolean needPushPipeMetaToDataNodes) {
        try {
            PipeHandleMetaChangeProcedure procedure = new PipeHandleMetaChangeProcedure(needWriteConsensusOnConfigNodes, needPushPipeMetaToDataNodes);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus pipeMetaSync() {
        try {
            PipeMetaSyncProcedure procedure = new PipeMetaSyncProcedure();
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.PIPE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus createTopic(TCreateTopicReq req) {
        try {
            CreateTopicProcedure procedure = new CreateTopicProcedure(req);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.CREATE_TOPIC_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.CREATE_TOPIC_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropTopic(String topicName) {
        try {
            DropTopicProcedure procedure = new DropTopicProcedure(topicName);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.DROP_TOPIC_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.DROP_TOPIC_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus topicMetaSync() {
        try {
            TopicMetaSyncProcedure procedure = new TopicMetaSyncProcedure();
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.TOPIC_PUSH_META_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.TOPIC_PUSH_META_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus createConsumer(TCreateConsumerReq req) {
        try {
            CreateConsumerProcedure procedure = new CreateConsumerProcedure(req);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.CREATE_CONSUMER_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.CREATE_CONSUMER_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropConsumer(TCloseConsumerReq req) {
        try {
            DropConsumerProcedure procedure = new DropConsumerProcedure(req);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.DROP_CONSUMER_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.DROP_CONSUMER_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus consumerGroupMetaSync() {
        try {
            ConsumerGroupMetaSyncProcedure procedure = new ConsumerGroupMetaSyncProcedure();
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            return new TSStatus(TSStatusCode.CONSUMER_PUSH_META_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.CONSUMER_PUSH_META_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus createSubscription(TSubscribeReq req) {
        try {
            CreateSubscriptionProcedure procedure = new CreateSubscriptionProcedure(req);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            if (PROCEDURE_TIMEOUT_MESSAGE.equals(status.getMessage())) {
                return new TSStatus(TSStatusCode.SUBSCRIPTION_PIPE_TIMEOUT_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
            }
            return new TSStatus(TSStatusCode.SUBSCRIPTION_SUBSCRIBE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.SUBSCRIPTION_SUBSCRIBE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus dropSubscription(TUnsubscribeReq req) {
        try {
            DropSubscriptionProcedure procedure = new DropSubscriptionProcedure(req);
            this.executor.submitProcedure(procedure);
            TSStatus status = this.waitingProcedureFinished(procedure);
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                return status;
            }
            if (PROCEDURE_TIMEOUT_MESSAGE.equals(status.getMessage())) {
                return new TSStatus(TSStatusCode.SUBSCRIPTION_PIPE_TIMEOUT_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
            }
            return new TSStatus(TSStatusCode.SUBSCRIPTION_UNSUBSCRIBE_ERROR.getStatusCode()).setMessage(ProcedureManager.wrapTimeoutMessageForPipeProcedure(status.getMessage()));
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.SUBSCRIPTION_UNSUBSCRIBE_ERROR.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus operateAuthPlan(AuthorPlan authorPlan, List<TDataNodeConfiguration> dns, boolean isGeneratedByPipe) {
        try {
            AuthOperationProcedure procedure = new AuthOperationProcedure(authorPlan, dns, isGeneratedByPipe);
            this.executor.submitProcedure(procedure);
            return this.waitingProcedureFinished(procedure);
        }
        catch (Exception e) {
            return new TSStatus(TSStatusCode.AUTH_OPERATE_EXCEPTION.getStatusCode()).setMessage(e.getMessage());
        }
    }

    public TSStatus setTTL(SetTTLPlan setTTLPlan, boolean isGeneratedByPipe) {
        SetTTLProcedure procedure = new SetTTLProcedure(setTTLPlan, isGeneratedByPipe);
        this.executor.submitProcedure(procedure);
        return this.waitingProcedureFinished(procedure);
    }

    private TSStatus waitingProcedureFinished(long procedureId) {
        return this.waitingProcedureFinished(this.executor.getProcedures().get(procedureId));
    }

    private TSStatus waitingProcedureFinished(Procedure<?> procedure) {
        IoTDBException e;
        if (procedure == null) {
            LOGGER.error("Unexpected null procedure parameters for waitingProcedureFinished");
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR);
        }
        long startTimeForCurrentProcedure = System.currentTimeMillis();
        while (this.executor.isRunning() && !this.executor.isFinished(procedure.getProcId()) && System.currentTimeMillis() - startTimeForCurrentProcedure < PROCEDURE_WAIT_TIME_OUT) {
            ProcedureManager.sleepWithoutInterrupt(10L);
        }
        TSStatus status = !procedure.isFinished() ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)PROCEDURE_TIMEOUT_MESSAGE) : (procedure.isSuccess() ? (procedure.getResult() != null ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)Arrays.toString(procedure.getResult())) : StatusUtils.OK) : (procedure.getException().getCause() instanceof IoTDBException ? ((e = (IoTDBException)procedure.getException().getCause()) instanceof BatchProcessException ? RpcUtils.getStatus(Arrays.stream(((BatchProcessException)e).getFailingStatus()).collect(Collectors.toList())) : RpcUtils.getStatus((int)e.getErrorCode(), (String)e.getMessage())) : StatusUtils.EXECUTE_STATEMENT_ERROR.setMessage(procedure.getException().getMessage())));
        return status;
    }

    private static String wrapTimeoutMessageForPipeProcedure(String message) {
        if (message.equals(PROCEDURE_TIMEOUT_MESSAGE)) {
            return message + " Please manually check later whether the procedure is executed successfully.";
        }
        return message;
    }

    public static void sleepWithoutInterrupt(long timeToSleep) {
        long currentTime = System.currentTimeMillis();
        long endTime = timeToSleep + currentTime;
        boolean interrupted = false;
        while (currentTime < endTime) {
            try {
                Thread.sleep(endTime - currentTime);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            currentTime = System.currentTimeMillis();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public TSStatus createTable(String database, TsTable table) {
        return this.executeWithoutDuplicate(database, table, table.getTableName(), null, ProcedureType.CREATE_TABLE_PROCEDURE, new CreateTableProcedure(database, table, false));
    }

    public TSStatus createTableView(String database, TsTable table, boolean replace) {
        return this.executeWithoutDuplicate(database, table, table.getTableName(), null, ProcedureType.CREATE_TABLE_VIEW_PROCEDURE, new CreateTableViewProcedure(database, table, replace, false));
    }

    public TSStatus alterTableAddColumn(TAlterOrDropTableReq req) {
        boolean isView = req.isSetIsView() && req.isIsView();
        return this.executeWithoutDuplicate(req.database, null, req.tableName, req.queryId, isView ? ProcedureType.ADD_VIEW_COLUMN_PROCEDURE : ProcedureType.ADD_TABLE_COLUMN_PROCEDURE, isView ? new AddViewColumnProcedure(req.database, req.tableName, req.queryId, TsTableColumnSchemaUtil.deserializeColumnSchemaList((ByteBuffer)req.updateInfo), false) : new AddTableColumnProcedure(req.database, req.tableName, req.queryId, TsTableColumnSchemaUtil.deserializeColumnSchemaList((ByteBuffer)req.updateInfo), false));
    }

    public TSStatus alterTableSetProperties(TAlterOrDropTableReq req) {
        boolean isView = req.isSetIsView() && req.isIsView();
        return this.executeWithoutDuplicate(req.database, null, req.tableName, req.queryId, isView ? ProcedureType.SET_VIEW_PROPERTIES_PROCEDURE : ProcedureType.SET_TABLE_PROPERTIES_PROCEDURE, isView ? new SetViewPropertiesProcedure(req.database, req.tableName, req.queryId, ReadWriteIOUtils.readMap((ByteBuffer)req.updateInfo), false) : new SetTablePropertiesProcedure(req.database, req.tableName, req.queryId, ReadWriteIOUtils.readMap((ByteBuffer)req.updateInfo), false));
    }

    public TSStatus alterTableRenameColumn(TAlterOrDropTableReq req) {
        boolean isView = req.isSetIsView() && req.isIsView();
        return this.executeWithoutDuplicate(req.database, null, req.tableName, req.queryId, isView ? ProcedureType.RENAME_VIEW_COLUMN_PROCEDURE : ProcedureType.RENAME_TABLE_COLUMN_PROCEDURE, isView ? new RenameViewColumnProcedure(req.database, req.tableName, req.queryId, ReadWriteIOUtils.readString((ByteBuffer)req.updateInfo), ReadWriteIOUtils.readString((ByteBuffer)req.updateInfo), false) : new RenameTableColumnProcedure(req.database, req.tableName, req.queryId, ReadWriteIOUtils.readString((ByteBuffer)req.updateInfo), ReadWriteIOUtils.readString((ByteBuffer)req.updateInfo), false));
    }

    public TSStatus alterTableDropColumn(TAlterOrDropTableReq req) {
        boolean isView = req.isSetIsView() && req.isIsView();
        return this.executeWithoutDuplicate(req.database, null, req.tableName, req.queryId, isView ? ProcedureType.DROP_VIEW_COLUMN_PROCEDURE : ProcedureType.DROP_TABLE_COLUMN_PROCEDURE, isView ? new DropViewColumnProcedure(req.database, req.tableName, req.queryId, ReadWriteIOUtils.readString((ByteBuffer)req.updateInfo), false) : new DropTableColumnProcedure(req.database, req.tableName, req.queryId, ReadWriteIOUtils.readString((ByteBuffer)req.updateInfo), false));
    }

    public TSStatus dropTable(TAlterOrDropTableReq req) {
        boolean isView = req.isSetIsView() && req.isIsView();
        return this.executeWithoutDuplicate(req.database, null, req.tableName, req.queryId, isView ? ProcedureType.DROP_VIEW_PROCEDURE : ProcedureType.DROP_TABLE_PROCEDURE, isView ? new DropViewProcedure(req.database, req.tableName, req.queryId, false) : new DropTableProcedure(req.database, req.tableName, req.queryId, false));
    }

    public TSStatus renameTable(TAlterOrDropTableReq req) {
        boolean isView = req.isSetIsView() && req.isIsView();
        String newName = ReadWriteIOUtils.readString((ByteBuffer)req.updateInfo);
        return this.executeWithoutDuplicate(req.database, null, req.tableName, newName, req.queryId, isView ? ProcedureType.RENAME_VIEW_PROCEDURE : ProcedureType.RENAME_TABLE_PROCEDURE, isView ? new RenameViewProcedure(req.database, req.tableName, req.queryId, newName, false) : new RenameTableProcedure(req.database, req.tableName, req.queryId, newName, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDeleteTableDeviceResp deleteDevices(TDeleteTableDeviceReq req, boolean isGeneratedByPipe) {
        TSStatus status;
        DeleteDevicesProcedure procedure = null;
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            Pair<Long, Boolean> procedureIdDuplicatePair = this.checkDuplicateTableTask(req.database, null, req.tableName, null, req.queryId, ProcedureType.DELETE_DEVICES_PROCEDURE);
            long procedureId = (Long)procedureIdDuplicatePair.getLeft();
            if (procedureId == -1L) {
                if (Boolean.TRUE.equals(procedureIdDuplicatePair.getRight())) {
                    return new TDeleteTableDeviceResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)"Some other task is operating table with same name."));
                }
                procedure = new DeleteDevicesProcedure(req.database, req.tableName, req.queryId, req.getPatternInfo(), req.getFilterInfo(), req.getModInfo(), isGeneratedByPipe);
                this.executor.submitProcedure(procedure);
                status = this.waitingProcedureFinished(procedure);
            } else {
                status = this.waitingProcedureFinished(procedureId);
            }
        }
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return new TDeleteTableDeviceResp(StatusUtils.OK).setDeletedNum(Optional.ofNullable(procedure).map(DeleteDevicesProcedure::getDeletedDevicesNum).orElse(-1L).longValue());
        }
        return new TDeleteTableDeviceResp(status);
    }

    public TSStatus executeWithoutDuplicate(String database, TsTable table, String tableName, String queryId, ProcedureType thisType, Procedure<ConfigNodeProcedureEnv> procedure) {
        return this.executeWithoutDuplicate(database, table, tableName, null, queryId, thisType, procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus executeWithoutDuplicate(String database, TsTable table, String tableName, @Nullable String newName, String queryId, ProcedureType thisType, Procedure<ConfigNodeProcedureEnv> procedure) {
        ProcedureManager procedureManager = this;
        synchronized (procedureManager) {
            Pair<Long, Boolean> procedureIdDuplicatePair = this.checkDuplicateTableTask(database, table, tableName, newName, queryId, thisType);
            long procedureId = (Long)procedureIdDuplicatePair.getLeft();
            if (procedureId == -1L) {
                if (Boolean.TRUE.equals(procedureIdDuplicatePair.getRight())) {
                    return RpcUtils.getStatus((TSStatusCode)TSStatusCode.OVERLAP_WITH_EXISTING_TASK, (String)"Some other task is operating table with same name.");
                }
            } else {
                return this.waitingProcedureFinished(procedureId);
            }
            this.executor.submitProcedure(procedure);
        }
        return this.waitingProcedureFinished(procedure);
    }

    public Pair<Long, Boolean> checkDuplicateTableTask(@Nonnull String database, TsTable table, String tableName, String newName, String queryId, ProcedureType thisType) {
        for (Procedure<ConfigNodeProcedureEnv> procedure : this.executor.getProcedures().values()) {
            ProcedureType type = ProcedureFactory.getProcedureType(procedure);
            if (type == null || procedure.isFinished()) continue;
            switch (type) {
                case CREATE_TABLE_PROCEDURE: 
                case CREATE_TABLE_VIEW_PROCEDURE: {
                    CreateTableProcedure createTableProcedure = (CreateTableProcedure)procedure;
                    if (type == thisType && Objects.equals(table, createTableProcedure.getTable())) {
                        return new Pair((Object)procedure.getProcId(), (Object)false);
                    }
                    if (!database.equals(createTableProcedure.getDatabase()) || !Objects.isNull(tableName) && !Objects.equals(tableName, createTableProcedure.getTable().getTableName()) && (!Objects.nonNull(newName) || !Objects.equals(newName, createTableProcedure.getTable().getTableName()))) break;
                    return new Pair((Object)-1L, (Object)true);
                }
                case ADD_TABLE_COLUMN_PROCEDURE: 
                case ADD_VIEW_COLUMN_PROCEDURE: 
                case SET_TABLE_PROPERTIES_PROCEDURE: 
                case SET_VIEW_PROPERTIES_PROCEDURE: 
                case RENAME_TABLE_COLUMN_PROCEDURE: 
                case RENAME_VIEW_COLUMN_PROCEDURE: 
                case DROP_TABLE_COLUMN_PROCEDURE: 
                case DROP_VIEW_COLUMN_PROCEDURE: 
                case DROP_TABLE_PROCEDURE: 
                case DROP_VIEW_PROCEDURE: 
                case DELETE_DEVICES_PROCEDURE: {
                    AbstractAlterOrDropTableProcedure alterTableProcedure = (AbstractAlterOrDropTableProcedure)procedure;
                    if (type == thisType && queryId.equals(alterTableProcedure.getQueryId())) {
                        return new Pair((Object)procedure.getProcId(), (Object)false);
                    }
                    if (!database.equals(alterTableProcedure.getDatabase()) || !Objects.isNull(tableName) && !Objects.equals(tableName, alterTableProcedure.getTableName()) && (!Objects.nonNull(newName) || !Objects.equals(newName, alterTableProcedure.getTableName()))) break;
                    return new Pair((Object)-1L, (Object)true);
                }
                case RENAME_TABLE_PROCEDURE: 
                case RENAME_VIEW_PROCEDURE: {
                    RenameTableProcedure renameTableProcedure = (RenameTableProcedure)procedure;
                    if (type == thisType && queryId.equals(renameTableProcedure.getQueryId())) {
                        return new Pair((Object)procedure.getProcId(), (Object)false);
                    }
                    if (!database.equals(renameTableProcedure.getDatabase()) || !Objects.isNull(tableName) && !Objects.equals(tableName, renameTableProcedure.getTableName()) && !Objects.equals(tableName, renameTableProcedure.getNewName()) && (!Objects.nonNull(newName) || !Objects.equals(newName, renameTableProcedure.getTableName()) && !Objects.equals(newName, renameTableProcedure.getNewName()))) break;
                    return new Pair((Object)-1L, (Object)true);
                }
                case DELETE_DATABASE_PROCEDURE: {
                    DeleteDatabaseProcedure deleteDatabaseProcedure = (DeleteDatabaseProcedure)procedure;
                    if (!database.equals(deleteDatabaseProcedure.getDatabase())) break;
                    return new Pair((Object)-1L, (Object)true);
                }
            }
        }
        return new Pair((Object)-1L, (Object)false);
    }

    public IManager getConfigManager() {
        return this.configManager;
    }

    public ProcedureExecutor<ConfigNodeProcedureEnv> getExecutor() {
        return this.executor;
    }

    public void setExecutor(ProcedureExecutor<ConfigNodeProcedureEnv> executor) {
        this.executor = executor;
    }

    public ProcedureScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ProcedureScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public IProcedureStore getStore() {
        return this.store;
    }

    public ConfigNodeProcedureEnv getEnv() {
        return this.env;
    }

    public void setEnv(ConfigNodeProcedureEnv env) {
        this.env = env;
    }

    public void addMetrics() {
        MetricService.getInstance().addMetricSet((IMetricSet)this.procedureMetrics);
    }

    public void removeMetrics() {
        MetricService.getInstance().removeMetricSet((IMetricSet)this.procedureMetrics);
    }

    public ProcedureMetrics getProcedureMetrics() {
        return this.procedureMetrics;
    }
}

