/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.entity.ModelType;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;

public class User
extends Role {
    private String password;
    private Set<String> roleSet;
    private boolean isOpenIdUser = false;

    public User() {
    }

    public User(String name, String password) {
        super(name);
        this.password = password;
        this.roleSet = new HashSet<String>();
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setOpenIdUser(boolean openIdUser) {
        this.isOpenIdUser = openIdUser;
    }

    public void setRoleSet(Set<String> roles) {
        this.roleSet = roles;
    }

    public void addRole(String roleName) {
        this.roleSet.add(roleName);
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isOpenIdUser() {
        return this.isOpenIdUser;
    }

    public boolean hasRole(String role) {
        return this.roleSet.contains(role);
    }

    public Set<String> getRoleSet() {
        return this.roleSet;
    }

    public TUserResp getUserInfo(ModelType modelType) {
        TUserResp resp = new TUserResp();
        resp.setPermissionInfo(this.getRoleInfo(modelType));
        resp.setPassword(this.password);
        resp.setIsOpenIdUser(this.isOpenIdUser);
        resp.setRoleSet(this.roleSet);
        return resp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.contentEquals(user);
    }

    private boolean contentEquals(User user) {
        return super.equals(user) && Objects.equals(this.roleSet, user.roleSet) && Objects.equals(this.password, user.password) && Objects.equals(this.isOpenIdUser, user.isOpenIdUser);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.getName(), this.password, super.getPathPrivilegeList(), super.getSysPrivilege(), this.roleSet, this.isOpenIdUser);
    }

    @Override
    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serialize(super.getName(), dataOutputStream);
        SerializeUtils.serialize(this.password, dataOutputStream);
        try {
            dataOutputStream.writeInt(super.getSysPrivilege().size());
            for (PrivilegeType item : super.getSysPrivilege()) {
                dataOutputStream.writeInt(item.ordinal());
            }
            dataOutputStream.writeInt(super.getSysPriGrantOpt().size());
            for (PrivilegeType item : super.getSysPriGrantOpt()) {
                dataOutputStream.writeInt(item.ordinal());
            }
            dataOutputStream.writeInt(super.getPathPrivilegeList().size());
            for (PathPrivilege pathPrivilege : super.getPathPrivilegeList()) {
                dataOutputStream.write(pathPrivilege.serialize().array());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SerializeUtils.serializeStringList(new ArrayList<String>(this.roleSet), dataOutputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        super.setName(SerializeUtils.deserializeString(buffer));
        this.password = SerializeUtils.deserializeString(buffer);
        int systemPriSize = buffer.getInt();
        HashSet<PrivilegeType> sysPri = new HashSet<PrivilegeType>();
        for (int i = 0; i < systemPriSize; ++i) {
            sysPri.add(PrivilegeType.values()[buffer.getInt()]);
        }
        super.setSysPrivilegeSet(sysPri);
        int sysPriGrantOptSize = buffer.getInt();
        HashSet<PrivilegeType> grantOpt = new HashSet<PrivilegeType>();
        for (int i = 0; i < sysPriGrantOptSize; ++i) {
            grantOpt.add(PrivilegeType.values()[buffer.getInt()]);
        }
        super.setSysPriGrantOpt(grantOpt);
        int privilegeListSize = buffer.getInt();
        ArrayList<PathPrivilege> privilegeList = new ArrayList<PathPrivilege>(privilegeListSize);
        for (int i = 0; i < privilegeListSize; ++i) {
            PathPrivilege pathPrivilege = new PathPrivilege();
            pathPrivilege.deserialize(buffer);
            privilegeList.add(pathPrivilege);
        }
        super.setPrivilegeList(privilegeList);
        this.roleSet = new HashSet<String>(SerializeUtils.deserializeStringList(buffer));
    }

    @Override
    public String toString() {
        return "User{name='" + super.getName() + '\'' + ", pathPrivilegeList=" + this.pathPrivilegeList + ", sysPrivilegeSet=" + this.priSetToString(this.sysPrivilegeSet, this.sysPriGrantOpt) + ", AnyScopePrivilegeMap=" + this.priSetToString(this.anyScopePrivilegeSet, this.anyScopePrivilegeGrantOptSet) + ", objectPrivilegeMap=" + this.objectPrivilegeMap + ", roleList=" + this.roleSet + ", isOpenIdUser=" + this.isOpenIdUser + '}';
    }
}

