/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.user;

import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.IEntityAccessor;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.role.BasicRoleManager;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicUserManager
extends BasicRoleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicUserManager.class);

    @Override
    protected TSStatusCode getEntityNotExistErrorCode() {
        return TSStatusCode.USER_NOT_EXIST;
    }

    @Override
    protected String getNoSuchEntityError() {
        return "No such user %s";
    }

    protected BasicUserManager(IEntityAccessor accessor) throws AuthException {
        super(accessor);
        this.accessor = accessor;
        this.init();
    }

    private void initAdmin() throws AuthException {
        User admin = this.getEntity(CommonDescriptor.getInstance().getConfig().getAdminName());
        if (admin == null) {
            this.createUser(CommonDescriptor.getInstance().getConfig().getAdminName(), CommonDescriptor.getInstance().getConfig().getAdminPassword(), true, true);
        }
        admin = this.getEntity(CommonDescriptor.getInstance().getConfig().getAdminName());
        try {
            PartialPath rootPath = new PartialPath("root.**");
            PathPrivilege pathPri = new PathPrivilege(rootPath);
            for (PrivilegeType item : PrivilegeType.values()) {
                if (item.isSystemPrivilege()) {
                    admin.grantSysPrivilege(item, true);
                    continue;
                }
                if (item.isRelationalPrivilege()) {
                    admin.grantAnyScopePrivilege(item, true);
                    continue;
                }
                if (!item.isPathPrivilege()) continue;
                pathPri.grantPrivilege(item, true);
            }
            admin.getPathPrivilegeList().clear();
            admin.getPathPrivilegeList().add(pathPri);
        }
        catch (IllegalPathException e) {
            LOGGER.warn("Got a wrong path for root to init");
        }
        LOGGER.info("Admin initialized");
    }

    @Override
    public User getEntity(String entityName) {
        return (User)super.getEntity(entityName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createUser(String username, String password, boolean validCheck, boolean enableEncrypt) throws AuthException {
        User user;
        if (validCheck) {
            AuthUtils.validateUsername(username);
            if (enableEncrypt) {
                AuthUtils.validatePassword(password);
            }
        }
        if ((user = this.getEntity(username)) != null) {
            return false;
        }
        this.lock.writeLock(username);
        try {
            user = new User(username, enableEncrypt ? AuthUtils.encryptPassword(password) : password);
            this.entityMap.put(username, user);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUserPassword(String username, String newPassword) throws AuthException {
        try {
            AuthUtils.validatePassword(newPassword);
        }
        catch (AuthException e) {
            LOGGER.debug("An illegal password detected ", (Throwable)e);
            return false;
        }
        this.lock.writeLock(username);
        try {
            User user = this.getEntity(username);
            if (user == null) {
                throw new AuthException(this.getEntityNotExistErrorCode(), String.format(this.getNoSuchEntityError(), username));
            }
            user.setPassword(AuthUtils.encryptPassword(newPassword));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void grantRoleToUser(String roleName, String username) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getEntity(username);
            if (user == null) {
                throw new AuthException(this.getEntityNotExistErrorCode(), String.format(this.getNoSuchEntityError(), username));
            }
            user.getRoleSet().add(roleName);
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeRoleFromUser(String roleName, String username) throws AuthException {
        this.lock.writeLock(username);
        try {
            User user = this.getEntity(username);
            if (user == null) {
                throw new AuthException(this.getEntityNotExistErrorCode(), String.format(this.getNoSuchEntityError(), username));
            }
            user.getRoleSet().remove(roleName);
        }
        finally {
            this.lock.writeUnlock(username);
        }
    }

    private void init() throws AuthException {
        this.accessor.reset();
        this.initAdmin();
    }

    @Override
    public void reset() throws AuthException {
        super.reset();
        this.initAdmin();
    }

    @TestOnly
    public boolean createUser(String username, String password, boolean validCheck) throws AuthException {
        return this.createUser(username, password, validCheck, true);
    }
}

