/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.function;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.TableScanOperator;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.udf.api.relational.table.TableFunctionProcessorProvider;
import org.apache.iotdb.udf.api.relational.table.processor.TableFunctionLeafProcessor;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;

public class TableFunctionLeafOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final TsBlockBuilder blockBuilder;
    private final TableFunctionLeafProcessor processor;
    private volatile boolean init = false;

    public TableFunctionLeafOperator(OperatorContext operatorContext, TableFunctionProcessorProvider processorProvider, List<TSDataType> outputDataTypes) {
        this.operatorContext = operatorContext;
        this.processor = processorProvider.getSplitProcessor();
        this.blockBuilder = new TsBlockBuilder(outputDataTypes);
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (!this.init) {
            this.init = true;
            this.processor.beforeStart();
        }
        return NOT_BLOCKED;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        List<ColumnBuilder> columnBuilders = this.getOutputColumnBuilders();
        try {
            this.processor.process(columnBuilders);
        }
        catch (Exception e) {
            throw new IoTDBRuntimeException(e.getMessage(), TSStatusCode.EXECUTE_UDF_ERROR.getStatusCode(), true);
        }
        return this.buildTsBlock(columnBuilders);
    }

    private List<ColumnBuilder> getOutputColumnBuilders() {
        this.blockBuilder.reset();
        return Arrays.asList(this.blockBuilder.getValueColumnBuilders());
    }

    private TsBlock buildTsBlock(List<ColumnBuilder> columnBuilders) {
        int positionCount = columnBuilders.get(0).getPositionCount();
        this.blockBuilder.declarePositions(positionCount);
        return this.blockBuilder.build((Column)new RunLengthEncodedColumn((Column)TableScanOperator.TIME_COLUMN_TEMPLATE, positionCount));
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.processor.isFinish();
    }

    @Override
    public void close() throws Exception {
        try {
            this.processor.beforeDestroy();
        }
        catch (Exception e) {
            throw new IoTDBRuntimeException(e.getMessage(), TSStatusCode.EXECUTE_UDF_ERROR.getStatusCode(), true);
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return this.processor.isFinish();
    }

    @Override
    public long calculateMaxPeekMemory() {
        return 0L;
    }

    @Override
    public long calculateMaxReturnSize() {
        return 0L;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }

    public long ramBytesUsed() {
        return 0L;
    }
}

