/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.conf;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.conf.Reconfigurable;
import org.apache.ratis.conf.ReconfigurationException;
import org.apache.ratis.conf.ReconfigurationStatus;
import org.apache.ratis.util.Daemon;
import org.apache.ratis.util.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReconfigurationBase
implements Reconfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(ReconfigurationBase.class);
    private final String name;
    private final RaftProperties properties;
    private final Context context;

    public static Collection<ReconfigurationStatus.PropertyChange> getChangedProperties(RaftProperties newProperties, RaftProperties oldProperties) {
        String prop;
        HashMap<String, ReconfigurationStatus.PropertyChange> changes = new HashMap<String, ReconfigurationStatus.PropertyChange>();
        for (Map.Entry<String, String> oldEntry : oldProperties.entrySet()) {
            prop = oldEntry.getKey();
            String oldVal = oldEntry.getValue();
            String newVal = newProperties.getRaw(prop);
            if (Objects.equals(newVal, oldVal)) continue;
            changes.put(prop, new ReconfigurationStatus.PropertyChange(prop, newVal, oldVal));
        }
        for (Map.Entry<String, String> newEntry : newProperties.entrySet()) {
            prop = newEntry.getKey();
            String newVal = newEntry.getValue();
            if (newVal == null || oldProperties.get(prop) != null) continue;
            changes.put(prop, new ReconfigurationStatus.PropertyChange(prop, newVal, null));
        }
        return changes.values();
    }

    protected ReconfigurationBase(String name, RaftProperties properties) {
        this.name = name;
        this.properties = properties;
        this.context = new Context();
    }

    @Override
    public RaftProperties getProperties() {
        return this.properties;
    }

    protected abstract RaftProperties getNewProperties();

    public void startReconfiguration() throws IOException {
        this.context.start();
    }

    public ReconfigurationStatus getReconfigurationStatus() {
        return this.context.getStatus();
    }

    public void shutdown() throws InterruptedException {
        this.context.stop().join();
    }

    private void batchReconfiguration() {
        LOG.info("{}: Starting batch reconfiguration {}", (Object)this.name, (Object)Thread.currentThread());
        Collection<ReconfigurationStatus.PropertyChange> changes = ReconfigurationBase.getChangedProperties(this.getNewProperties(), this.properties);
        HashMap<ReconfigurationStatus.PropertyChange, Throwable> results = new HashMap<ReconfigurationStatus.PropertyChange, Throwable>();
        for (ReconfigurationStatus.PropertyChange change : changes) {
            LOG.info("Change property: " + change);
            try {
                this.singleReconfiguration(change.getProperty(), change.getNewValue());
                results.put(change, null);
            }
            catch (Throwable t) {
                results.put(change, t);
            }
        }
        this.context.end(results);
    }

    private void singleReconfiguration(String property, String newValue) throws ReconfigurationException {
        if (!this.isPropertyReconfigurable(property)) {
            throw new ReconfigurationException("Property is not reconfigurable.", property, newValue, this.properties.get(property));
        }
        String effective = this.reconfigureProperty(property, newValue);
        LOG.info("{}: changed property {} to {} (effective {})", new Object[]{this.name, property, newValue, effective});
        if (effective != null) {
            this.properties.set(property, effective);
        } else {
            this.properties.unset(property);
        }
    }

    class Context {
        private ReconfigurationStatus status = new ReconfigurationStatus(null, null, null, null);
        private boolean isStopped;

        Context() {
        }

        synchronized ReconfigurationStatus getStatus() {
            return this.status;
        }

        synchronized void start() {
            if (this.isStopped) {
                throw new IllegalStateException(ReconfigurationBase.this.name + " is stopped.");
            }
            Daemon previous = this.status.getDaemon();
            if (previous != null) {
                throw new IllegalStateException(ReconfigurationBase.this.name + ": a reconfiguration task " + previous + " is already running.");
            }
            Timestamp startTime = Timestamp.currentTime();
            Daemon task = Daemon.newBuilder().setName("started@" + startTime).setRunnable(() -> ReconfigurationBase.this.batchReconfiguration()).build();
            this.status = new ReconfigurationStatus(startTime, null, null, task);
            task.start();
        }

        synchronized void end(Map<ReconfigurationStatus.PropertyChange, Throwable> results) {
            this.status = new ReconfigurationStatus(this.status.getStartTime(), Timestamp.currentTime(), results, null);
        }

        synchronized Daemon stop() {
            this.isStopped = true;
            Daemon task = this.status.getDaemon();
            this.status = new ReconfigurationStatus(this.status.getStartTime(), null, null, null);
            return task;
        }
    }
}

