/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.unboundidds.ModifiablePasswordPolicyStateJSON;
import com.unboundid.ldap.sdk.unboundidds.ModifiablePasswordPolicyStateJSONField;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONNull;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ModifiablePasswordPolicyStateJSONBuilder
implements Serializable {
    private static final long serialVersionUID = -1059372199527400142L;
    @Nullable
    private Boolean accountIsDisabled;
    @Nullable
    private Boolean accountIsFailureLocked;
    @Nullable
    private Boolean mustChangePassword;
    @Nullable
    private Long accountActivationTime;
    @Nullable
    private Long accountExpirationTime;
    @Nullable
    private Long passwordChangedTime;
    @Nullable
    private Long passwordExpirationWarnedTime;

    public ModifiablePasswordPolicyStateJSONBuilder() {
        this.accountIsDisabled = null;
        this.accountIsFailureLocked = null;
        this.mustChangePassword = null;
        this.accountActivationTime = null;
        this.accountExpirationTime = null;
        this.passwordChangedTime = null;
        this.passwordExpirationWarnedTime = null;
    }

    public ModifiablePasswordPolicyStateJSONBuilder(@NotNull ModifiablePasswordPolicyStateJSON state) {
        this.accountIsDisabled = state.getAccountIsDisabled();
        this.accountIsFailureLocked = state.getAccountIsFailureLocked();
        this.mustChangePassword = state.getMustChangePassword();
        this.accountActivationTime = state.getAccountActivationTime();
        this.accountExpirationTime = state.getAccountExpirationTime();
        this.passwordChangedTime = state.getPasswordChangedTime();
        this.passwordExpirationWarnedTime = state.getPasswordExpirationWarnedTime();
    }

    @Nullable
    public Long getPasswordChangedTime() {
        return this.passwordChangedTime;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setPasswordChangedTime(@Nullable Long passwordChangedTime) {
        this.passwordChangedTime = passwordChangedTime != null && passwordChangedTime < 0L ? Long.valueOf(-1L) : passwordChangedTime;
        return this;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setPasswordChangedTime(@Nullable Date passwordChangedTime) {
        this.passwordChangedTime = passwordChangedTime == null ? Long.valueOf(-1L) : Long.valueOf(passwordChangedTime.getTime());
        return this;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder clearPasswordChangedTime() {
        this.passwordChangedTime = -1L;
        return this;
    }

    @Nullable
    public Boolean getAccountIsDisabled() {
        return this.accountIsDisabled;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setAccountIsDisabled(@Nullable Boolean accountIsDisabled) {
        this.accountIsDisabled = accountIsDisabled;
        return this;
    }

    @Nullable
    public Long getAccountActivationTime() {
        return this.accountActivationTime;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setAccountActivationTime(@Nullable Long accountActivationTime) {
        this.accountActivationTime = accountActivationTime != null && accountActivationTime < 0L ? Long.valueOf(-1L) : accountActivationTime;
        return this;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setAccountActivationTime(@Nullable Date accountActivationTime) {
        this.accountActivationTime = accountActivationTime == null ? Long.valueOf(-1L) : Long.valueOf(accountActivationTime.getTime());
        return this;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder clearAccountActivationTime() {
        this.accountActivationTime = -1L;
        return this;
    }

    @Nullable
    public Long getAccountExpirationTime() {
        return this.accountExpirationTime;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setAccountExpirationTime(@Nullable Long accountExpirationTime) {
        this.accountExpirationTime = accountExpirationTime != null && accountExpirationTime < 0L ? Long.valueOf(-1L) : accountExpirationTime;
        return this;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setAccountExpirationTime(@Nullable Date accountExpirationTime) {
        this.accountExpirationTime = accountExpirationTime == null ? Long.valueOf(-1L) : Long.valueOf(accountExpirationTime.getTime());
        return this;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder clearAccountExpirationTime() {
        this.accountExpirationTime = -1L;
        return this;
    }

    @Nullable
    public Boolean getAccountIsFailureLocked() {
        return this.accountIsFailureLocked;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setAccountIsFailureLocked(@Nullable Boolean accountIsFailureLocked) {
        this.accountIsFailureLocked = accountIsFailureLocked;
        return this;
    }

    @Nullable
    public Long getPasswordExpirationWarnedTime() {
        return this.passwordExpirationWarnedTime;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setPasswordExpirationWarnedTime(@Nullable Long passwordExpirationWarnedTime) {
        this.passwordExpirationWarnedTime = passwordExpirationWarnedTime != null && passwordExpirationWarnedTime < 0L ? Long.valueOf(-1L) : passwordExpirationWarnedTime;
        return this;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setPasswordExpirationWarnedTime(@Nullable Date passwordExpirationWarnedTime) {
        this.passwordExpirationWarnedTime = passwordExpirationWarnedTime == null ? Long.valueOf(-1L) : Long.valueOf(passwordExpirationWarnedTime.getTime());
        return this;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder clearPasswordExpirationWarnedTime() {
        this.passwordExpirationWarnedTime = -1L;
        return this;
    }

    @Nullable
    public Boolean getMustChangePassword() {
        return this.mustChangePassword;
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSONBuilder setMustChangePassword(@Nullable Boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
        return this;
    }

    @NotNull
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(7));
        if (this.passwordChangedTime != null) {
            if (this.passwordChangedTime >= 0L) {
                fields.put(ModifiablePasswordPolicyStateJSONField.PASSWORD_CHANGED_TIME.getFieldName(), new JSONString(StaticUtils.encodeRFC3339Time(this.passwordChangedTime)));
            } else {
                fields.put(ModifiablePasswordPolicyStateJSONField.PASSWORD_CHANGED_TIME.getFieldName(), JSONNull.NULL);
            }
        }
        if (this.accountIsDisabled != null) {
            fields.put(ModifiablePasswordPolicyStateJSONField.ACCOUNT_IS_DISABLED.getFieldName(), new JSONBoolean(this.accountIsDisabled));
        }
        if (this.accountActivationTime != null) {
            if (this.accountActivationTime >= 0L) {
                fields.put(ModifiablePasswordPolicyStateJSONField.ACCOUNT_ACTIVATION_TIME.getFieldName(), new JSONString(StaticUtils.encodeRFC3339Time(this.accountActivationTime)));
            } else {
                fields.put(ModifiablePasswordPolicyStateJSONField.ACCOUNT_ACTIVATION_TIME.getFieldName(), JSONNull.NULL);
            }
        }
        if (this.accountExpirationTime != null) {
            if (this.accountExpirationTime >= 0L) {
                fields.put(ModifiablePasswordPolicyStateJSONField.ACCOUNT_EXPIRATION_TIME.getFieldName(), new JSONString(StaticUtils.encodeRFC3339Time(this.accountExpirationTime)));
            } else {
                fields.put(ModifiablePasswordPolicyStateJSONField.ACCOUNT_EXPIRATION_TIME.getFieldName(), JSONNull.NULL);
            }
        }
        if (this.accountIsFailureLocked != null) {
            fields.put(ModifiablePasswordPolicyStateJSONField.ACCOUNT_IS_FAILURE_LOCKED.getFieldName(), new JSONBoolean(this.accountIsFailureLocked));
        }
        if (this.passwordExpirationWarnedTime != null) {
            if (this.passwordExpirationWarnedTime >= 0L) {
                fields.put(ModifiablePasswordPolicyStateJSONField.PASSWORD_EXPIRATION_WARNED_TIME.getFieldName(), new JSONString(StaticUtils.encodeRFC3339Time(this.passwordExpirationWarnedTime)));
            } else {
                fields.put(ModifiablePasswordPolicyStateJSONField.PASSWORD_EXPIRATION_WARNED_TIME.getFieldName(), JSONNull.NULL);
            }
        }
        if (this.mustChangePassword != null) {
            fields.put(ModifiablePasswordPolicyStateJSONField.MUST_CHANGE_PASSWORD.getFieldName(), new JSONBoolean(this.mustChangePassword));
        }
        return new JSONObject(fields);
    }

    @NotNull
    public ModifiablePasswordPolicyStateJSON build() {
        return new ModifiablePasswordPolicyStateJSON(this.toJSONObject());
    }

    @NotNull
    public ModifyRequest toModifyRequest(@NotNull String userDN) {
        return new ModifyRequest(userDN, new Modification(ModificationType.REPLACE, "ds-pwp-modifiable-state-json", this.toJSONObject().toSingleLineString()));
    }

    @NotNull
    public String toString() {
        return this.toJSONObject().toString();
    }
}

