/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OIDRegistry;
import com.unboundid.util.OIDRegistryItem;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class OIDLookup
extends CommandLineTool {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @NotNull
    private static final String OUTPUT_FORMAT_CSV = "csv";
    @NotNull
    private static final String OUTPUT_FORMAT_JSON = "json";
    @NotNull
    private static final String OUTPUT_FORMAT_MULTI_LINE = "multi-line";
    @NotNull
    private static final String OUTPUT_FORMAT_TAB_DELIMITED = "tab-delimited";
    @Nullable
    private ArgumentParser parser = null;
    @Nullable
    private BooleanArgument exactMatchArg = null;
    @Nullable
    private BooleanArgument terseArg = null;
    @Nullable
    private FileArgument schemaPathArg = null;
    @Nullable
    private StringArgument outputFormatArg = null;

    public static void main(String ... args) {
        ResultCode resultCode = OIDLookup.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        OIDLookup tool = new OIDLookup(out, err);
        return tool.runTool(args);
    }

    public OIDLookup(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "oid-lookup";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return ToolMessages.INFO_OID_LOOKUP_TOOL_DESC_1.get();
    }

    @Override
    @NotNull
    public List<String> getAdditionalDescriptionParagraphs() {
        return Collections.singletonList(ToolMessages.INFO_OID_LOOKUP_TOOL_DESC_2.get());
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.7";
    }

    @Override
    public int getMinTrailingArguments() {
        return 0;
    }

    @Override
    public int getMaxTrailingArguments() {
        return 1;
    }

    @Override
    @NotNull
    public String getTrailingArgumentsPlaceholder() {
        return ToolMessages.INFO_OID_LOOKUP_TRAILING_ARG_PLACEHOLDER.get();
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return false;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return false;
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        this.schemaPathArg = new FileArgument(null, "schema-path", false, 0, null, ToolMessages.INFO_OID_LOOKUP_ARG_DESC_SCHEMA_PATH.get(), true, true, false, false);
        this.schemaPathArg.addLongIdentifier("schemaPath", true);
        this.schemaPathArg.addLongIdentifier("schema-file", true);
        this.schemaPathArg.addLongIdentifier("schemaFile", true);
        this.schemaPathArg.addLongIdentifier("schema-directory", true);
        this.schemaPathArg.addLongIdentifier("schemaDirectory", true);
        this.schemaPathArg.addLongIdentifier("schema-dir", true);
        this.schemaPathArg.addLongIdentifier("schemaDir", true);
        this.schemaPathArg.addLongIdentifier("schema", true);
        parser.addArgument(this.schemaPathArg);
        this.outputFormatArg = new StringArgument(null, "output-format", false, 1, ToolMessages.INFO_OID_LOOKUP_ARG_PLACEHOLDER_OUTPUT_FORMAT.get(), ToolMessages.INFO_OID_LOOKUP_ARG_DESC_OUTPUT_FORMAT.get(), StaticUtils.setOf(OUTPUT_FORMAT_CSV, OUTPUT_FORMAT_JSON, OUTPUT_FORMAT_MULTI_LINE, OUTPUT_FORMAT_TAB_DELIMITED), OUTPUT_FORMAT_MULTI_LINE);
        this.outputFormatArg.addLongIdentifier("outputFormat", true);
        this.outputFormatArg.addLongIdentifier("format", true);
        parser.addArgument(this.outputFormatArg);
        this.exactMatchArg = new BooleanArgument(null, "exact-match", 1, ToolMessages.INFO_OID_LOOKUP_ARG_DESC_EXACT_MATCH.get());
        this.exactMatchArg.addLongIdentifier("exactMatch", true);
        this.exactMatchArg.addLongIdentifier("exact", true);
        parser.addArgument(this.exactMatchArg);
        this.terseArg = new BooleanArgument(null, "terse", 1, ToolMessages.INFO_OID_LOOKUP_ARG_DESC_TERSE.get());
        parser.addArgument(this.terseArg);
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        String outputFormat;
        Collection<OIDRegistryItem> matchingItems;
        OIDRegistry oidRegistry = OIDRegistry.getDefault();
        List<File> schemaPaths = Collections.emptyList();
        if (this.schemaPathArg != null && this.schemaPathArg.isPresent()) {
            schemaPaths = this.schemaPathArg.getValues();
        } else {
            try {
                File instanceRootSchemaDir;
                File instanceRoot = InternalSDKHelper.getPingIdentityServerRoot();
                if (instanceRoot != null && new File(instanceRootSchemaDir = StaticUtils.constructPath(instanceRoot, "config", "schema"), "00-core.ldif").exists()) {
                    schemaPaths = Collections.singletonList(instanceRootSchemaDir);
                }
            }
            catch (Throwable instanceRoot) {
                // empty catch block
            }
        }
        if (!schemaPaths.isEmpty()) {
            try {
                oidRegistry = OIDLookup.augmentOIDRegistry(oidRegistry, schemaPaths);
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.wrapErr(0, WRAP_COLUMN, e.getMessage());
                return e.getResultCode();
            }
        }
        if (this.parser != null && !this.parser.getTrailingArguments().isEmpty()) {
            matchingItems = new ArrayList<OIDRegistryItem>();
            String lowerSearchString = StaticUtils.toLowerCase(this.parser.getTrailingArguments().get(0));
            for (OIDRegistryItem item : oidRegistry.getItems().values()) {
                if (!OIDLookup.itemMatchesSearchString(item, lowerSearchString, this.exactMatchArg.isPresent())) continue;
                matchingItems.add(item);
            }
        } else {
            matchingItems = oidRegistry.getItems().values();
        }
        boolean json = false;
        ColumnFormatter columnFormatter = null;
        if (this.outputFormatArg != null && this.outputFormatArg.isPresent() && (outputFormat = this.outputFormatArg.getValue()) != null) {
            if (outputFormat.equalsIgnoreCase(OUTPUT_FORMAT_CSV)) {
                columnFormatter = new ColumnFormatter(false, null, OutputFormat.CSV, null, new FormattableColumn(1, HorizontalAlignment.LEFT, "OID"), new FormattableColumn(1, HorizontalAlignment.LEFT, "Name"), new FormattableColumn(1, HorizontalAlignment.LEFT, "Type"), new FormattableColumn(1, HorizontalAlignment.LEFT, "Origin"), new FormattableColumn(1, HorizontalAlignment.LEFT, "URL"));
            } else if (outputFormat.equalsIgnoreCase(OUTPUT_FORMAT_JSON)) {
                json = true;
            } else if (outputFormat.equalsIgnoreCase(OUTPUT_FORMAT_TAB_DELIMITED)) {
                columnFormatter = new ColumnFormatter(false, null, OutputFormat.TAB_DELIMITED_TEXT, null, new FormattableColumn(1, HorizontalAlignment.LEFT, "OID"), new FormattableColumn(1, HorizontalAlignment.LEFT, "Name"), new FormattableColumn(1, HorizontalAlignment.LEFT, "Type"), new FormattableColumn(1, HorizontalAlignment.LEFT, "Origin"), new FormattableColumn(1, HorizontalAlignment.LEFT, "URL"));
            }
        }
        int numMatches = matchingItems.size();
        switch (numMatches) {
            case 0: {
                this.wrapComment(ToolMessages.WARN_OID_LOOKUP_NO_MATCHES.get());
                return ResultCode.NO_RESULTS_RETURNED;
            }
            case 1: {
                this.wrapComment(ToolMessages.INFO_OID_LOOKUP_ONE_MATCH.get());
                break;
            }
            default: {
                this.wrapComment(ToolMessages.INFO_OID_LOOKUP_MULTIPLE_MATCHES.get(numMatches));
            }
        }
        if (columnFormatter != null) {
            for (String line : columnFormatter.getHeaderLines(false)) {
                this.out(line);
            }
        }
        for (OIDRegistryItem item : matchingItems) {
            String url;
            if (json) {
                this.out(item.asJSONObject().toSingleLineString());
                continue;
            }
            if (columnFormatter != null) {
                this.out(columnFormatter.formatRow(item.getOID(), item.getName(), item.getType(), item.getOrigin(), item.getURL()));
                continue;
            }
            this.out(new Object[0]);
            this.out(ToolMessages.INFO_OID_LOOKUP_OUTPUT_LINE_OID.get(item.getOID()));
            this.out(ToolMessages.INFO_OID_LOOKUP_OUTPUT_LINE_NAME.get(item.getName()));
            this.out(ToolMessages.INFO_OID_LOOKUP_OUTPUT_LINE_TYPE.get(item.getType()));
            String origin = item.getOrigin();
            if (origin != null) {
                this.out(ToolMessages.INFO_OID_LOOKUP_OUTPUT_LINE_ORIGIN.get(origin));
            }
            if ((url = item.getURL()) == null) continue;
            this.out(ToolMessages.INFO_OID_LOOKUP_OUTPUT_LINE_URL.get(url));
        }
        return ResultCode.SUCCESS;
    }

    @NotNull
    private static OIDRegistry augmentOIDRegistry(@NotNull OIDRegistry registry, @NotNull List<File> schemaPaths) throws LDAPException {
        OIDRegistry oidRegistry = registry;
        for (File schemaPath : schemaPaths) {
            File[] files;
            if (schemaPath.isFile()) {
                oidRegistry = OIDLookup.augmentOIDRegistry(oidRegistry, schemaPath);
                continue;
            }
            if (!schemaPath.isDirectory() || (files = schemaPath.listFiles()) == null) continue;
            TreeMap<String, File> fileMap = new TreeMap<String, File>();
            for (File f : files) {
                fileMap.put(f.getName(), f);
            }
            for (File f : fileMap.values()) {
                oidRegistry = OIDLookup.augmentOIDRegistry(oidRegistry, f);
            }
        }
        return oidRegistry;
    }

    @NotNull
    private static OIDRegistry augmentOIDRegistry(@NotNull OIDRegistry registry, @NotNull File schemaFile) throws LDAPException {
        Schema schema;
        try {
            schema = Schema.getSchema(schemaFile);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_OID_LOOKUP_CANNOT_GET_SCHEMA_FROM_FILE.get(schemaFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
        if (schema == null) {
            return registry;
        }
        return registry.withSchema(schema);
    }

    private static boolean itemMatchesSearchString(@NotNull OIDRegistryItem item, @NotNull String lowerSearchString, boolean exactMatch) {
        return OIDLookup.matches(item.getOID(), lowerSearchString, exactMatch) || OIDLookup.matches(item.getName(), lowerSearchString, exactMatch) || OIDLookup.matches(item.getType(), lowerSearchString, exactMatch) || OIDLookup.matches(item.getOrigin(), lowerSearchString, exactMatch) || OIDLookup.matches(item.getURL(), lowerSearchString, exactMatch);
    }

    private static boolean matches(@Nullable String itemString, @NotNull String lowerSearchString, boolean exactMatch) {
        if (itemString == null) {
            return false;
        }
        String lowerItemString = StaticUtils.toLowerCase(itemString);
        if (exactMatch) {
            return lowerItemString.equals(lowerSearchString);
        }
        return lowerItemString.contains(lowerSearchString);
    }

    private void wrapComment(@NotNull String message) {
        boolean terse;
        boolean bl = terse = this.terseArg != null && this.terseArg.isPresent();
        if (!terse) {
            for (String line : StaticUtils.wrapLine(message, WRAP_COLUMN - 2)) {
                this.out("# ", line);
            }
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>();
        examples.put(StaticUtils.NO_STRINGS, ToolMessages.INFO_OID_LOOKUP_EXAMPLE_1.get());
        examples.put(new String[]{"--output-format", OUTPUT_FORMAT_JSON, "2.5.4.3"}, ToolMessages.INFO_OID_LOOKUP_EXAMPLE_2.get());
        return examples;
    }
}

