/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.ByteString;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ByteStringFactory {
    @NotNull
    private static final ASN1OctetString EMPTY_VALUE = new ASN1OctetString();

    private ByteStringFactory() {
    }

    @NotNull
    public static ByteString create() {
        return EMPTY_VALUE;
    }

    @NotNull
    public static ByteString create(@Nullable byte[] value) {
        return new ASN1OctetString(value);
    }

    @NotNull
    public static ByteString create(@NotNull byte[] value, int offset, int length) {
        return new ASN1OctetString(value, offset, length);
    }

    @NotNull
    public static ByteString create(@Nullable String value) {
        return new ASN1OctetString(value);
    }
}

