/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.DelimitedPayloadEncoding;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class DelimitedPayloadTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final String delimiter;
    private final DelimitedPayloadEncoding encoding;
    public static final JsonpDeserializer<DelimitedPayloadTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DelimitedPayloadTokenFilter::setupDelimitedPayloadTokenFilterDeserializer);

    private DelimitedPayloadTokenFilter(Builder builder) {
        super(builder);
        this.delimiter = ApiTypeHelper.requireNonNull(builder.delimiter, this, "delimiter");
        this.encoding = ApiTypeHelper.requireNonNull(builder.encoding, this, "encoding");
    }

    public static DelimitedPayloadTokenFilter of(Function<Builder, ObjectBuilder<DelimitedPayloadTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.DelimitedPayload;
    }

    public final String delimiter() {
        return this.delimiter;
    }

    public final DelimitedPayloadEncoding encoding() {
        return this.encoding;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "delimited_payload");
        super.serializeInternal(generator, mapper);
        generator.writeKey("delimiter");
        generator.write(this.delimiter);
        generator.writeKey("encoding");
        this.encoding.serialize(generator, mapper);
    }

    protected static void setupDelimitedPayloadTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        DelimitedPayloadTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::delimiter, JsonpDeserializer.stringDeserializer(), "delimiter");
        op.add(Builder::encoding, DelimitedPayloadEncoding._DESERIALIZER, "encoding");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DelimitedPayloadTokenFilter> {
        private String delimiter;
        private DelimitedPayloadEncoding encoding;

        public final Builder delimiter(String value) {
            this.delimiter = value;
            return this;
        }

        public final Builder encoding(DelimitedPayloadEncoding value) {
            this.encoding = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DelimitedPayloadTokenFilter build() {
            this._checkSingleUse();
            return new DelimitedPayloadTokenFilter(this);
        }
    }
}

