/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.james.jmap.draft.json.ObjectMapperFactory;
import org.apache.james.jmap.draft.methods.JmapRequest;
import org.apache.james.jmap.draft.methods.JmapRequestParser;
import org.apache.james.jmap.draft.model.InvocationRequest;

public class JmapRequestParserImpl
implements JmapRequestParser {
    private final ObjectMapper objectMapper;

    @Inject
    public JmapRequestParserImpl(ObjectMapperFactory objectMapperFactory) {
        this.objectMapper = objectMapperFactory.forParsing();
    }

    @Override
    public <T extends JmapRequest> T extractJmapRequest(InvocationRequest request, Class<T> requestClass) throws IOException, JsonParseException, JsonMappingException {
        Preconditions.checkNotNull(requestClass, (Object)"requestClass should not be null");
        return (T)((JmapRequest)this.objectMapper.treeToValue((TreeNode)request.getParameters(), requestClass));
    }
}

