/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.mailbox;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.io.FileNotFoundException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.opensearch.IndexName;
import org.apache.james.backends.opensearch.OpenSearchConfiguration;
import org.apache.james.backends.opensearch.OpenSearchIndexer;
import org.apache.james.backends.opensearch.ReactorOpenSearchClient;
import org.apache.james.backends.opensearch.ReadAliasName;
import org.apache.james.backends.opensearch.RoutingKey;
import org.apache.james.backends.opensearch.WriteAliasName;
import org.apache.james.events.EventListener;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.opensearch.IndexAttachments;
import org.apache.james.mailbox.opensearch.IndexHeaders;
import org.apache.james.mailbox.opensearch.MailboxIdRoutingKeyFactory;
import org.apache.james.mailbox.opensearch.MailboxIndexCreationUtil;
import org.apache.james.mailbox.opensearch.OpenSearchMailboxConfiguration;
import org.apache.james.mailbox.opensearch.events.OpenSearchListeningMessageSearchIndex;
import org.apache.james.mailbox.opensearch.query.QueryConverter;
import org.apache.james.mailbox.opensearch.search.OpenSearchSearcher;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import org.apache.james.mailbox.store.search.MessageSearchIndex;
import org.apache.james.modules.mailbox.OpenSearchQuotaSearcherModule;
import org.apache.james.modules.mailbox.OpenSearchStartUpCheck;
import org.apache.james.utils.ClassName;
import org.apache.james.utils.GuiceGenericLoader;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.james.utils.NamingScheme;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchMailboxModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchMailboxModule.class);
    public static final String OPENSEARCH_CONFIGURATION_NAME = "opensearch";

    protected void configure() {
        this.install((Module)new OpenSearchQuotaSearcherModule());
        this.bind(OpenSearchListeningMessageSearchIndex.class).in(Scopes.SINGLETON);
        this.bind(MessageSearchIndex.class).to(OpenSearchListeningMessageSearchIndex.class);
        this.bind(ListeningMessageSearchIndex.class).to(OpenSearchListeningMessageSearchIndex.class);
        this.bind((TypeLiteral)new TypeLiteral<RoutingKey.Factory<MailboxId>>(){}).to(MailboxIdRoutingKeyFactory.class);
        Multibinder.newSetBinder((Binder)this.binder(), EventListener.ReactiveGroupEventListener.class).addBinding().to(OpenSearchListeningMessageSearchIndex.class);
        Multibinder.newSetBinder((Binder)this.binder(), StartUpCheck.class).addBinding().to(OpenSearchStartUpCheck.class);
    }

    @Provides
    Set<ListeningMessageSearchIndex.SearchOverride> provideSearchOverrides(GuiceGenericLoader loader, OpenSearchConfiguration configuration) {
        return (Set)configuration.getSearchOverrides().stream().map(ClassName::new).map(Throwing.function(arg_0 -> ((GuiceGenericLoader.InvocationPerformer)loader.withNamingSheme(NamingScheme.IDENTITY)).instantiate(arg_0))).peek(routes -> LOGGER.info("Loading Search override {}", (Object)routes.getClass().getCanonicalName())).collect(ImmutableSet.toImmutableSet());
    }

    @Provides
    @Singleton
    @Named(value="mailbox")
    private OpenSearchIndexer createMailboxOpenSearchIndexer(ReactorOpenSearchClient client, OpenSearchMailboxConfiguration configuration) {
        return new OpenSearchIndexer(client, configuration.getWriteAliasMailboxName());
    }

    @Provides
    @Singleton
    private OpenSearchSearcher createMailboxOpenSearchSearcher(ReactorOpenSearchClient client, QueryConverter queryConverter, OpenSearchMailboxConfiguration configuration, RoutingKey.Factory<MailboxId> routingKeyFactory) {
        return new OpenSearchSearcher(client, queryConverter, 100, configuration.getReadAliasMailboxName(), routingKeyFactory);
    }

    @Provides
    @Singleton
    private OpenSearchConfiguration getOpenSearchConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration(OPENSEARCH_CONFIGURATION_NAME);
            return OpenSearchConfiguration.fromProperties((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find opensearch configuration file. Using {}:{} as contact point", (Object)"127.0.0.1", (Object)9200);
            return OpenSearchConfiguration.DEFAULT_CONFIGURATION;
        }
    }

    @Provides
    @Singleton
    private OpenSearchMailboxConfiguration getOpenSearchMailboxConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            Configuration configuration = propertiesProvider.getConfiguration(OPENSEARCH_CONFIGURATION_NAME);
            return OpenSearchMailboxConfiguration.fromProperties((Configuration)configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find opensearch configuration file. Providing a default OPENSearchMailboxConfiguration");
            return OpenSearchMailboxConfiguration.DEFAULT_CONFIGURATION;
        }
    }

    @Provides
    @Singleton
    public IndexAttachments provideIndexAttachments(OpenSearchMailboxConfiguration configuration) {
        return configuration.getIndexAttachment();
    }

    @Provides
    @Singleton
    public IndexHeaders provideIndexHeaders(OpenSearchMailboxConfiguration configuration) {
        return configuration.getIndexHeaders();
    }

    @ProvidesIntoSet
    InitializationOperation createIndex(MailboxIndexCreator instance) {
        return InitilizationOperationBuilder.forClass(MailboxIndexCreator.class).init(instance::createIndex);
    }

    static class MailboxIndexCreator
    implements Startable {
        private final OpenSearchConfiguration configuration;
        private final OpenSearchMailboxConfiguration mailboxConfiguration;
        private final ReactorOpenSearchClient client;

        @Inject
        MailboxIndexCreator(OpenSearchConfiguration configuration, OpenSearchMailboxConfiguration mailboxConfiguration, ReactorOpenSearchClient client) {
            this.configuration = configuration;
            this.mailboxConfiguration = mailboxConfiguration;
            this.client = client;
        }

        void createIndex() {
            MailboxIndexCreationUtil.prepareClient((ReactorOpenSearchClient)this.client, (ReadAliasName)this.mailboxConfiguration.getReadAliasMailboxName(), (WriteAliasName)this.mailboxConfiguration.getWriteAliasMailboxName(), (IndexName)this.mailboxConfiguration.getIndexMailboxName(), (OpenSearchConfiguration)this.configuration);
        }
    }
}

