/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.projections;

import java.time.OffsetDateTime;
import java.util.UUID;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.apache.james.mailbox.postgres.mail.PostgresMessageDataDefinition;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresEmailQueryViewDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresEmailQueryViewTable.TABLE}).addIndex(new PostgresIndex[]{PostgresEmailQueryViewTable.MAILBOX_ID_INDEX}).addIndex(new PostgresIndex[]{PostgresEmailQueryViewTable.MAILBOX_ID_RECEIVED_AT_INDEX}).addIndex(new PostgresIndex[]{PostgresEmailQueryViewTable.MAILBOX_ID_SENT_AT_INDEX}).build();

    public static interface PostgresEmailQueryViewTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"email_query_view");
        public static final Field<UUID> MAILBOX_ID = DSL.field((String)"mailbox_id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<UUID> MESSAGE_ID = PostgresMessageDataDefinition.MESSAGE_ID;
        public static final Field<OffsetDateTime> RECEIVED_AT = DSL.field((String)"received_at", (DataType)SQLDataType.TIMESTAMPWITHTIMEZONE.notNull());
        public static final Field<OffsetDateTime> SENT_AT = DSL.field((String)"sent_at", (DataType)SQLDataType.TIMESTAMPWITHTIMEZONE.notNull());
        public static final Name PK_CONSTRAINT_NAME = DSL.name((String)"email_query_view_pkey");
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(MAILBOX_ID).column(MESSAGE_ID).column(RECEIVED_AT).column(SENT_AT).constraint((Constraint)DSL.constraint((Name)PK_CONSTRAINT_NAME).primaryKey(new Field[]{MAILBOX_ID, MESSAGE_ID}))).supportsRowLevelSecurity().build();
        public static final PostgresIndex MAILBOX_ID_INDEX = PostgresIndex.name((String)"email_query_view_mailbox_id_index").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{MAILBOX_ID}));
        public static final PostgresIndex MAILBOX_ID_RECEIVED_AT_INDEX = PostgresIndex.name((String)"email_query_view_mailbox_id__received_at_index").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{MAILBOX_ID, RECEIVED_AT}));
        public static final PostgresIndex MAILBOX_ID_SENT_AT_INDEX = PostgresIndex.name((String)"email_query_view_mailbox_id_sent_at_index").createIndexStep((dslContext, indexName) -> dslContext.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{MAILBOX_ID, SENT_AT}));
    }
}

