/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.metadata;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.time.Clock;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.postgres.DeleteMessageListener;
import org.apache.james.mailbox.postgres.mail.MessageRepresentation;
import org.apache.james.mime4j.MimeIOException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.message.DefaultMessageBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.server.core.Envelope;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.DeletedMessageVault;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class PostgresDeletedMessageVaultDeletionCallback
implements DeleteMessageListener.DeletionCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresDeletedMessageVaultDeletionCallback.class);
    private final DeletedMessageVault deletedMessageVault;
    private final BlobStore blobStore;
    private final Clock clock;

    @Inject
    public PostgresDeletedMessageVaultDeletionCallback(DeletedMessageVault deletedMessageVault, BlobStore blobStore, Clock clock) {
        this.deletedMessageVault = deletedMessageVault;
        this.blobStore = blobStore;
        this.clock = clock;
    }

    public Mono<Void> forMessage(MessageRepresentation message, MailboxId mailboxId, Username owner) {
        return Mono.fromSupplier((Supplier)Throwing.supplier(() -> message.getHeaderContent().getInputStream())).flatMap(headerStream -> {
            Optional<Message> mimeMessage = this.parseMessage((InputStream)headerStream, message.getMessageId());
            DeletedMessage deletedMessage = ((DeletedMessage.Builder.FinalStage)((DeletedMessage.Builder.RequireSize)((DeletedMessage.Builder.RequireHasAttachment)((DeletedMessage.Builder.RequireRecipients)((DeletedMessage.Builder.Steps.RequireEnvelope)((DeletedMessage.Builder.RequireDeletionDate)((DeletedMessage.Builder.Steps.RequireDates)((DeletedMessage.Builder.RequireUser)((DeletedMessage.Builder.RequireOriginMailboxes)DeletedMessage.builder().messageId(message.getMessageId())).originMailboxes(new MailboxId[]{mailboxId})).user(owner)).deliveryDate(ZonedDateTime.ofInstant(message.getInternalDate().toInstant(), ZoneOffset.UTC))).deletionDate(ZonedDateTime.ofInstant(this.clock.instant(), ZoneOffset.UTC))).sender(this.retrieveSender(mimeMessage))).recipients(this.retrieveRecipients(mimeMessage))).hasAttachment(!message.getAttachments().isEmpty())).size(message.getSize().longValue())).subject(mimeMessage.map(Message::getSubject)).build();
            return Mono.from((Publisher)this.blobStore.readReactive(this.blobStore.getDefaultBucketName(), message.getBodyBlobId(), BlobStore.StoragePolicy.LOW_COST)).map(bodyStream -> new SequenceInputStream((InputStream)headerStream, (InputStream)bodyStream)).flatMap(bodyStream -> Mono.from((Publisher)this.deletedMessageVault.append(deletedMessage, (InputStream)bodyStream)));
        });
    }

    private Optional<Message> parseMessage(InputStream inputStream, MessageId messageId) {
        DefaultMessageBuilder messageBuilder = new DefaultMessageBuilder();
        messageBuilder.setMimeEntityConfig(MimeConfig.PERMISSIVE);
        messageBuilder.setDecodeMonitor(DecodeMonitor.SILENT);
        try {
            return Optional.ofNullable(messageBuilder.parseMessage(inputStream));
        }
        catch (MimeIOException e) {
            LOGGER.warn("Can not parse the message {}", (Object)messageId, (Object)e);
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private MaybeSender retrieveSender(Optional<Message> mimeMessage) {
        return mimeMessage.map(Message::getSender).map(Mailbox::getAddress).map(MaybeSender::getMailSender).orElse(MaybeSender.nullSender());
    }

    private Set<MailAddress> retrieveRecipients(Optional<Message> maybeMessage) {
        return maybeMessage.map(message -> Envelope.fromMime4JMessage((Message)message, (Envelope.ValidationPolicy)Envelope.ValidationPolicy.IGNORE)).map(Envelope::getRecipients).orElse((Set)ImmutableSet.of());
    }
}

